/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.IndexAwarePredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexImpl;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.QueryException;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class IndexService {
    final ConcurrentMap<String, Index> mapIndexes = new ConcurrentHashMap<String, Index>(3);
    final AtomicReference<Index[]> indexes = new AtomicReference();
    volatile boolean hasIndex = false;

    public synchronized Index destroyIndex(String attribute) {
        return (Index)this.mapIndexes.remove(attribute);
    }

    public synchronized Index addOrGetIndex(String attribute, boolean ordered) {
        Index index = (Index)this.mapIndexes.get(attribute);
        if (index != null) {
            return index;
        }
        index = new IndexImpl(attribute, ordered);
        this.mapIndexes.put(attribute, index);
        Object[] indexObjects = this.mapIndexes.values().toArray();
        Index[] newIndexes = new Index[indexObjects.length];
        for (int i = 0; i < indexObjects.length; ++i) {
            newIndexes[i] = (Index)indexObjects[i];
        }
        this.indexes.set(newIndexes);
        this.hasIndex = true;
        return index;
    }

    public Index[] getIndexes() {
        return this.indexes.get();
    }

    public void removeEntryIndex(Data indexKey) throws QueryException {
        for (Index index : this.indexes.get()) {
            index.removeEntryIndex(indexKey);
        }
    }

    public boolean hasIndex() {
        return this.hasIndex;
    }

    public void saveEntryIndex(QueryableEntry queryableEntry) throws QueryException {
        for (Index index : this.indexes.get()) {
            index.saveEntryIndex(queryableEntry);
        }
    }

    Index getIndex(String attribute) {
        return (Index)this.mapIndexes.get(attribute);
    }

    public Set<QueryableEntry> query(Predicate predicate) {
        if (this.hasIndex) {
            IndexAwarePredicate iap;
            QueryContext queryContext = new QueryContext(this);
            if (predicate instanceof IndexAwarePredicate && (iap = (IndexAwarePredicate)predicate).isIndexed(queryContext)) {
                return iap.filter(queryContext);
            }
        }
        return null;
    }
}

