/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.operations.CollectionKeyBasedOperation;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class PutBackupOperation
extends CollectionKeyBasedOperation
implements BackupOperation {
    long recordId;
    Data value;
    int index;

    public PutBackupOperation() {
    }

    public PutBackupOperation(CollectionProxyId proxyId, Data dataKey, Data value, long recordId, int index) {
        super(proxyId, dataKey);
        this.value = value;
        this.recordId = recordId;
        this.index = index;
    }

    @Override
    public void run() throws Exception {
        CollectionRecord record = new CollectionRecord(this.recordId, this.isBinary() ? this.value : this.toObject(this.value));
        Collection<CollectionRecord> coll = this.getOrCreateCollectionWrapper().getCollection();
        if (this.index == -1) {
            this.response = coll.add(record);
        } else {
            try {
                ((List)coll).add(this.index, record);
                this.response = true;
            }
            catch (IndexOutOfBoundsException e) {
                this.response = e;
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.recordId);
        out.writeInt(this.index);
        this.value.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.recordId = in.readLong();
        this.index = in.readInt();
        this.value = IOUtil.readData(in);
    }

    @Override
    public int getId() {
        return 15;
    }
}

