/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.security.configurations;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.airavata.security.AbstractAuthenticator;
import org.apache.airavata.security.Authenticator;
import org.apache.airavata.security.UserStore;
import org.apache.airavata.security.configurations.AbstractConfigurationReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AuthenticatorConfigurationReader
extends AbstractConfigurationReader {
    private List<Authenticator> authenticatorList = new ArrayList<Authenticator>();
    protected static Logger log = LoggerFactory.getLogger(AuthenticatorConfigurationReader.class);
    protected static boolean authenticationEnabled = true;

    @Override
    public void init(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        String enabledAttribute;
        authenticationEnabled = true;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(inputStream);
        doc.getDocumentElement().normalize();
        NodeList rootNodeList = doc.getElementsByTagName("authenticators");
        if (rootNodeList == null || rootNodeList.getLength() == 0) {
            throw new ParserConfigurationException("authenticators.xml should have authenticators root element.");
        }
        Node authenticatorsNode = rootNodeList.item(0);
        NamedNodeMap rootAttributes = authenticatorsNode.getAttributes();
        if (rootAttributes != null && rootAttributes.getNamedItem("enabled") != null && (enabledAttribute = rootAttributes.getNamedItem("enabled").getNodeValue()) != null && enabledAttribute.equals("false")) {
            authenticationEnabled = false;
        }
        NodeList authenticators = doc.getElementsByTagName("authenticator");
        for (int i = 0; i < authenticators.getLength(); ++i) {
            Node node = authenticators.item(i);
            if (node.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            String name = namedNodeMap.getNamedItem("name").getNodeValue();
            String className = namedNodeMap.getNamedItem("class").getNodeValue();
            String enabled = namedNodeMap.getNamedItem("enabled").getNodeValue();
            String priority = namedNodeMap.getNamedItem("priority").getNodeValue();
            String userStoreClass = namedNodeMap.getNamedItem("userstore").getNodeValue();
            if (className == null) {
                this.reportError("class");
            }
            if (userStoreClass == null) {
                this.reportError("userstore");
            }
            Authenticator authenticator = this.createAuthenticator(name, className, enabled, priority, userStoreClass);
            NodeList configurationNodes = node.getChildNodes();
            for (int j = 0; j < configurationNodes.getLength(); ++j) {
                Node configurationNode = configurationNodes.item(j);
                if (configurationNode.getNodeType() != 1 || !configurationNode.getNodeName().equals("specificConfigurations")) continue;
                authenticator.configure(configurationNode);
            }
            if (authenticator.isEnabled()) {
                this.authenticatorList.add(authenticator);
            }
            Collections.sort(this.authenticatorList, new AuthenticatorComparator());
            StringBuilder stringBuilder = new StringBuilder("Successfully initialized authenticator ");
            stringBuilder.append(name).append(" with class ").append(className).append(" enabled? ").append(enabled).append(" priority = ").append(priority);
            log.debug(stringBuilder.toString());
        }
    }

    private void reportError(String element) throws ParserConfigurationException {
        throw new ParserConfigurationException("Error in configuration. Missing mandatory element " + element);
    }

    protected Authenticator createAuthenticator(String name, String className, String enabled, String priority, String userStoreClassName) {
        Class<?> authenticatorClass;
        log.debug("Loading authenticator class " + className + " and name " + name);
        try {
            authenticatorClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            log.error("Error loading authenticator class " + className);
            throw new RuntimeException("Error loading authenticator class " + className, e);
        }
        try {
            AbstractAuthenticator authenticatorInstance = (AbstractAuthenticator)authenticatorClass.newInstance();
            authenticatorInstance.setAuthenticatorName(name);
            if (enabled != null) {
                authenticatorInstance.setEnabled(Boolean.parseBoolean(enabled));
            }
            if (priority != null) {
                authenticatorInstance.setPriority(Integer.parseInt(priority));
            }
            UserStore userStore = this.createUserStore(userStoreClassName);
            authenticatorInstance.setUserStore(userStore);
            return authenticatorInstance;
        }
        catch (InstantiationException e) {
            String error = "Error instantiating authenticator class " + className + " object.";
            log.error(error);
            throw new RuntimeException(error, e);
        }
        catch (IllegalAccessException e) {
            String error = "Not allowed to instantiate authenticator class " + className;
            log.error(error);
            throw new RuntimeException(error, e);
        }
    }

    protected UserStore createUserStore(String userStoreClassName) {
        try {
            Class<?> userStoreClass = Class.forName(userStoreClassName, true, Thread.currentThread().getContextClassLoader());
            return (UserStore)userStoreClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error("Error loading authenticator class " + userStoreClassName);
            throw new RuntimeException("Error loading authenticator class " + userStoreClassName, e);
        }
        catch (InstantiationException e) {
            String error = "Error instantiating authenticator class " + userStoreClassName + " object.";
            log.error(error);
            throw new RuntimeException(error, e);
        }
        catch (IllegalAccessException e) {
            String error = "Not allowed to instantiate authenticator class " + userStoreClassName;
            log.error(error);
            throw new RuntimeException(error, e);
        }
    }

    public List<Authenticator> getAuthenticatorList() {
        return Collections.unmodifiableList(this.authenticatorList);
    }

    public static boolean isAuthenticationEnabled() {
        return authenticationEnabled;
    }

    public class AuthenticatorComparator
    implements Comparator<Authenticator> {
        @Override
        public int compare(Authenticator o1, Authenticator o2) {
            return o1.getPriority() > o2.getPriority() ? -1 : (o1.getPriority() == o2.getPriority() ? 0 : 1);
        }
    }
}

