/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.messaging.core.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.QueueingConsumer;
import java.io.IOException;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.MessageHandler;
import org.apache.airavata.model.dbevent.DBEventMessage;
import org.apache.airavata.model.messaging.event.Message;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;

public class MessageConsumer
extends QueueingConsumer {
    private static final Logger logger = LogManager.getLogger(MessageConsumer.class);
    private MessageHandler handler;
    private Channel channel;
    private Connection connection;

    public MessageConsumer(MessageHandler messageHandler, Connection connection, Channel channel) {
        super(channel);
        this.handler = messageHandler;
        this.connection = connection;
        this.channel = channel;
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        Message message = new Message();
        try {
            logger.info((Object)("handleDelivery() -> Handling message delivery. Consumer Tag : " + consumerTag));
            ThriftUtils.createThriftFromBytes((byte[])body, (TBase)message);
            DBEventMessage dBEventMessage = new DBEventMessage();
            ThriftUtils.createThriftFromBytes((byte[])message.getEvent(), (TBase)dBEventMessage);
            MessageContext messageContext = new MessageContext((TBase)dBEventMessage, message.getMessageType(), message.getMessageId(), "gatewayId", envelope.getDeliveryTag());
            this.handler.onMessage(messageContext);
        }
        catch (TException e) {
            logger.error((Object)("handleDelivery() -> Error handling delivery. Consumer Tag : " + consumerTag), (Throwable)e);
        }
    }

    private void sendAck(long deliveryTag) {
        logger.info((Object)("sendAck() -> Sending ack. Delivery Tag : " + deliveryTag));
        try {
            if (this.channel.isOpen()) {
                this.channel.basicAck(deliveryTag, false);
            } else {
                this.channel = this.connection.createChannel();
                this.channel.basicQos(20);
                this.channel.basicAck(deliveryTag, false);
            }
        }
        catch (IOException e) {
            logger.error((Object)("sendAck() -> Error sending ack. Delivery Tag : " + deliveryTag), (Throwable)e);
        }
    }
}

