/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class Version {
    public String PROJECT_NAME;
    private Integer majorVersion = 0;
    private Integer minorVersion = 0;
    private Integer maintenanceVersion;
    private String versionData;
    private BuildType buildType;

    public Version() {
    }

    public Version(String PROJECT_NAME, Integer majorVersion, Integer minorVersion, Integer maintenanceVersion, String versionData, BuildType buildType) {
        this.PROJECT_NAME = PROJECT_NAME;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.maintenanceVersion = maintenanceVersion;
        this.versionData = versionData;
        this.buildType = buildType;
    }

    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    public Integer getMaintenanceVersion() {
        return this.maintenanceVersion;
    }

    public String getVersionData() {
        return this.versionData;
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    public String getVersion() {
        String version = this.getBaseVersion();
        version = this.attachVersionData(version);
        return version;
    }

    private String attachVersionData(String version) {
        if (this.getVersionData() != null) {
            version = version + "-" + this.getVersionData();
        }
        return version;
    }

    public String getBaseVersion() {
        String version = this.getMajorVersion().toString() + "." + this.getMinorVersion();
        return version;
    }

    public String getFullVersion() {
        String version = this.getBaseVersion();
        version = this.attachMaintainanceVersion(version);
        version = this.attachVersionData(version);
        version = this.attachBuildType(version);
        return version;
    }

    private String attachMaintainanceVersion(String version) {
        if (this.getMaintenanceVersion() != null) {
            version = version + "." + this.getMaintenanceVersion();
        }
        return version;
    }

    private String attachBuildType(String version) {
        if (this.getBuildType() != null) {
            version = version + "-" + this.getBuildType().name();
        }
        return version;
    }

    public String toString() {
        return this.getVersion();
    }

    public static enum BuildType {
        ALPHA,
        BETA,
        RC;

    }
}

