/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.trust;

import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.WeakTimerTask;
import eu.emi.security.authn.x509.helpers.trust.AbstractTrustAnchorStore;
import java.util.Timer;
import java.util.TimerTask;

public abstract class TimedTrustAnchorStoreBase
extends AbstractTrustAnchorStore {
    private Timer timer;

    public TimedTrustAnchorStoreBase(Timer timer, long updateInterval, ObserversHandler observers) {
        super(updateInterval, observers);
        this.timer = timer;
    }

    @Override
    public synchronized void setUpdateInterval(long newInterval) {
        long old = this.getUpdateInterval();
        this.updateInterval = newInterval;
        if (old <= 0L) {
            this.scheduleUpdate();
        }
    }

    protected void scheduleUpdate() {
        long updateInterval = this.getUpdateInterval();
        if (updateInterval > 0L) {
            this.timer.schedule((TimerTask)new AsyncTrustAnchorsUpdateTask(this), updateInterval);
        }
    }

    protected abstract void update();

    @Override
    public void dispose() {
        this.setUpdateInterval(-1L);
    }

    private static class AsyncTrustAnchorsUpdateTask
    extends WeakTimerTask<TimedTrustAnchorStoreBase> {
        public AsyncTrustAnchorsUpdateTask(TimedTrustAnchorStoreBase partner) {
            super(partner);
        }

        @Override
        public void run() {
            TimedTrustAnchorStoreBase partner = (TimedTrustAnchorStoreBase)this.partnerRef.get();
            if (partner == null) {
                return;
            }
            try {
                if (partner.getUpdateInterval() > 0L) {
                    partner.update();
                }
                partner.scheduleUpdate();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }
}

