/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.proxy;

import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class ProxyTracingExtension
extends ASN1Object {
    public static final String PROXY_TRACING_ISSUER_EXTENSION_OID = "1.2.840.113612.5.5.1.1.1.1";
    public static final String PROXY_TRACING_SUBJECT_EXTENSION_OID = "1.2.840.113612.5.5.1.1.1.2";
    public static final int ISSUER_EXTENSION = 1;
    public static final int SUBJECT_EXTENSION = 2;
    private GeneralNames names = null;
    private GeneralName name = null;

    public ProxyTracingExtension(String url) {
        this.name = new GeneralName(6, url);
        this.names = new GeneralNames(this.name);
    }

    public ProxyTracingExtension(byte[] bytes) throws IOException {
        this.names = GeneralNames.getInstance((Object)ASN1Primitive.fromByteArray((byte[])bytes));
        this.name = this.names.getNames()[0];
    }

    public static ProxyTracingExtension getInstance(X509Certificate cert, boolean issuer) throws IOException {
        byte[] bytes = CertificateHelpers.getExtensionBytes(cert, issuer ? PROXY_TRACING_ISSUER_EXTENSION_OID : PROXY_TRACING_SUBJECT_EXTENSION_OID);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new ProxyTracingExtension(bytes);
    }

    public String getURL() {
        if (this.name.getTagNo() != 6) {
            return null;
        }
        DERIA5String ia5String = (DERIA5String)this.name.getName();
        return ia5String.getString();
    }

    public GeneralNames getNames() {
        return this.names;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.names.toASN1Primitive();
    }
}

