/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.YieldCallback;
import org.apache.accumulo.core.iteratorsImpl.system.IterationInterruptedException;
import org.apache.accumulo.core.iteratorsImpl.system.SourceSwitchingIterator;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.ShutdownUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.TooManyFilesException;
import org.apache.accumulo.server.mem.LowMemoryDetector;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.TabletHostingServer;
import org.apache.accumulo.tserver.TabletServerResourceManager;
import org.apache.accumulo.tserver.metrics.TabletServerScanMetrics;
import org.apache.accumulo.tserver.scan.ScanParameters;
import org.apache.accumulo.tserver.tablet.Batch;
import org.apache.accumulo.tserver.tablet.KVEntry;
import org.apache.accumulo.tserver.tablet.ScanDataSource;
import org.apache.accumulo.tserver.tablet.Scanner;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.accumulo.tserver.tablet.TabletClosedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TabletBase {
    private static final Logger log = LoggerFactory.getLogger(TabletBase.class);
    private static final byte[] EMPTY_BYTES = new byte[0];
    protected final KeyExtent extent;
    protected final ServerContext context;
    private final TabletHostingServer server;
    protected AtomicLong lookupCount = new AtomicLong(0L);
    protected AtomicLong queryResultCount = new AtomicLong(0L);
    protected AtomicLong queryResultBytes = new AtomicLong(0L);
    protected final AtomicLong scannedCount = new AtomicLong(0L);
    protected final Set<ScanDataSource> activeScans = new HashSet<ScanDataSource>();
    private final AccumuloConfiguration.Deriver<byte[]> defaultSecurityLabel;
    protected final TableConfiguration tableConfiguration;
    private final boolean isUserTable;

    public TabletBase(TabletHostingServer server, KeyExtent extent) {
        this.context = server.getContext();
        this.server = server;
        this.extent = extent;
        this.isUserTable = !extent.isMeta();
        TableConfiguration tblConf = this.context.getTableConfiguration(extent.tableId());
        if (tblConf == null) {
            this.context.clearTableListCache();
            tblConf = this.context.getTableConfiguration(extent.tableId());
            Objects.requireNonNull(tblConf, "Could not get table configuration for " + extent.tableId());
        }
        this.tableConfiguration = tblConf;
        this.defaultSecurityLabel = extent.isMeta() ? () -> EMPTY_BYTES : this.tableConfiguration.newDeriver(conf -> new ColumnVisibility(conf.get(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY)).getExpression());
    }

    public abstract boolean isClosed();

    public abstract SortedMap<StoredTabletFile, DataFileValue> getDatafiles();

    public abstract void addToYieldMetric(int var1);

    public abstract long getDataSourceDeletions();

    abstract TabletServerResourceManager.TabletResourceManager getTabletResources();

    public abstract List<InMemoryMap.MemoryIterator> getMemIterators(SamplerConfigurationImpl var1);

    public abstract void returnMemIterators(List<InMemoryMap.MemoryIterator> var1);

    public abstract Pair<Long, Map<StoredTabletFile, DataFileValue>> reserveFilesForScan();

    public abstract void returnFilesForScan(long var1);

    public abstract TabletServerScanMetrics getScanMetrics();

    protected ScanDataSource createDataSource(ScanParameters scanParams, boolean loadIters, AtomicBoolean interruptFlag) {
        return new ScanDataSource(this, scanParams, loadIters, interruptFlag);
    }

    public Scanner createScanner(Range range, ScanParameters scanParams, AtomicBoolean interruptFlag) {
        this.extent.toDataRange().clip(range);
        return new Scanner(this, range, scanParams, interruptFlag);
    }

    public AtomicLong getScannedCounter() {
        return this.scannedCount;
    }

    public ServerContext getContext() {
        return this.context;
    }

    public TableConfiguration getTableConfiguration() {
        return this.tableConfiguration;
    }

    public KeyExtent getExtent() {
        return this.extent;
    }

    public byte[] getDefaultSecurityLabels() {
        return (byte[])this.defaultSecurityLabel.derive();
    }

    public synchronized void addActiveScans(ScanDataSource scanDataSource) {
        this.activeScans.add(scanDataSource);
    }

    public int removeScan(ScanDataSource scanDataSource) {
        this.activeScans.remove(scanDataSource);
        return this.activeScans.size();
    }

    public abstract void close(boolean var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tablet.LookupResult lookup(List<Range> ranges, List<KVEntry> results, ScanParameters scanParams, long maxResultSize, AtomicBoolean interruptFlag) throws IOException {
        if (ranges.isEmpty()) {
            return new Tablet.LookupResult();
        }
        if ((ranges = Range.mergeOverlapping(ranges)).size() > 1) {
            Collections.sort(ranges);
        }
        Range tabletRange = this.getExtent().toDataRange();
        for (Range range : ranges) {
            tabletRange.clip(range);
        }
        ScanDataSource dataSource = this.createDataSource(scanParams, true, interruptFlag);
        Tablet.LookupResult result = null;
        boolean sawException = false;
        try {
            SourceSwitchingIterator iter = new SourceSwitchingIterator((SourceSwitchingIterator.DataSource)dataSource);
            this.lookupCount.incrementAndGet();
            this.server.getScanMetrics().incrementLookupCount(1L);
            Tablet.LookupResult lookupResult = result = this.lookup((SortedKeyValueIterator<Key, Value>)iter, ranges, results, scanParams, maxResultSize);
            return lookupResult;
        }
        catch (IOException | RuntimeException e) {
            sawException = true;
            throw e;
        }
        finally {
            dataSource.close(sawException);
            TabletBase tabletBase = this;
            synchronized (tabletBase) {
                this.queryResultCount.addAndGet(results.size());
                this.server.getScanMetrics().incrementQueryResultCount(results.size());
                if (result != null) {
                    this.queryResultBytes.addAndGet(result.dataSize);
                    this.server.getScanMetrics().incrementQueryResultBytes(result.dataSize);
                }
            }
        }
    }

    Batch nextBatch(SortedKeyValueIterator<Key, Value> iter, Range range, ScanParameters scanParams) throws IOException {
        while (this.context.getLowMemoryDetector().isRunningLowOnMemory(this.context, LowMemoryDetector.DetectionScope.SCAN, () -> this.isUserTable, () -> {
            log.info("Not starting next batch because low on memory, extent: {}", (Object)this.extent);
            this.server.getScanMetrics().incrementScanPausedForLowMemory();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while waiting for low memory condition to resolve", e);
            }
        })) {
        }
        long batchTimeOut = scanParams.getBatchTimeOut();
        long timeToRun = TimeUnit.MILLISECONDS.toNanos(batchTimeOut);
        long startNanos = System.nanoTime();
        if (batchTimeOut == Long.MAX_VALUE || batchTimeOut <= 0L) {
            batchTimeOut = 0L;
        }
        ArrayList<KVEntry> results = new ArrayList<KVEntry>();
        Key key = null;
        long resultSize = 0L;
        long resultBytes = 0L;
        long maxResultsSize = this.getTableConfiguration().getAsBytes(Property.TABLE_SCAN_MAXMEM);
        Key continueKey = null;
        boolean skipContinueKey = false;
        YieldCallback yield = new YieldCallback();
        if (!scanParams.isIsolated()) {
            iter.enableYielding(yield);
        }
        if (scanParams.getColumnSet().isEmpty()) {
            iter.seek(range, Set.of(), false);
        } else {
            iter.seek(range, (Collection)LocalityGroupUtil.families(scanParams.getColumnSet()), true);
        }
        while (iter.hasTop()) {
            if (yield.hasYielded()) {
                throw new IOException("Coding error: hasTop returned true but has yielded at " + yield.getPositionAndReset());
            }
            Value value = (Value)iter.getTopValue();
            key = (Key)iter.getTopKey();
            KVEntry kvEntry = new KVEntry(key, value);
            results.add(kvEntry);
            resultBytes += (long)kvEntry.numBytes();
            boolean timesUp = batchTimeOut > 0L && System.nanoTime() - startNanos >= timeToRun;
            boolean runningLowOnMemory = this.context.getLowMemoryDetector().isRunningLowOnMemory(this.context, LowMemoryDetector.DetectionScope.SCAN, () -> this.isUserTable, () -> {
                log.info("Not continuing next batch because low on memory, extent: {}", (Object)this.extent);
                this.server.getScanMetrics().incrementEarlyReturnForLowMemory();
            });
            if (runningLowOnMemory || (resultSize += (long)kvEntry.estimateMemoryUsed()) >= maxResultsSize || results.size() >= scanParams.getMaxEntries() || timesUp) {
                continueKey = new Key(key);
                skipContinueKey = true;
                break;
            }
            iter.next();
        }
        if (yield.hasYielded()) {
            continueKey = new Key((Key)yield.getPositionAndReset());
            skipContinueKey = true;
            if (!range.contains(continueKey)) {
                throw new IOException("Underlying iterator yielded to a position outside of its range: " + continueKey + " not in " + range);
            }
            if (!results.isEmpty() && continueKey.compareTo((Key)((KVEntry)((Object)results.get(results.size() - 1))).getKey()) <= 0) {
                throw new IOException("Underlying iterator yielded to a position that does not follow the last key returned: " + continueKey + " <= " + ((KVEntry)((Object)results.get(results.size() - 1))).getKey());
            }
            log.debug("Scan yield detected at position " + continueKey);
            this.addToYieldMetric(1);
        } else if (!iter.hasTop()) {
            continueKey = null;
            if (results.isEmpty()) {
                results = null;
            }
        }
        return new Batch(skipContinueKey, results, continueKey, resultBytes);
    }

    private Tablet.LookupResult lookup(SortedKeyValueIterator<Key, Value> mmfi, List<Range> ranges, List<KVEntry> results, ScanParameters scanParams, long maxResultsSize) throws IOException {
        while (this.context.getLowMemoryDetector().isRunningLowOnMemory(this.context, LowMemoryDetector.DetectionScope.SCAN, () -> this.isUserTable, () -> {
            log.info("Not starting lookup because low on memory, extent: {}", (Object)this.extent);
            this.server.getScanMetrics().incrementScanPausedForLowMemory();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while waiting for low memory condition to resolve", e);
            }
        })) {
        }
        Tablet.LookupResult lookupResult = new Tablet.LookupResult();
        boolean exceededMemoryUsage = false;
        boolean tabletClosed = false;
        Set cfset = null;
        if (!scanParams.getColumnSet().isEmpty()) {
            cfset = LocalityGroupUtil.families(scanParams.getColumnSet());
        }
        long batchTimeOut = scanParams.getBatchTimeOut();
        long timeToRun = TimeUnit.MILLISECONDS.toNanos(batchTimeOut);
        long startNanos = System.nanoTime();
        if (batchTimeOut <= 0L || batchTimeOut == Long.MAX_VALUE) {
            batchTimeOut = 0L;
        }
        YieldCallback yield = new YieldCallback();
        mmfi.enableYielding(yield);
        boolean yielded = false;
        for (Range range : ranges) {
            boolean timesUp = batchTimeOut > 0L && System.nanoTime() - startNanos > timeToRun;
            boolean runningLowOnMemory = this.context.getLowMemoryDetector().isRunningLowOnMemory(this.context, LowMemoryDetector.DetectionScope.SCAN, () -> this.isUserTable, () -> {
                log.info("Not continuing lookup because low on memory, extent: {}", (Object)this.extent);
                this.server.getScanMetrics().incrementEarlyReturnForLowMemory();
            });
            if (runningLowOnMemory || exceededMemoryUsage || tabletClosed || timesUp || yielded) {
                lookupResult.unfinishedRanges.add(range);
                continue;
            }
            int entriesAdded = 0;
            try {
                if (cfset != null) {
                    mmfi.seek(range, (Collection)cfset, true);
                } else {
                    mmfi.seek(range, Set.of(), false);
                }
                while (mmfi.hasTop()) {
                    if (yield.hasYielded()) {
                        throw new IOException("Coding error: hasTop returned true but has yielded at " + yield.getPositionAndReset());
                    }
                    Key key = (Key)mmfi.getTopKey();
                    KVEntry kve = new KVEntry(key, (Value)mmfi.getTopValue());
                    results.add(kve);
                    ++entriesAdded;
                    lookupResult.bytesAdded += (long)kve.estimateMemoryUsed();
                    lookupResult.dataSize += (long)kve.numBytes();
                    exceededMemoryUsage = lookupResult.bytesAdded > maxResultsSize;
                    timesUp = batchTimeOut > 0L && System.nanoTime() - startNanos > timeToRun;
                    runningLowOnMemory = this.context.getLowMemoryDetector().isRunningLowOnMemory(this.context, LowMemoryDetector.DetectionScope.SCAN, () -> this.isUserTable, () -> {
                        log.info("Not continuing lookup because low on memory, extent: {}", (Object)this.extent);
                        this.server.getScanMetrics().incrementEarlyReturnForLowMemory();
                    });
                    if (runningLowOnMemory || exceededMemoryUsage || timesUp) {
                        this.addUnfinishedRange(lookupResult, range, key);
                        break;
                    }
                    mmfi.next();
                }
                if (!yield.hasYielded()) continue;
                yielded = true;
                Key yieldPosition = (Key)yield.getPositionAndReset();
                if (!range.contains(yieldPosition)) {
                    throw new IOException("Underlying iterator yielded to a position outside of its range: " + yieldPosition + " not in " + range);
                }
                if (!results.isEmpty() && yieldPosition.compareTo((Key)results.get(results.size() - 1).getKey()) <= 0) {
                    throw new IOException("Underlying iterator yielded to a position that does not follow the last key returned: " + yieldPosition + " <= " + results.get(results.size() - 1).getKey());
                }
                this.addUnfinishedRange(lookupResult, range, yieldPosition);
                log.debug("Scan yield detected at position " + yieldPosition);
                this.addToYieldMetric(1);
            }
            catch (TooManyFilesException tmfe) {
                log.warn("Tablet {} has too many files, batch lookup can not run", (Object)this.getExtent());
                this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                tabletClosed = true;
            }
            catch (IOException ioe) {
                if (ShutdownUtil.wasCausedByHadoopShutdown((Exception)ioe)) {
                    log.debug("IOException while shutdown in progress", (Throwable)ioe);
                    this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                    tabletClosed = true;
                    continue;
                }
                throw ioe;
            }
            catch (IterationInterruptedException iie) {
                if (this.isClosed()) {
                    this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                    tabletClosed = true;
                    continue;
                }
                throw iie;
            }
            catch (TabletClosedException tce) {
                this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                tabletClosed = true;
            }
            catch (RuntimeException re) {
                if (ShutdownUtil.wasCausedByHadoopShutdown((Exception)re)) {
                    log.debug("RuntimeException while shutdown in progress", (Throwable)re);
                    this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                    tabletClosed = true;
                    continue;
                }
                throw re;
            }
        }
        return lookupResult;
    }

    private void handleTabletClosedDuringScan(List<KVEntry> results, Tablet.LookupResult lookupResult, boolean exceededMemoryUsage, Range range, int entriesAdded) {
        if (exceededMemoryUsage) {
            throw new IllegalStateException("Tablet " + this.getExtent() + "should not exceed memory usage or close, not both");
        }
        if (entriesAdded > 0) {
            this.addUnfinishedRange(lookupResult, range, (Key)results.get(results.size() - 1).getKey());
        } else {
            lookupResult.unfinishedRanges.add(range);
        }
        lookupResult.closed = true;
    }

    private void addUnfinishedRange(Tablet.LookupResult lookupResult, Range range, Key key) {
        if (range.getEndKey() == null || key.compareTo(range.getEndKey()) < 0) {
            Range nlur = new Range(new Key(key), false, range.getEndKey(), range.isEndKeyInclusive());
            lookupResult.unfinishedRanges.add(nlur);
        }
    }

    public synchronized void updateQueryStats(int size, long numBytes) {
        this.queryResultCount.addAndGet(size);
        this.server.getScanMetrics().incrementQueryResultCount(size);
        this.queryResultBytes.addAndGet(numBytes);
        this.server.getScanMetrics().incrementQueryResultBytes(numBytes);
    }
}

