/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security.handler;

import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.ZKSecurityTool;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZKAuthenticator
implements Authenticator {
    private static final Logger log = LoggerFactory.getLogger(ZKAuthenticator.class);
    private ServerContext context;
    private String zkUserPath;
    private ZooCache zooCache;

    @Override
    public void initialize(ServerContext context) {
        this.context = context;
        this.zooCache = new ZooCache(context.getZooReader(), null);
        this.zkUserPath = context.zkUserPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeSecurity(String principal, byte[] token) {
        try {
            ZooReaderWriter zoo = this.context.getZooReaderWriter();
            ZooCache zooCache = this.zooCache;
            synchronized (zooCache) {
                this.zooCache.clear();
                if (zoo.exists(this.zkUserPath)) {
                    zoo.recursiveDelete(this.zkUserPath, ZooUtil.NodeMissingPolicy.SKIP);
                    log.info("Removed {}/ from zookeeper", (Object)this.zkUserPath);
                }
                zoo.putPersistentData(this.zkUserPath, principal.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.FAIL);
                this.constructUser(principal, ZKSecurityTool.createPass(token));
            }
        }
        catch (InterruptedException | AccumuloException | KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructUser(String user, byte[] pass) throws KeeperException, InterruptedException {
        ZooCache zooCache = this.zooCache;
        synchronized (zooCache) {
            this.zooCache.clear();
            ZooReaderWriter zoo = this.context.getZooReaderWriter();
            zoo.putPrivatePersistentData(this.zkUserPath + "/" + user, pass, ZooUtil.NodeExistsPolicy.FAIL);
        }
    }

    @Override
    public Set<String> listUsers() {
        return new TreeSet<String>(this.zooCache.getChildren(this.zkUserPath));
    }

    @Override
    public void createUser(String principal, AuthenticationToken token) throws AccumuloSecurityException {
        try {
            if (!(token instanceof PasswordToken)) {
                throw new AccumuloSecurityException(principal, SecurityErrorCode.INVALID_TOKEN);
            }
            PasswordToken pt = (PasswordToken)token;
            this.constructUser(principal, ZKSecurityTool.createPass(pt.getPassword()));
        }
        catch (KeeperException e) {
            if (e.code().equals((Object)KeeperException.Code.NODEEXISTS)) {
                throw new AccumuloSecurityException(principal, SecurityErrorCode.USER_EXISTS, (Throwable)e);
            }
            throw new AccumuloSecurityException(principal, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException(e);
        }
        catch (AccumuloException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new AccumuloSecurityException(principal, SecurityErrorCode.DEFAULT_SECURITY_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropUser(String user) throws AccumuloSecurityException {
        try {
            ZooCache zooCache = this.zooCache;
            synchronized (zooCache) {
                this.zooCache.clear();
                this.context.getZooReaderWriter().recursiveDelete(this.zkUserPath + "/" + user, ZooUtil.NodeMissingPolicy.FAIL);
            }
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException(e);
        }
        catch (KeeperException e) {
            if (e.code().equals((Object)KeeperException.Code.NONODE)) {
                throw new AccumuloSecurityException(user, SecurityErrorCode.USER_DOESNT_EXIST, (Throwable)e);
            }
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePassword(String principal, AuthenticationToken token) throws AccumuloSecurityException {
        block9: {
            if (!(token instanceof PasswordToken)) {
                throw new AccumuloSecurityException(principal, SecurityErrorCode.INVALID_TOKEN);
            }
            PasswordToken pt = (PasswordToken)token;
            if (this.userExists(principal)) {
                try {
                    ZooCache zooCache = this.zooCache;
                    synchronized (zooCache) {
                        this.zooCache.clear(this.zkUserPath + "/" + principal);
                        this.context.getZooReaderWriter().putPrivatePersistentData(this.zkUserPath + "/" + principal, ZKSecurityTool.createPass(pt.getPassword()), ZooUtil.NodeExistsPolicy.OVERWRITE);
                        break block9;
                    }
                }
                catch (KeeperException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                    throw new AccumuloSecurityException(principal, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
                }
                catch (InterruptedException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                    throw new IllegalStateException(e);
                }
                catch (AccumuloException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                    throw new AccumuloSecurityException(principal, SecurityErrorCode.DEFAULT_SECURITY_ERROR, (Throwable)e);
                }
            }
            throw new AccumuloSecurityException(principal, SecurityErrorCode.USER_DOESNT_EXIST);
        }
    }

    @Override
    public boolean userExists(String user) {
        return this.zooCache.get(this.zkUserPath + "/" + user) != null;
    }

    @Override
    public boolean validSecurityHandlers() {
        return true;
    }

    @Override
    public boolean authenticateUser(String principal, AuthenticationToken token) throws AccumuloSecurityException {
        if (!(token instanceof PasswordToken)) {
            throw new AccumuloSecurityException(principal, SecurityErrorCode.INVALID_TOKEN);
        }
        PasswordToken pt = (PasswordToken)token;
        String zpath = this.zkUserPath + "/" + principal;
        byte[] zkData = this.zooCache.get(zpath);
        boolean result = this.authenticateUser(principal, pt, zkData);
        if (!result) {
            this.zooCache.clear(zpath);
            zkData = this.zooCache.get(zpath);
            result = this.authenticateUser(principal, pt, zkData);
        }
        return result;
    }

    private boolean authenticateUser(String principal, PasswordToken pt, byte[] zkData) {
        if (zkData == null) {
            return false;
        }
        return ZKSecurityTool.checkCryptPass(pt.getPassword(), zkData);
    }

    @Override
    public Set<Class<? extends AuthenticationToken>> getSupportedTokenTypes() {
        HashSet<Class<? extends AuthenticationToken>> cs = new HashSet<Class<? extends AuthenticationToken>>();
        cs.add(PasswordToken.class);
        return cs;
    }

    @Override
    public boolean validTokenClass(String tokenClass) {
        return tokenClass.equals(PasswordToken.class.getName());
    }
}

