/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import com.google.common.net.HostAndPort;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.hadoop.io.Text;

public class TServerInstance
implements Comparable<TServerInstance> {
    private final HostAndPort hostAndPort;
    private final String hostPort;
    private final String session;
    private final String hostPortSession;

    public TServerInstance(HostAndPort address, String session) {
        this.hostAndPort = address;
        this.session = session;
        this.hostPort = this.hostAndPort.toString();
        this.hostPortSession = this.hostPort + "[" + session + "]";
    }

    public TServerInstance(String formattedString) {
        int pos = formattedString.indexOf("[");
        if (pos < 0 || !formattedString.endsWith("]")) {
            throw new IllegalArgumentException(formattedString);
        }
        this.hostAndPort = HostAndPort.fromString((String)formattedString.substring(0, pos));
        this.session = formattedString.substring(pos + 1, formattedString.length() - 1);
        this.hostPort = this.hostAndPort.toString();
        this.hostPortSession = this.hostPort + "[" + this.session + "]";
    }

    public TServerInstance(HostAndPort address, long session) {
        this(address, Long.toHexString(session));
    }

    public TServerInstance(String address, long session) {
        this(AddressUtil.parseAddress(address, false), Long.toHexString(session));
    }

    public TServerInstance(Value address, Text session) {
        this(AddressUtil.parseAddress(new String(address.get(), StandardCharsets.UTF_8), false), session.toString());
    }

    @Override
    public int compareTo(TServerInstance other) {
        if (this == other) {
            return 0;
        }
        return this.getHostPortSession().compareTo(other.getHostPortSession());
    }

    public int hashCode() {
        return this.getHostPortSession().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TServerInstance) {
            return this.compareTo((TServerInstance)obj) == 0;
        }
        return false;
    }

    public String toString() {
        return this.hostPortSession;
    }

    public String getHostPortSession() {
        return this.hostPortSession;
    }

    public String getHost() {
        return this.hostAndPort.getHost();
    }

    public String getHostPort() {
        return this.hostPort;
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    public String getSession() {
        return this.session;
    }
}

