/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import com.google.common.net.HostAndPort;
import java.util.Objects;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.TServerInstance;

public class SuspendingTServer {
    public final HostAndPort server;
    public final long suspensionTime;

    SuspendingTServer(HostAndPort server, long suspensionTime) {
        this.server = Objects.requireNonNull(server);
        this.suspensionTime = suspensionTime;
    }

    public static SuspendingTServer fromValue(Value value) {
        String valStr = value.toString();
        String[] parts = valStr.split("[|]", 2);
        return new SuspendingTServer(HostAndPort.fromString((String)parts[0]), Long.parseLong(parts[1]));
    }

    public static Value toValue(TServerInstance tServer, long suspensionTime) {
        return new Value(tServer.getHostPort() + "|" + suspensionTime);
    }

    public boolean equals(Object rhsObject) {
        if (!(rhsObject instanceof SuspendingTServer)) {
            return false;
        }
        SuspendingTServer rhs = (SuspendingTServer)rhsObject;
        return this.server.equals((Object)rhs.server) && this.suspensionTime == rhs.suspensionTime;
    }

    public int hashCode() {
        return Objects.hash(this.server, this.suspensionTime);
    }

    public String toString() {
        return this.server + "[" + this.suspensionTime + "]";
    }
}

