/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.gc;

import java.util.Objects;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.gc.Reference;

public class ReferenceFile
implements Reference,
Comparable<ReferenceFile> {
    public final TableId tableId;
    protected final String metadataEntry;

    public ReferenceFile(TableId tableId, String metadataEntry) {
        this.tableId = Objects.requireNonNull(tableId);
        this.metadataEntry = Objects.requireNonNull(metadataEntry);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public String getMetadataEntry() {
        return this.metadataEntry;
    }

    @Override
    public int compareTo(ReferenceFile that) {
        if (this.equals(that)) {
            return 0;
        }
        return this.metadataEntry.compareTo(that.metadataEntry);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenceFile other = (ReferenceFile)obj;
        return this.metadataEntry.equals(other.metadataEntry);
    }

    public int hashCode() {
        return this.metadataEntry.hashCode();
    }

    public String toString() {
        return "Reference [id=" + this.tableId + ", ref=" + this.metadataEntry + "]";
    }
}

