/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.coordinator;

import org.apache.accumulo.core.lock.ServiceLock;
import org.apache.accumulo.core.util.Halt;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorLockWatcher
implements ServiceLock.AccumuloLockWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(CoordinatorLockWatcher.class);
    private volatile boolean acquiredLock = false;
    private volatile boolean failedToAcquireLock = false;

    public void lostLock(ServiceLock.LockLossReason reason) {
        Halt.halt((String)("Coordinator lock in zookeeper lost (reason = " + reason + "), exiting!"), (int)-1);
    }

    public void unableToMonitorLockNode(Exception e) {
        Halt.halt((int)-1, () -> LOG.error("FATAL: No longer able to monitor Coordinator lock node", (Throwable)e));
    }

    public synchronized void acquiredLock() {
        LOG.debug("Acquired Coordinator lock");
        if (this.acquiredLock || this.failedToAcquireLock) {
            Halt.halt((String)("Zoolock in unexpected state AL " + this.acquiredLock + " " + this.failedToAcquireLock), (int)-1);
        }
        this.acquiredLock = true;
        this.notifyAll();
    }

    public synchronized void failedToAcquireLock(Exception e) {
        LOG.warn("Failed to get Coordinator lock", (Throwable)e);
        if (e instanceof KeeperException.NoAuthException) {
            String msg = "Failed to acquire Coordinator lock due to incorrect ZooKeeper authentication.";
            LOG.error("{} Ensure instance.secret is consistent across Accumulo configuration", (Object)msg, (Object)e);
            Halt.halt((String)msg, (int)-1);
        }
        if (this.acquiredLock) {
            Halt.halt((String)("Zoolock in unexpected state FAL " + this.acquiredLock + " " + this.failedToAcquireLock), (int)-1);
        }
        this.failedToAcquireLock = true;
        this.notifyAll();
    }

    public synchronized void waitForChange() {
        while (!this.acquiredLock && !this.failedToAcquireLock) {
            try {
                LOG.info("Coordinator lock held by someone else, waiting for a change in state");
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isAcquiredLock() {
        return this.acquiredLock;
    }

    public boolean isFailedToAcquireLock() {
        return this.failedToAcquireLock;
    }
}

