/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metadata;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.RootTabletMetadata;
import org.apache.accumulo.core.security.AuthorizationContainer;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.constraints.MetadataConstraints;
import org.apache.accumulo.server.constraints.SystemEnvironment;
import org.apache.accumulo.server.metadata.TabletMutatorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootTabletMutatorImpl
extends TabletMutatorBase
implements Ample.TabletMutator {
    private final ServerContext context;
    private static final Logger log = LoggerFactory.getLogger(RootTabletMutatorImpl.class);

    RootTabletMutatorImpl(ServerContext context) {
        super(context, RootTable.EXTENT);
        this.context = context;
    }

    public void mutate() {
        MetadataConstraints metaConstraint = new MetadataConstraints();
        Mutation mutation = this.getMutation();
        List<Short> violations = metaConstraint.check(new RootEnv(this.context), mutation);
        if (violations != null && !violations.isEmpty()) {
            throw new IllegalStateException("Mutation for root tablet metadata violated constraints : " + String.valueOf(violations));
        }
        try {
            String zpath = this.context.getZooKeeperRoot() + "/root_tablet";
            this.context.getZooCache().clear(zpath);
            this.context.getZooReaderWriter().mutateOrCreate(zpath, new byte[0], currVal -> {
                String currJson = new String(currVal, StandardCharsets.UTF_8);
                RootTabletMetadata rtm = new RootTabletMetadata(currJson);
                rtm.update(mutation);
                String newJson = rtm.toJson();
                log.debug("mutation: from:[{}] to: [{}]", (Object)currJson, (Object)newJson);
                return newJson.getBytes(StandardCharsets.UTF_8);
            });
            this.context.getZooCache().clear(zpath);
            if (this.closeAfterMutate != null) {
                this.closeAfterMutate.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class RootEnv
    implements SystemEnvironment,
    Constraint.Environment {
        private final ServerContext context;

        RootEnv(ServerContext context) {
            this.context = context;
        }

        public KeyExtent getExtent() {
            return RootTable.EXTENT;
        }

        public TabletId getTablet() {
            return new TabletIdImpl(RootTable.EXTENT);
        }

        public String getUser() {
            throw new UnsupportedOperationException();
        }

        public AuthorizationContainer getAuthorizationsContainer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServerContext getServerContext() {
            return this.context;
        }
    }
}

