/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.scan;

import com.google.common.hash.HashCode;
import com.google.common.net.HostAndPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.spi.scan.ConfigurableScanServerSelector;
import org.apache.accumulo.core.spi.scan.ScanServerSelector;

public class ConfigurableScanServerHostSelector
extends ConfigurableScanServerSelector {
    @Override
    protected int selectServers(ScanServerSelector.SelectorParameters params, ConfigurableScanServerSelector.Profile profile, List<String> orderedScanServers, Map<TabletId, String> serversToUse) {
        HashMap<String, List> scanServerHosts = new HashMap<String, List>();
        for (String address : orderedScanServers) {
            HostAndPort hp = HostAndPort.fromString((String)address);
            scanServerHosts.computeIfAbsent(hp.getHost(), k -> new ArrayList()).add(address);
        }
        ArrayList hostIndex = new ArrayList(scanServerHosts.keySet());
        int numberOfPreviousAttempts = params.getTablets().stream().mapToInt(tablet -> params.getAttempts((TabletId)tablet).size()).max().orElse(0);
        int numServersToUseInAttemptPlan = profile.getNumServers(numberOfPreviousAttempts, orderedScanServers.size());
        for (TabletId tablet2 : params.getTablets()) {
            boolean scanServerFound = false;
            if (numberOfPreviousAttempts > 0) {
                HashMap priorServers = new HashMap(numberOfPreviousAttempts);
                params.getAttempts(tablet2).forEach(ssa -> {
                    String priorServerAddress = ssa.getServer();
                    HostAndPort priorHP = HostAndPort.fromString((String)priorServerAddress);
                    priorServers.computeIfAbsent(priorHP.getHost(), k -> new PriorHostServers(priorHP.getHost())).getPriorServers().add(priorServerAddress);
                });
                ArrayList priors = new ArrayList(priorServers.values());
                Collections.sort(priors, new PriorHostServersComparator());
                for (PriorHostServers phs : priors) {
                    HashSet scanServersOnPriorHost = new HashSet((Collection)scanServerHosts.get(phs.getPriorHost()));
                    scanServersOnPriorHost.removeAll(phs.getPriorServers());
                    if (scanServersOnPriorHost.size() <= 0) continue;
                    serversToUse.put(tablet2, (String)scanServersOnPriorHost.iterator().next());
                    scanServerFound = true;
                    break;
                }
                for (PriorHostServers phs : priors) {
                    hostIndex.remove(phs.getPriorHost());
                }
            }
            if (scanServerFound) continue;
            if (hostIndex.size() == 0) {
                serversToUse.put(tablet2, null);
                continue;
            }
            HashCode hashCode = this.hashTablet(tablet2, profile.getSalt(numberOfPreviousAttempts));
            int serverIndex = (Math.abs(hashCode.asInt()) + RANDOM.nextInt(numServersToUseInAttemptPlan)) % hostIndex.size();
            String hostToUse = (String)hostIndex.get(serverIndex);
            List scanServersOnHost = (List)scanServerHosts.get(hostToUse);
            serversToUse.put(tablet2, (String)scanServersOnHost.get(0));
        }
        return numberOfPreviousAttempts;
    }

    private static final class PriorHostServersComparator
    implements Comparator<PriorHostServers> {
        private PriorHostServersComparator() {
        }

        @Override
        public int compare(PriorHostServers o1, PriorHostServers o2) {
            return Integer.compare(o1.getPriorServers().size(), o2.getPriorServers().size());
        }
    }

    private static final class PriorHostServers {
        private final String priorHost;
        private final List<String> priorServers = new ArrayList<String>();

        public PriorHostServers(String priorHost) {
            this.priorHost = priorHost;
        }

        public String getPriorHost() {
            return this.priorHost;
        }

        public List<String> getPriorServers() {
            return this.priorServers;
        }
    }
}

