/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.fate.zookeeper;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.util.Halt;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLockSupport {

    public static class ServiceLockWatcher
    implements ServiceLock.LockWatcher {
        private final String serviceName;
        private final Supplier<Boolean> shutdownComplete;
        private final Consumer<String> lostLockAction;

        public ServiceLockWatcher(String serviceName, Supplier<Boolean> shutdownComplete, Consumer<String> lostLockAction) {
            this.serviceName = serviceName;
            this.shutdownComplete = shutdownComplete;
            this.lostLockAction = lostLockAction;
        }

        @Override
        public void lostLock(ServiceLock.LockLossReason reason) {
            if (this.shutdownComplete.get().booleanValue()) {
                Halt.halt(0, this.serviceName + " lost lock (reason = " + String.valueOf((Object)reason) + "), exiting cleanly because shutdown is complete.", () -> this.lostLockAction.accept(this.serviceName));
            } else {
                Halt.halt(1, this.serviceName + " lost lock (reason = " + String.valueOf((Object)reason) + "), exiting.", () -> this.lostLockAction.accept(this.serviceName));
            }
        }

        @Override
        public void unableToMonitorLockNode(Exception e) {
            Halt.halt(1, "Lost ability to monitor " + this.serviceName + " lock, exiting.", e);
        }
    }

    public static class HAServiceLockWatcher
    implements ServiceLock.AccumuloLockWatcher {
        private static final Logger LOG = LoggerFactory.getLogger(HAServiceLockWatcher.class);
        private final String serviceName;
        private final Supplier<Boolean> shutdownComplete;
        private volatile boolean acquiredLock = false;
        private volatile boolean failedToAcquireLock = false;

        public HAServiceLockWatcher(String serviceName, Supplier<Boolean> shutdownComplete) {
            this.serviceName = serviceName;
            this.shutdownComplete = shutdownComplete;
        }

        @Override
        public void lostLock(ServiceLock.LockLossReason reason) {
            if (this.shutdownComplete.get().booleanValue()) {
                Halt.halt(0, this.serviceName + " lock in zookeeper lost (reason = " + String.valueOf((Object)reason) + "), exiting cleanly because shutdown is complete.");
            } else {
                Halt.halt(-1, this.serviceName + " lock in zookeeper lost (reason = " + String.valueOf((Object)reason) + "), exiting!");
            }
        }

        @Override
        public void unableToMonitorLockNode(Exception e) {
            Halt.halt(-1, "FATAL: No longer able to monitor " + this.serviceName + " lock node", e);
        }

        @Override
        public synchronized void acquiredLock() {
            LOG.debug("Acquired {} lock", (Object)this.serviceName);
            if (this.acquiredLock || this.failedToAcquireLock) {
                Halt.halt(-1, "Zoolock in unexpected state AL " + this.acquiredLock + " " + this.failedToAcquireLock);
            }
            this.acquiredLock = true;
            this.notifyAll();
        }

        @Override
        public synchronized void failedToAcquireLock(Exception e) {
            LOG.warn("Failed to get {} lock", (Object)this.serviceName, (Object)e);
            if (e instanceof KeeperException.NoAuthException) {
                String msg = "Failed to acquire " + this.serviceName + " lock due to incorrect ZooKeeper authentication.";
                LOG.error("{} Ensure instance.secret is consistent across Accumulo configuration", (Object)msg, (Object)e);
                Halt.halt(-1, msg);
            }
            if (this.acquiredLock) {
                Halt.halt(-1, "Zoolock in unexpected state acquiredLock true with FAL " + this.failedToAcquireLock);
            }
            this.failedToAcquireLock = true;
            this.notifyAll();
        }

        public synchronized void waitForChange() {
            while (!this.acquiredLock && !this.failedToAcquireLock) {
                try {
                    LOG.info("{} lock held by someone else, waiting for a change in state", (Object)this.serviceName);
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public boolean isLockAcquired() {
            return this.acquiredLock;
        }

        public boolean isFailedToAcquireLock() {
            return this.failedToAcquireLock;
        }
    }
}

