/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.Iterator;
import java.util.Set;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.tables.TableNameUtil;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.TableOperation;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class DeleteTableCommand
extends TableOperation {
    private Option forceOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        if (cl.hasOption(this.forceOpt.getOpt())) {
            super.force();
        } else {
            super.noForce();
        }
        return super.execute(fullCommand, cl, shellState);
    }

    @Override
    public String description() {
        return "deletes a table (Same as droptable)";
    }

    @Override
    protected void doTableOp(Shell shellState, String tableName) throws Exception {
        shellState.getAccumuloClient().tableOperations().delete(tableName);
        shellState.getWriter().println("Table: [" + tableName + "] has been deleted.");
        if (shellState.getTableName().equals(tableName)) {
            shellState.setTableName("");
        }
    }

    @Override
    public Options getOptions() {
        this.forceOpt = new Option("f", "force", false, "force deletion without prompting");
        Options opts = super.getOptions();
        opts.addOption(this.forceOpt);
        return opts;
    }

    @Override
    protected void pruneTables(Set<String> tables) {
        Iterator<String> tableNames = tables.iterator();
        while (tableNames.hasNext()) {
            String table = tableNames.next();
            Pair qualifiedName = TableNameUtil.qualify((String)table);
            if (!Namespace.ACCUMULO.name().equals(qualifiedName.getFirst())) continue;
            Shell.log.trace("Removing table from deletion set: {}", (Object)table);
            tableNames.remove();
        }
    }
}

