/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.net.SocketAppender;
import org.apache.log4j.spi.LoggingEvent;

public class AsyncSocketAppender
extends AsyncAppender {
    private final SocketAppender socketAppender;
    private final AtomicBoolean activated = new AtomicBoolean(false);

    public AsyncSocketAppender() {
        this.socketAppender = new SocketAppender();
    }

    AsyncSocketAppender(SocketAppender socketAppender) {
        this.socketAppender = socketAppender;
    }

    public void append(LoggingEvent event) {
        if (!this.isAttached((Appender)this.socketAppender)) {
            this.addAppender((Appender)this.socketAppender);
        }
        if (this.activated.compareAndSet(false, true)) {
            this.socketAppender.activateOptions();
        }
        super.append(event);
    }

    public String getApplication() {
        return this.socketAppender.getApplication();
    }

    public int getPort() {
        return this.socketAppender.getPort();
    }

    public int getReconnectionDelay() {
        return this.socketAppender.getReconnectionDelay();
    }

    public String getRemoteHost() {
        return this.socketAppender.getRemoteHost();
    }

    public boolean isAdvertiseViaMulticastDNS() {
        return this.socketAppender.isAdvertiseViaMulticastDNS();
    }

    public void setAdvertiseViaMulticastDNS(boolean advertiseViaMulticastDNS) {
        this.socketAppender.setAdvertiseViaMulticastDNS(advertiseViaMulticastDNS);
    }

    public void setApplication(String lapp) {
        this.socketAppender.setApplication(lapp);
    }

    public void setLocationInfo(boolean locationInfo) {
        super.setLocationInfo(locationInfo);
        this.socketAppender.setLocationInfo(locationInfo);
    }

    public void setPort(int port) {
        this.socketAppender.setPort(port);
    }

    public void setReconnectionDelay(int delay) {
        this.socketAppender.setReconnectionDelay(delay);
    }

    public void setRemoteHost(String host) {
        this.socketAppender.setRemoteHost(host);
    }
}

