/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile.bcfile;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.file.blockfile.impl.CachableBlockFile;
import org.apache.accumulo.core.file.rfile.bcfile.CompareUtils;
import org.apache.accumulo.core.file.rfile.bcfile.Compression;
import org.apache.accumulo.core.file.rfile.bcfile.MetaBlockAlreadyExists;
import org.apache.accumulo.core.file.rfile.bcfile.MetaBlockDoesNotExist;
import org.apache.accumulo.core.file.rfile.bcfile.SimpleBufferedOutputStream;
import org.apache.accumulo.core.file.rfile.bcfile.Utils;
import org.apache.accumulo.core.file.streams.BoundedRangeFileInputStream;
import org.apache.accumulo.core.file.streams.PositionedDataOutputStream;
import org.apache.accumulo.core.file.streams.PositionedOutput;
import org.apache.accumulo.core.file.streams.SeekableDataInputStream;
import org.apache.accumulo.core.security.crypto.CryptoModule;
import org.apache.accumulo.core.security.crypto.CryptoModuleFactory;
import org.apache.accumulo.core.security.crypto.CryptoModuleParameters;
import org.apache.accumulo.core.security.crypto.SecretKeyEncryptionStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;

public final class BCFile {
    static final Utils.Version API_VERSION = new Utils.Version(2, 0);
    static final Utils.Version API_VERSION_1 = new Utils.Version(1, 0);
    static final Log LOG = LogFactory.getLog(BCFile.class);
    private static final String FS_OUTPUT_BUF_SIZE_ATTR = "tfile.fs.output.buffer.size";
    private static final String FS_INPUT_BUF_SIZE_ATTR = "tfile.fs.input.buffer.size";
    private static final byte[] NO_CPYPTO_KEY = "ce18cf53c4c5077f771249b38033fa14bcb31cca0e5e95a371ee72daa8342ea2".getBytes(StandardCharsets.UTF_8);
    private static final BCFileCryptoModuleParameters NO_CRYPTO = new BCFileCryptoModuleParameters(){

        @Override
        public Map<String, String> getAllOptions() {
            return Collections.emptyMap();
        }

        @Override
        public byte[] getEncryptedKey() {
            return NO_CPYPTO_KEY;
        }

        @Override
        public String getOpaqueKeyEncryptionKeyID() {
            return "NONE:a4007e6aefb095a5a47030cd6c850818fb3a685dc6e85ba1ecc5a44ba68b193b";
        }
    };

    private static int getFSOutputBufferSize(Configuration conf) {
        return conf.getInt(FS_OUTPUT_BUF_SIZE_ATTR, 262144);
    }

    private static int getFSInputBufferSize(Configuration conf) {
        return conf.getInt(FS_INPUT_BUF_SIZE_ATTR, 32768);
    }

    private BCFile() {
    }

    static final class BlockRegion
    implements CompareUtils.Scalar {
        private final long offset;
        private final long compressedSize;
        private final long rawSize;

        public BlockRegion(DataInput in) throws IOException {
            this.offset = Utils.readVLong(in);
            this.compressedSize = Utils.readVLong(in);
            this.rawSize = Utils.readVLong(in);
        }

        public BlockRegion(long offset, long compressedSize, long rawSize) {
            this.offset = offset;
            this.compressedSize = compressedSize;
            this.rawSize = rawSize;
        }

        public void write(DataOutput out) throws IOException {
            Utils.writeVLong(out, this.offset);
            Utils.writeVLong(out, this.compressedSize);
            Utils.writeVLong(out, this.rawSize);
        }

        public long getOffset() {
            return this.offset;
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public long getRawSize() {
            return this.rawSize;
        }

        @Override
        public long magnitude() {
            return this.offset;
        }
    }

    static final class Magic {
        private static final byte[] AB_MAGIC_BCFILE = new byte[]{-47, 17, -45, 104, -111, -75, -41, -74, 57, -33, 65, 64, -110, -70, -31, 80};

        Magic() {
        }

        public static void readAndVerify(DataInput in) throws IOException {
            byte[] abMagic = new byte[Magic.size()];
            in.readFully(abMagic);
            if (!Arrays.equals(abMagic, AB_MAGIC_BCFILE)) {
                throw new IOException("Not a valid BCFile.");
            }
        }

        public static void write(DataOutput out) throws IOException {
            out.write(AB_MAGIC_BCFILE);
        }

        public static int size() {
            return AB_MAGIC_BCFILE.length;
        }
    }

    static class DataIndex {
        static final String BLOCK_NAME = "BCFile.index";
        private final Compression.Algorithm defaultCompressionAlgorithm;
        private final ArrayList<BlockRegion> listRegions;
        private boolean trackBlocks;

        public DataIndex(DataInput in) throws IOException {
            this.defaultCompressionAlgorithm = Compression.getCompressionAlgorithmByName(Utils.readString(in));
            int n = Utils.readVInt(in);
            this.listRegions = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                BlockRegion region = new BlockRegion(in);
                this.listRegions.add(region);
            }
        }

        public DataIndex(String defaultCompressionAlgorithmName, boolean trackBlocks) {
            this.trackBlocks = trackBlocks;
            this.defaultCompressionAlgorithm = Compression.getCompressionAlgorithmByName(defaultCompressionAlgorithmName);
            this.listRegions = new ArrayList();
        }

        public Compression.Algorithm getDefaultCompressionAlgorithm() {
            return this.defaultCompressionAlgorithm;
        }

        public ArrayList<BlockRegion> getBlockRegionList() {
            return this.listRegions;
        }

        public void addBlockRegion(BlockRegion region) {
            if (this.trackBlocks) {
                this.listRegions.add(region);
            }
        }

        public void write(DataOutput out) throws IOException {
            Utils.writeString(out, this.defaultCompressionAlgorithm.getName());
            Utils.writeVInt(out, this.listRegions.size());
            for (BlockRegion region : this.listRegions) {
                region.write(out);
            }
        }
    }

    static final class MetaIndexEntry {
        private final String metaName;
        private final Compression.Algorithm compressionAlgorithm;
        private static final String defaultPrefix = "data:";
        private final BlockRegion region;

        public MetaIndexEntry(DataInput in) throws IOException {
            String fullMetaName = Utils.readString(in);
            if (!fullMetaName.startsWith(defaultPrefix)) {
                throw new IOException("Corrupted Meta region Index");
            }
            this.metaName = fullMetaName.substring(defaultPrefix.length(), fullMetaName.length());
            this.compressionAlgorithm = Compression.getCompressionAlgorithmByName(Utils.readString(in));
            this.region = new BlockRegion(in);
        }

        public MetaIndexEntry(String metaName, Compression.Algorithm compressionAlgorithm, BlockRegion region) {
            this.metaName = metaName;
            this.compressionAlgorithm = compressionAlgorithm;
            this.region = region;
        }

        public String getMetaName() {
            return this.metaName;
        }

        public Compression.Algorithm getCompressionAlgorithm() {
            return this.compressionAlgorithm;
        }

        public BlockRegion getRegion() {
            return this.region;
        }

        public void write(DataOutput out) throws IOException {
            Utils.writeString(out, defaultPrefix + this.metaName);
            Utils.writeString(out, this.compressionAlgorithm.getName());
            this.region.write(out);
        }
    }

    static class MetaIndex {
        final Map<String, MetaIndexEntry> index;

        public MetaIndex() {
            this.index = new TreeMap<String, MetaIndexEntry>();
        }

        public MetaIndex(DataInput in) throws IOException {
            int count = Utils.readVInt(in);
            this.index = new TreeMap<String, MetaIndexEntry>();
            for (int nx = 0; nx < count; ++nx) {
                MetaIndexEntry indexEntry = new MetaIndexEntry(in);
                this.index.put(indexEntry.getMetaName(), indexEntry);
            }
        }

        public void addEntry(MetaIndexEntry indexEntry) {
            this.index.put(indexEntry.getMetaName(), indexEntry);
        }

        public MetaIndexEntry getMetaByName(String name) {
            return this.index.get(name);
        }

        public void write(DataOutput out) throws IOException {
            Utils.writeVInt(out, this.index.size());
            for (MetaIndexEntry indexEntry : this.index.values()) {
                indexEntry.write(out);
            }
        }
    }

    public static class Reader
    implements Closeable {
        private static final String META_NAME = "BCFile.metaindex";
        private static final String CRYPTO_BLOCK_NAME = "BCFile.cryptoparams";
        private final SeekableDataInputStream in;
        private final Configuration conf;
        final DataIndex dataIndex;
        final MetaIndex metaIndex;
        final Utils.Version version;
        private BCFileCryptoModuleParameters cryptoParams;
        private CryptoModule cryptoModule;
        private SecretKeyEncryptionStrategy secretKeyEncryptionStrategy;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <InputStreamType extends InputStream> Reader(InputStreamType fin, long fileLength, Configuration conf, AccumuloConfiguration accumuloConfiguration) throws IOException {
            this.in = new SeekableDataInputStream(fin);
            this.conf = conf;
            this.in.seek(fileLength - (long)Magic.size() - (long)Utils.Version.size());
            this.version = new Utils.Version(this.in);
            Magic.readAndVerify(this.in);
            if (!this.version.compatibleWith(API_VERSION) && !this.version.equals(API_VERSION_1)) {
                throw new RuntimeException("Incompatible BCFile fileBCFileVersion.");
            }
            long offsetIndexMeta = 0L;
            long offsetCryptoParameters = 0L;
            if (this.version.equals(API_VERSION_1)) {
                this.in.seek(fileLength - (long)Magic.size() - (long)Utils.Version.size() - 8L);
                offsetIndexMeta = this.in.readLong();
            } else {
                this.in.seek(fileLength - (long)Magic.size() - (long)Utils.Version.size() - 16L);
                offsetIndexMeta = this.in.readLong();
                offsetCryptoParameters = this.in.readLong();
            }
            this.in.seek(offsetIndexMeta);
            this.metaIndex = new MetaIndex(this.in);
            if (!this.version.equals(API_VERSION_1)) {
                this.in.seek(offsetCryptoParameters);
                this.cryptoParams = new BCFileCryptoModuleParameters();
                this.cryptoParams.read(this.in);
                this.cryptoModule = CryptoModuleFactory.getCryptoModule(this.cryptoParams.getAllOptions().get(Property.CRYPTO_MODULE_CLASS.getKey()));
                if (accumuloConfiguration.getBoolean(Property.CRYPTO_OVERRIDE_KEY_STRATEGY_WITH_CONFIGURED_STRATEGY)) {
                    Map<String, String> cryptoConfFromAccumuloConf = accumuloConfiguration.getAllPropertiesWithPrefix(Property.CRYPTO_PREFIX);
                    Map<String, String> instanceConf = accumuloConfiguration.getAllPropertiesWithPrefix(Property.INSTANCE_PREFIX);
                    cryptoConfFromAccumuloConf.putAll(instanceConf);
                    for (String name : this.cryptoParams.getAllOptions().keySet()) {
                        if (!name.equals(Property.CRYPTO_SECRET_KEY_ENCRYPTION_STRATEGY_CLASS.getKey())) {
                            cryptoConfFromAccumuloConf.put(name, this.cryptoParams.getAllOptions().get(name));
                            continue;
                        }
                        this.cryptoParams.setKeyEncryptionStrategyClass(cryptoConfFromAccumuloConf.get(Property.CRYPTO_SECRET_KEY_ENCRYPTION_STRATEGY_CLASS.getKey()));
                    }
                    this.cryptoParams.setAllOptions(cryptoConfFromAccumuloConf);
                }
                this.secretKeyEncryptionStrategy = CryptoModuleFactory.getSecretKeyEncryptionStrategy(this.cryptoParams.getKeyEncryptionStrategyClass());
                this.cryptoParams = (BCFileCryptoModuleParameters)this.secretKeyEncryptionStrategy.decryptSecretKey(this.cryptoParams);
            } else {
                LOG.trace((Object)"Found a version 1 file to read.");
            }
            try (BlockReader blockR = this.getMetaBlock("BCFile.index");){
                this.dataIndex = new DataIndex(blockR);
            }
        }

        public <InputStreamType extends InputStream> Reader(CachableBlockFile.Reader cache, InputStreamType fin, long fileLength, Configuration conf, AccumuloConfiguration accumuloConfiguration) throws IOException {
            this.in = new SeekableDataInputStream(fin);
            this.conf = conf;
            CachableBlockFile.BlockRead cachedMetaIndex = cache.getCachedMetaBlock(META_NAME);
            CachableBlockFile.BlockRead cachedDataIndex = cache.getCachedMetaBlock("BCFile.index");
            CachableBlockFile.BlockRead cachedCryptoParams = cache.getCachedMetaBlock(CRYPTO_BLOCK_NAME);
            if (cachedMetaIndex == null || cachedDataIndex == null || cachedCryptoParams == null) {
                DataOutputStream dos;
                ByteArrayOutputStream baos;
                this.in.seek(fileLength - (long)Magic.size() - (long)Utils.Version.size());
                this.version = new Utils.Version(this.in);
                Magic.readAndVerify(this.in);
                if (!this.version.compatibleWith(API_VERSION) && !this.version.equals(API_VERSION_1)) {
                    throw new RuntimeException("Incompatible BCFile fileBCFileVersion.");
                }
                long offsetIndexMeta = 0L;
                long offsetCryptoParameters = 0L;
                if (this.version.equals(API_VERSION_1)) {
                    this.in.seek(fileLength - (long)Magic.size() - (long)Utils.Version.size() - 8L);
                    offsetIndexMeta = this.in.readLong();
                } else {
                    this.in.seek(fileLength - (long)Magic.size() - (long)Utils.Version.size() - 16L);
                    offsetIndexMeta = this.in.readLong();
                    offsetCryptoParameters = this.in.readLong();
                }
                this.in.seek(offsetIndexMeta);
                this.metaIndex = new MetaIndex(this.in);
                if (!this.version.equals(API_VERSION_1) && cachedCryptoParams == null) {
                    this.in.seek(offsetCryptoParameters);
                    this.cryptoParams = new BCFileCryptoModuleParameters();
                    this.cryptoParams.read(this.in);
                    if (accumuloConfiguration.getBoolean(Property.CRYPTO_OVERRIDE_KEY_STRATEGY_WITH_CONFIGURED_STRATEGY)) {
                        Map<String, String> cryptoConfFromAccumuloConf = accumuloConfiguration.getAllPropertiesWithPrefix(Property.CRYPTO_PREFIX);
                        Map<String, String> instanceConf = accumuloConfiguration.getAllPropertiesWithPrefix(Property.INSTANCE_PREFIX);
                        cryptoConfFromAccumuloConf.putAll(instanceConf);
                        for (String name : this.cryptoParams.getAllOptions().keySet()) {
                            if (!name.equals(Property.CRYPTO_SECRET_KEY_ENCRYPTION_STRATEGY_CLASS.getKey())) {
                                cryptoConfFromAccumuloConf.put(name, this.cryptoParams.getAllOptions().get(name));
                                continue;
                            }
                            this.cryptoParams.setKeyEncryptionStrategyClass(cryptoConfFromAccumuloConf.get(Property.CRYPTO_SECRET_KEY_ENCRYPTION_STRATEGY_CLASS.getKey()));
                        }
                        this.cryptoParams.setAllOptions(cryptoConfFromAccumuloConf);
                    }
                    baos = new ByteArrayOutputStream();
                    dos = new DataOutputStream(baos);
                    this.cryptoParams.write(dos);
                    dos.close();
                    cache.cacheMetaBlock(CRYPTO_BLOCK_NAME, baos.toByteArray());
                    this.cryptoModule = CryptoModuleFactory.getCryptoModule(this.cryptoParams.getAllOptions().get(Property.CRYPTO_MODULE_CLASS.getKey()));
                    this.secretKeyEncryptionStrategy = CryptoModuleFactory.getSecretKeyEncryptionStrategy(this.cryptoParams.getKeyEncryptionStrategyClass());
                    this.cryptoParams = (BCFileCryptoModuleParameters)this.secretKeyEncryptionStrategy.decryptSecretKey(this.cryptoParams);
                } else if (cachedCryptoParams != null) {
                    this.setupCryptoFromCachedData(cachedCryptoParams);
                } else {
                    baos = new ByteArrayOutputStream();
                    dos = new DataOutputStream(baos);
                    NO_CRYPTO.write(dos);
                    dos.close();
                    cache.cacheMetaBlock(CRYPTO_BLOCK_NAME, baos.toByteArray());
                }
                if (cachedMetaIndex == null) {
                    baos = new ByteArrayOutputStream();
                    dos = new DataOutputStream(baos);
                    this.metaIndex.write(dos);
                    dos.close();
                    cache.cacheMetaBlock(META_NAME, baos.toByteArray());
                }
                if (cachedDataIndex == null) {
                    BlockReader blockR = this.getMetaBlock("BCFile.index");
                    cachedDataIndex = cache.cacheMetaBlock("BCFile.index", blockR);
                }
                try {
                    this.dataIndex = new DataIndex(cachedDataIndex);
                }
                catch (IOException e) {
                    LOG.error((Object)"Got IOException when trying to create DataIndex block");
                    throw e;
                }
                finally {
                    cachedDataIndex.close();
                }
            } else {
                this.version = null;
                this.metaIndex = new MetaIndex(cachedMetaIndex);
                this.dataIndex = new DataIndex(cachedDataIndex);
                this.setupCryptoFromCachedData(cachedCryptoParams);
            }
        }

        private void setupCryptoFromCachedData(CachableBlockFile.BlockRead cachedCryptoParams) throws IOException {
            BCFileCryptoModuleParameters params = new BCFileCryptoModuleParameters();
            params.read(cachedCryptoParams);
            if (Arrays.equals(params.getEncryptedKey(), NO_CRYPTO.getEncryptedKey()) && NO_CRYPTO.getOpaqueKeyEncryptionKeyID().equals(params.getOpaqueKeyEncryptionKeyID())) {
                this.cryptoParams = null;
                this.cryptoModule = null;
                this.secretKeyEncryptionStrategy = null;
            } else {
                this.cryptoModule = CryptoModuleFactory.getCryptoModule(params.getAllOptions().get(Property.CRYPTO_MODULE_CLASS.getKey()));
                this.secretKeyEncryptionStrategy = CryptoModuleFactory.getSecretKeyEncryptionStrategy(params.getKeyEncryptionStrategyClass());
                this.cryptoParams = (BCFileCryptoModuleParameters)this.secretKeyEncryptionStrategy.decryptSecretKey(params);
            }
        }

        public String getDefaultCompressionName() {
            return this.dataIndex.getDefaultCompressionAlgorithm().getName();
        }

        public Utils.Version getBCFileVersion() {
            return this.version;
        }

        public Utils.Version getAPIVersion() {
            return API_VERSION;
        }

        @Override
        public void close() {
        }

        public int getBlockCount() {
            return this.dataIndex.getBlockRegionList().size();
        }

        public BlockReader getMetaBlock(String name) throws IOException, MetaBlockDoesNotExist {
            MetaIndexEntry imeBCIndex = this.metaIndex.getMetaByName(name);
            if (imeBCIndex == null) {
                throw new MetaBlockDoesNotExist("name=" + name);
            }
            BlockRegion region = imeBCIndex.getRegion();
            return this.createReader(imeBCIndex.getCompressionAlgorithm(), region);
        }

        public BlockReader getDataBlock(int blockIndex) throws IOException {
            if (blockIndex < 0 || blockIndex >= this.getBlockCount()) {
                throw new IndexOutOfBoundsException(String.format("blockIndex=%d, numBlocks=%d", blockIndex, this.getBlockCount()));
            }
            BlockRegion region = this.dataIndex.getBlockRegionList().get(blockIndex);
            return this.createReader(this.dataIndex.getDefaultCompressionAlgorithm(), region);
        }

        public BlockReader getDataBlock(long offset, long compressedSize, long rawSize) throws IOException {
            BlockRegion region = new BlockRegion(offset, compressedSize, rawSize);
            return this.createReader(this.dataIndex.getDefaultCompressionAlgorithm(), region);
        }

        private BlockReader createReader(Compression.Algorithm compressAlgo, BlockRegion region) throws IOException {
            RBlockState rbs = new RBlockState(compressAlgo, this.in, region, this.conf, this.cryptoModule, this.version, this.cryptoParams);
            return new BlockReader(rbs);
        }

        public static class BlockReader
        extends DataInputStream {
            private final RBlockState rBlkState;
            private boolean closed = false;

            BlockReader(RBlockState rbs) {
                super(rbs.getInputStream());
                this.rBlkState = rbs;
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                try {
                    this.rBlkState.finish();
                }
                finally {
                    this.closed = true;
                }
            }

            public String getCompressionName() {
                return this.rBlkState.getCompressionName();
            }

            public long getRawSize() {
                return this.rBlkState.getBlockRegion().getRawSize();
            }

            public long getCompressedSize() {
                return this.rBlkState.getBlockRegion().getCompressedSize();
            }

            public long getStartPos() {
                return this.rBlkState.getBlockRegion().getOffset();
            }
        }

        private static final class RBlockState {
            private final Compression.Algorithm compressAlgo;
            private Decompressor decompressor;
            private final BlockRegion region;
            private final InputStream in;
            private volatile boolean closed;

            public <InputStreamType extends InputStream> RBlockState(Compression.Algorithm compressionAlgo, InputStreamType fsin, BlockRegion region, Configuration conf, CryptoModule cryptoModule, Utils.Version bcFileVersion, CryptoModuleParameters cryptoParams) throws IOException {
                BoundedRangeFileInputStream boundedRangeFileInputStream;
                this.compressAlgo = compressionAlgo;
                this.region = region;
                this.decompressor = compressionAlgo.getDecompressor();
                InputStream inputStreamToBeCompressed = boundedRangeFileInputStream = new BoundedRangeFileInputStream(fsin, this.region.getOffset(), this.region.getCompressedSize());
                if (cryptoParams != null && cryptoModule != null) {
                    DataInputStream tempDataInputStream = new DataInputStream(boundedRangeFileInputStream);
                    int ivLength = tempDataInputStream.readInt();
                    byte[] initVector = new byte[ivLength];
                    tempDataInputStream.readFully(initVector);
                    cryptoParams.setInitializationVector(initVector);
                    cryptoParams.setEncryptedInputStream(boundedRangeFileInputStream);
                    cryptoParams.setCloseUnderylingStreamAfterCryptoStreamClose(false);
                    cryptoParams.setRecordParametersToStream(false);
                    cryptoParams = cryptoModule.getDecryptingInputStream(cryptoParams);
                    inputStreamToBeCompressed = cryptoParams.getPlaintextInputStream();
                }
                try {
                    this.in = this.compressAlgo.createDecompressionStream(inputStreamToBeCompressed, this.decompressor, BCFile.getFSInputBufferSize(conf));
                }
                catch (IOException e) {
                    this.compressAlgo.returnDecompressor(this.decompressor);
                    throw e;
                }
                this.closed = false;
            }

            public InputStream getInputStream() {
                return this.in;
            }

            public String getCompressionName() {
                return this.compressAlgo.getName();
            }

            public BlockRegion getBlockRegion() {
                return this.region;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finish() throws IOException {
                InputStream inputStream = this.in;
                synchronized (inputStream) {
                    if (!this.closed) {
                        try {
                            this.in.close();
                        }
                        finally {
                            this.closed = true;
                            if (this.decompressor != null) {
                                try {
                                    this.compressAlgo.returnDecompressor(this.decompressor);
                                }
                                finally {
                                    this.decompressor = null;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static class BCFileCryptoModuleParameters
    extends CryptoModuleParameters {
        private BCFileCryptoModuleParameters() {
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.getAllOptions().size());
            for (String key : this.getAllOptions().keySet()) {
                out.writeUTF(key);
                out.writeUTF(this.getAllOptions().get(key));
            }
            out.writeUTF(this.getOpaqueKeyEncryptionKeyID());
            out.writeInt(this.getEncryptedKey().length);
            out.write(this.getEncryptedKey());
        }

        public void read(DataInput in) throws IOException {
            HashMap<String, String> optionsFromFile = new HashMap<String, String>();
            int numContextEntries = in.readInt();
            for (int i = 0; i < numContextEntries; ++i) {
                optionsFromFile.put(in.readUTF(), in.readUTF());
            }
            CryptoModuleFactory.fillParamsObjectFromStringMap(this, optionsFromFile);
            this.setOpaqueKeyEncryptionKeyID(in.readUTF());
            int encryptedSecretKeyLength = in.readInt();
            byte[] encryptedSecretKey = new byte[encryptedSecretKeyLength];
            in.readFully(encryptedSecretKey);
            this.setEncryptedKey(encryptedSecretKey);
        }
    }

    public static class Writer
    implements Closeable {
        private final PositionedDataOutputStream out;
        private final Configuration conf;
        private final CryptoModule cryptoModule;
        private BCFileCryptoModuleParameters cryptoParams;
        private SecretKeyEncryptionStrategy secretKeyEncryptionStrategy;
        final DataIndex dataIndex;
        final MetaIndex metaIndex;
        boolean blkInProgress = false;
        private boolean metaBlkSeen = false;
        private boolean closed = false;
        long errorCount = 0L;
        private BytesWritable fsOutputBuffer;

        public <OutputStreamType extends OutputStream> Writer(OutputStreamType fout, String compressionName, Configuration conf, boolean trackDataBlocks, AccumuloConfiguration accumuloConfiguration) throws IOException {
            if (((PositionedOutput)((Object)fout)).position() != 0L) {
                throw new IOException("Output file not at zero offset.");
            }
            this.out = new PositionedDataOutputStream(fout);
            this.conf = conf;
            this.dataIndex = new DataIndex(compressionName, trackDataBlocks);
            this.metaIndex = new MetaIndex();
            this.fsOutputBuffer = new BytesWritable();
            Magic.write(this.out);
            this.cryptoModule = CryptoModuleFactory.getCryptoModule(accumuloConfiguration);
            this.cryptoParams = new BCFileCryptoModuleParameters();
            CryptoModuleFactory.fillParamsObjectFromConfiguration(this.cryptoParams, accumuloConfiguration);
            this.cryptoParams = (BCFileCryptoModuleParameters)this.cryptoModule.generateNewRandomSessionKey(this.cryptoParams);
            this.secretKeyEncryptionStrategy = CryptoModuleFactory.getSecretKeyEncryptionStrategy(accumuloConfiguration);
            this.cryptoParams = (BCFileCryptoModuleParameters)this.secretKeyEncryptionStrategy.encryptSecretKey(this.cryptoParams);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            block10: {
                if (this.closed) {
                    return;
                }
                try {
                    if (this.errorCount != 0L) break block10;
                    if (this.blkInProgress) {
                        throw new IllegalStateException("Close() called with active block appender.");
                    }
                    try (BlockAppender appender = this.prepareMetaBlock("BCFile.index", this.getDefaultCompressionAlgorithm());){
                        this.dataIndex.write(appender);
                    }
                    long offsetIndexMeta = this.out.position();
                    this.metaIndex.write(this.out);
                    if (this.cryptoParams.getAlgorithmName() == null || this.cryptoParams.getAlgorithmName().equals(Property.CRYPTO_CIPHER_SUITE.getDefaultValue())) {
                        this.out.writeLong(offsetIndexMeta);
                        API_VERSION_1.write(this.out);
                    } else {
                        long offsetCryptoParameters = this.out.position();
                        this.cryptoParams.write(this.out);
                        this.out.writeLong(offsetIndexMeta);
                        this.out.writeLong(offsetCryptoParameters);
                        API_VERSION.write(this.out);
                    }
                    Magic.write(this.out);
                    this.out.flush();
                }
                finally {
                    this.closed = true;
                }
            }
        }

        private Compression.Algorithm getDefaultCompressionAlgorithm() {
            return this.dataIndex.getDefaultCompressionAlgorithm();
        }

        private BlockAppender prepareMetaBlock(String name, Compression.Algorithm compressAlgo) throws IOException, MetaBlockAlreadyExists {
            if (this.blkInProgress) {
                throw new IllegalStateException("Cannot create Meta Block until previous block is closed.");
            }
            if (this.metaIndex.getMetaByName(name) != null) {
                throw new MetaBlockAlreadyExists("name=" + name);
            }
            MetaBlockRegister mbr = new MetaBlockRegister(name, compressAlgo);
            WBlockState wbs = new WBlockState(compressAlgo, this.out, this.fsOutputBuffer, this.conf, this.cryptoModule, this.cryptoParams);
            BlockAppender ba = new BlockAppender(mbr, wbs);
            this.blkInProgress = true;
            this.metaBlkSeen = true;
            return ba;
        }

        public BlockAppender prepareMetaBlock(String name, String compressionName) throws IOException, MetaBlockAlreadyExists {
            return this.prepareMetaBlock(name, Compression.getCompressionAlgorithmByName(compressionName));
        }

        public BlockAppender prepareMetaBlock(String name) throws IOException, MetaBlockAlreadyExists {
            return this.prepareMetaBlock(name, this.getDefaultCompressionAlgorithm());
        }

        public BlockAppender prepareDataBlock() throws IOException {
            if (this.blkInProgress) {
                throw new IllegalStateException("Cannot create Data Block until previous block is closed.");
            }
            if (this.metaBlkSeen) {
                throw new IllegalStateException("Cannot create Data Block after Meta Blocks.");
            }
            DataBlockRegister dbr = new DataBlockRegister();
            WBlockState wbs = new WBlockState(this.getDefaultCompressionAlgorithm(), this.out, this.fsOutputBuffer, this.conf, this.cryptoModule, this.cryptoParams);
            BlockAppender ba = new BlockAppender(dbr, wbs);
            this.blkInProgress = true;
            return ba;
        }

        private class DataBlockRegister
        implements BlockRegister {
            DataBlockRegister() {
            }

            @Override
            public void register(long raw, long begin, long end) {
                Writer.this.dataIndex.addBlockRegion(new BlockRegion(begin, end - begin, raw));
            }
        }

        private class MetaBlockRegister
        implements BlockRegister {
            private final String name;
            private final Compression.Algorithm compressAlgo;

            MetaBlockRegister(String name, Compression.Algorithm compressAlgo) {
                this.name = name;
                this.compressAlgo = compressAlgo;
            }

            @Override
            public void register(long raw, long begin, long end) {
                Writer.this.metaIndex.addEntry(new MetaIndexEntry(this.name, this.compressAlgo, new BlockRegion(begin, end - begin, raw)));
            }
        }

        public class BlockAppender
        extends DataOutputStream {
            private final BlockRegister blockRegister;
            private final WBlockState wBlkState;
            private boolean closed;

            BlockAppender(BlockRegister register, WBlockState wbs) {
                super(wbs.getOutputStream());
                this.closed = false;
                this.blockRegister = register;
                this.wBlkState = wbs;
            }

            public long getRawSize() throws IOException {
                return (long)this.size() & 0xFFFFFFFFL;
            }

            public long getCompressedSize() throws IOException {
                return this.wBlkState.getCompressedSize();
            }

            public long getStartPos() {
                return this.wBlkState.getStartPos();
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                try {
                    ++Writer.this.errorCount;
                    this.wBlkState.finish();
                    this.blockRegister.register(this.getRawSize(), this.wBlkState.getStartPos(), this.wBlkState.getCurrentPos());
                    --Writer.this.errorCount;
                }
                finally {
                    this.closed = true;
                    Writer.this.blkInProgress = false;
                }
            }
        }

        private static final class WBlockState {
            private final Compression.Algorithm compressAlgo;
            private Compressor compressor;
            private final PositionedDataOutputStream fsOut;
            private final OutputStream cipherOut;
            private final long posStart;
            private final SimpleBufferedOutputStream fsBufferedOutput;
            private OutputStream out;

            public WBlockState(Compression.Algorithm compressionAlgo, PositionedDataOutputStream fsOut, BytesWritable fsOutputBuffer, Configuration conf, CryptoModule cryptoModule, CryptoModuleParameters cryptoParams) throws IOException {
                this.compressAlgo = compressionAlgo;
                this.fsOut = fsOut;
                this.posStart = fsOut.position();
                fsOutputBuffer.setCapacity(BCFile.getFSOutputBufferSize(conf));
                this.fsBufferedOutput = new SimpleBufferedOutputStream(this.fsOut, fsOutputBuffer.getBytes());
                cryptoParams.setCloseUnderylingStreamAfterCryptoStreamClose(false);
                cryptoParams.setRecordParametersToStream(false);
                cryptoParams.setInitializationVector(null);
                cryptoParams = cryptoModule.initializeCipher(cryptoParams);
                DataOutputStream tempDataOutputStream = new DataOutputStream(this.fsBufferedOutput);
                if (cryptoParams.getInitializationVector() != null) {
                    tempDataOutputStream.writeInt(cryptoParams.getInitializationVector().length);
                    tempDataOutputStream.write(cryptoParams.getInitializationVector());
                }
                cryptoParams.setPlaintextOutputStream(tempDataOutputStream);
                cryptoParams = cryptoModule.getEncryptingOutputStream(cryptoParams);
                this.cipherOut = cryptoParams.getEncryptedOutputStream() == tempDataOutputStream ? this.fsBufferedOutput : cryptoParams.getEncryptedOutputStream();
                this.compressor = this.compressAlgo.getCompressor();
                try {
                    this.out = compressionAlgo.createCompressionStream(this.cipherOut, this.compressor, 0);
                }
                catch (IOException e) {
                    this.compressAlgo.returnCompressor(this.compressor);
                    throw e;
                }
            }

            OutputStream getOutputStream() {
                return this.out;
            }

            long getCurrentPos() throws IOException {
                return this.fsOut.position() + (long)this.fsBufferedOutput.size();
            }

            long getStartPos() {
                return this.posStart;
            }

            long getCompressedSize() throws IOException {
                long ret = this.getCurrentPos() - this.posStart;
                return ret;
            }

            public void finish() throws IOException {
                try {
                    if (this.out != null) {
                        this.out.flush();
                        if (this.fsBufferedOutput != this.cipherOut) {
                            this.cipherOut.close();
                        }
                        this.out = null;
                    }
                }
                finally {
                    this.compressAlgo.returnCompressor(this.compressor);
                    this.compressor = null;
                }
            }
        }

        private static interface BlockRegister {
            public void register(long var1, long var3, long var5);
        }
    }
}

