/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.client.impl.TabletServerBatchReaderIterator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServerBatchReader
extends ScannerOptions
implements BatchScanner {
    private static final Logger log = LoggerFactory.getLogger(TabletServerBatchReader.class);
    private String tableId;
    private int numThreads;
    private ExecutorService queryThreadPool;
    private final ClientContext context;
    private ArrayList<Range> ranges;
    private Authorizations authorizations = Authorizations.EMPTY;
    private Throwable ex = null;
    private static int nextBatchReaderInstance = 1;
    private final int batchReaderInstance = TabletServerBatchReader.getNextBatchReaderInstance();

    private static synchronized int getNextBatchReaderInstance() {
        return nextBatchReaderInstance++;
    }

    public TabletServerBatchReader(ClientContext context, String tableId, Authorizations authorizations, int numQueryThreads) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId is null");
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        this.context = context;
        this.authorizations = authorizations;
        this.tableId = tableId;
        this.numThreads = numQueryThreads;
        this.queryThreadPool = new SimpleThreadPool(numQueryThreads, "batch scanner " + this.batchReaderInstance + "-");
        this.ranges = null;
        this.ex = new Throwable();
    }

    @Override
    public void close() {
        this.queryThreadPool.shutdownNow();
    }

    @Override
    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    protected void finalize() {
        if (!this.queryThreadPool.isShutdown()) {
            log.warn(TabletServerBatchReader.class.getSimpleName() + " not shutdown; did you forget to call close()?", this.ex);
            this.close();
        }
    }

    @Override
    public void setRanges(Collection<Range> ranges) {
        if (ranges == null || ranges.size() == 0) {
            throw new IllegalArgumentException("ranges must be non null and contain at least 1 range");
        }
        if (this.queryThreadPool.isShutdown()) {
            throw new IllegalStateException("batch reader closed");
        }
        this.ranges = new ArrayList<Range>(ranges);
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        if (this.ranges == null) {
            throw new IllegalStateException("ranges not set");
        }
        if (this.queryThreadPool.isShutdown()) {
            throw new IllegalStateException("batch reader closed");
        }
        return new TabletServerBatchReaderIterator(this.context, this.tableId, this.authorizations, this.ranges, this.numThreads, this.queryThreadPool, this, this.retryTimeout);
    }
}

