/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import java.util.Iterator;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.data.ConditionalMutation;

public interface ConditionalWriter
extends AutoCloseable {
    public Iterator<Result> write(Iterator<ConditionalMutation> var1);

    public Result write(ConditionalMutation var1);

    @Override
    public void close();

    public static enum Status {
        ACCEPTED,
        REJECTED,
        VIOLATED,
        UNKNOWN,
        INVISIBLE_VISIBILITY;

    }

    public static class Result {
        private Status status;
        private ConditionalMutation mutation;
        private String server;
        private Exception exception;

        public Result(Status s, ConditionalMutation m, String server) {
            this.status = s;
            this.mutation = m;
            this.server = server;
        }

        public Result(Exception e, ConditionalMutation cm, String server) {
            this.exception = e;
            this.mutation = cm;
            this.server = server;
        }

        public Status getStatus() throws AccumuloException, AccumuloSecurityException {
            if (this.status == null) {
                if (this.exception instanceof AccumuloException) {
                    throw new AccumuloException(this.exception);
                }
                if (this.exception instanceof AccumuloSecurityException) {
                    AccumuloSecurityException ase = (AccumuloSecurityException)this.exception;
                    throw new AccumuloSecurityException(ase.getUser(), SecurityErrorCode.valueOf(ase.getSecurityErrorCode().name()), ase.getTableInfo(), ase);
                }
                throw new AccumuloException(this.exception);
            }
            return this.status;
        }

        public ConditionalMutation getMutation() {
            return this.mutation;
        }

        public String getTabletServer() {
            return this.server;
        }
    }
}

