/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.event.ConfigurationErrorEvent;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfiguration
extends CompositeConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ClientConfiguration.class);
    public static final String USER_ACCUMULO_DIR_NAME = ".accumulo";
    public static final String USER_CONF_FILENAME = "config";
    public static final String GLOBAL_CONF_FILENAME = "client.conf";

    private static PropertiesConfiguration newPropsFile(String file) throws ConfigurationException {
        PropertiesConfiguration props = new PropertiesConfiguration();
        props.setListDelimiter('\u0000');
        props.load(file);
        return props;
    }

    private static PropertiesConfiguration newPropsFile(File file) throws ConfigurationException {
        PropertiesConfiguration props = new PropertiesConfiguration();
        props.setListDelimiter('\u0000');
        props.load(file);
        return props;
    }

    @Deprecated
    public ClientConfiguration(String configFile) throws ConfigurationException {
        this(Collections.singletonList(ClientConfiguration.newPropsFile(configFile)));
    }

    @Deprecated
    public ClientConfiguration(File configFile) throws ConfigurationException {
        this(Collections.singletonList(ClientConfiguration.newPropsFile(configFile)));
    }

    @Deprecated
    public ClientConfiguration(List<? extends Configuration> configs) {
        super(configs);
        this.setListDelimiter('\u0000');
        for (Configuration configuration : configs) {
            AbstractConfiguration abstractConfiguration;
            if (!(configuration instanceof AbstractConfiguration) || (abstractConfiguration = (AbstractConfiguration)configuration).isDelimiterParsingDisabled() || abstractConfiguration.getListDelimiter() == '\u0000') continue;
            log.warn("Client configuration constructed with a Configuration that did not have list delimiter disabled or overridden, multi-valued config properties may be unavailable");
            abstractConfiguration.setListDelimiter('\u0000');
        }
    }

    @Deprecated
    public ClientConfiguration(Configuration ... configs) {
        this(Arrays.asList(configs));
    }

    public static ClientConfiguration loadDefault() {
        return ClientConfiguration.loadFromSearchPath(ClientConfiguration.getDefaultSearchPath());
    }

    public static ClientConfiguration create() {
        return new ClientConfiguration(Collections.emptyList());
    }

    public static ClientConfiguration fromFile(File file) {
        try {
            return new ClientConfiguration(file);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Bad configuration file: " + file, e);
        }
    }

    public static ClientConfiguration fromMap(Map<String, String> properties) {
        MapConfiguration mapConf = new MapConfiguration(properties);
        mapConf.setListDelimiter('\u0000');
        return new ClientConfiguration(Collections.singletonList(mapConf));
    }

    private static ClientConfiguration loadFromSearchPath(List<String> paths) {
        LinkedList<PropertiesConfiguration> configs = new LinkedList<PropertiesConfiguration>();
        for (String path : paths) {
            File conf = new File(path);
            if (!conf.isFile() || !conf.canRead()) continue;
            PropertiesConfiguration props = new PropertiesConfiguration();
            props.setListDelimiter('\u0000');
            try {
                props.load(conf);
                log.info("Loaded client configuration file {}", (Object)conf);
            }
            catch (ConfigurationException e) {
                throw new IllegalStateException("Error loading client configuration file " + conf, e);
            }
            configs.add(props);
        }
        if (configs.isEmpty()) {
            log.warn("Found no client.conf in default paths. Using default client configuration values.");
        }
        return new ClientConfiguration(configs);
    }

    public static ClientConfiguration deserialize(String serializedConfig) {
        PropertiesConfiguration propConfig = new PropertiesConfiguration();
        propConfig.setListDelimiter('\u0000');
        try {
            propConfig.load((Reader)new StringReader(serializedConfig));
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Error deserializing client configuration: " + serializedConfig, e);
        }
        return new ClientConfiguration(new Configuration[]{propConfig});
    }

    static String getClientConfPath(String clientConfPath) {
        if (null == clientConfPath) {
            return null;
        }
        File filePath = new File(clientConfPath);
        if (filePath.exists() && filePath.isDirectory()) {
            return new File(filePath, GLOBAL_CONF_FILENAME).toString();
        }
        return clientConfPath;
    }

    private static List<String> getDefaultSearchPath() {
        LinkedList<String> clientConfPaths;
        String clientConfSearchPath = ClientConfiguration.getClientConfPath(System.getenv("ACCUMULO_CLIENT_CONF_PATH"));
        if (clientConfSearchPath != null) {
            clientConfPaths = Arrays.asList(clientConfSearchPath.split(File.pathSeparator));
        } else {
            clientConfPaths = new LinkedList();
            clientConfPaths.add(System.getProperty("user.home") + File.separator + USER_ACCUMULO_DIR_NAME + File.separator + USER_CONF_FILENAME);
            if (System.getenv("ACCUMULO_CONF_DIR") != null) {
                clientConfPaths.add(System.getenv("ACCUMULO_CONF_DIR") + File.separator + GLOBAL_CONF_FILENAME);
            } else if (System.getenv("ACCUMULO_HOME") != null) {
                clientConfPaths.add(System.getenv("ACCUMULO_HOME") + File.separator + "conf" + File.separator + GLOBAL_CONF_FILENAME);
            }
            clientConfPaths.add("/etc/accumulo/client.conf");
            clientConfPaths.add("/etc/accumulo/conf/client.conf");
        }
        return clientConfPaths;
    }

    public String serialize() {
        PropertiesConfiguration propConfig = new PropertiesConfiguration();
        propConfig.copy((Configuration)this);
        StringWriter writer = new StringWriter();
        try {
            propConfig.save((Writer)writer);
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException(e);
        }
        return writer.toString();
    }

    public String get(ClientProperty prop) {
        if (this.containsKey(prop.getKey())) {
            return this.getString(prop.getKey());
        }
        return prop.getDefaultValue();
    }

    private void checkType(ClientProperty property, PropertyType type) {
        if (!property.getType().equals((Object)type)) {
            String msg = "Configuration method intended for type " + (Object)((Object)type) + " called with a " + (Object)((Object)property.getType()) + " argument (" + property.getKey() + ")";
            throw new IllegalArgumentException(msg);
        }
    }

    public Map<String, String> getAllPropertiesWithPrefix(ClientProperty property) {
        this.checkType(property, PropertyType.PREFIX);
        HashMap<String, String> propMap = new HashMap<String, String>();
        String prefix = property.getKey();
        if (prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        Iterator<String> iter = this.getKeys(prefix);
        while (iter.hasNext()) {
            String p = iter.next();
            propMap.put(p, this.getString(p));
        }
        return propMap;
    }

    public void setProperty(ClientProperty prop, String value) {
        this.with(prop, value);
    }

    public ClientConfiguration with(ClientProperty prop, String value) {
        return this.with(prop.getKey(), value);
    }

    public void setProperty(String prop, String value) {
        this.with(prop, value);
    }

    public ClientConfiguration with(String prop, String value) {
        super.setProperty(prop, (Object)value);
        return this;
    }

    public ClientConfiguration withInstance(String instanceName) {
        Preconditions.checkArgument((instanceName != null ? 1 : 0) != 0, (Object)"instanceName is null");
        return this.with(ClientProperty.INSTANCE_NAME, instanceName);
    }

    public ClientConfiguration withInstance(UUID instanceId) {
        Preconditions.checkArgument((instanceId != null ? 1 : 0) != 0, (Object)"instanceId is null");
        return this.with(ClientProperty.INSTANCE_ID, instanceId.toString());
    }

    public ClientConfiguration withZkHosts(String zooKeepers) {
        Preconditions.checkArgument((zooKeepers != null ? 1 : 0) != 0, (Object)"zooKeepers is null");
        return this.with(ClientProperty.INSTANCE_ZK_HOST, zooKeepers);
    }

    public ClientConfiguration withZkTimeout(int timeout) {
        return this.with(ClientProperty.INSTANCE_ZK_TIMEOUT, String.valueOf(timeout));
    }

    public ClientConfiguration withSsl(boolean sslEnabled) {
        return this.withSsl(sslEnabled, false);
    }

    public ClientConfiguration withSsl(boolean sslEnabled, boolean useJsseConfig) {
        return this.with(ClientProperty.INSTANCE_RPC_SSL_ENABLED, String.valueOf(sslEnabled)).with(ClientProperty.RPC_USE_JSSE, String.valueOf(useJsseConfig));
    }

    public ClientConfiguration withTruststore(String path) {
        return this.withTruststore(path, null, null);
    }

    public ClientConfiguration withTruststore(String path, String password, String type) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path is null");
        this.setProperty(ClientProperty.RPC_SSL_TRUSTSTORE_PATH, path);
        if (password != null) {
            this.setProperty(ClientProperty.RPC_SSL_TRUSTSTORE_PASSWORD, password);
        }
        if (type != null) {
            this.setProperty(ClientProperty.RPC_SSL_TRUSTSTORE_TYPE, type);
        }
        return this;
    }

    public ClientConfiguration withKeystore(String path) {
        return this.withKeystore(path, null, null);
    }

    public ClientConfiguration withKeystore(String path, String password, String type) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path is null");
        this.setProperty(ClientProperty.INSTANCE_RPC_SSL_CLIENT_AUTH, "true");
        this.setProperty(ClientProperty.RPC_SSL_KEYSTORE_PATH, path);
        if (password != null) {
            this.setProperty(ClientProperty.RPC_SSL_KEYSTORE_PASSWORD, password);
        }
        if (type != null) {
            this.setProperty(ClientProperty.RPC_SSL_KEYSTORE_TYPE, type);
        }
        return this;
    }

    public ClientConfiguration withSasl(boolean saslEnabled) {
        return this.with(ClientProperty.INSTANCE_RPC_SASL_ENABLED, String.valueOf(saslEnabled));
    }

    public boolean hasSasl() {
        return this.getBoolean(ClientProperty.INSTANCE_RPC_SASL_ENABLED.getKey(), Boolean.parseBoolean(ClientProperty.INSTANCE_RPC_SASL_ENABLED.getDefaultValue()));
    }

    public ClientConfiguration withSasl(boolean saslEnabled, String kerberosServerPrimary) {
        return this.withSasl(saslEnabled).with(ClientProperty.KERBEROS_SERVER_PRIMARY, kerberosServerPrimary);
    }

    @Deprecated
    public Configuration getConfiguration(int index) {
        return super.getConfiguration(index);
    }

    @Deprecated
    public Configuration getSource(String key) {
        return super.getSource(key);
    }

    @Deprecated
    public void removeConfiguration(Configuration config) {
        super.removeConfiguration(config);
    }

    @Deprecated
    public void addConfiguration(Configuration config) {
        super.addConfiguration(config);
    }

    @Deprecated
    public Configuration getInMemoryConfiguration() {
        return super.getInMemoryConfiguration();
    }

    @Deprecated
    public Log getLogger() {
        return super.getLogger();
    }

    @Deprecated
    public Configuration subset(String prefix) {
        return super.subset(prefix);
    }

    @Deprecated
    public Configuration interpolatedConfiguration() {
        return super.interpolatedConfiguration();
    }

    @Deprecated
    public void setLogger(Log log) {
        super.setLogger(log);
    }

    @Deprecated
    public ConfigurationInterpolator getInterpolator() {
        return super.getInterpolator();
    }

    @Deprecated
    public synchronized StrSubstitutor getSubstitutor() {
        return super.getSubstitutor();
    }

    @Deprecated
    public void append(Configuration c) {
        super.append(c);
    }

    @Deprecated
    public void copy(Configuration c) {
        super.copy(c);
    }

    @Deprecated
    public void addConfigurationListener(ConfigurationListener l) {
        super.addConfigurationListener(l);
    }

    @Deprecated
    public boolean removeConfigurationListener(ConfigurationListener l) {
        return super.removeConfigurationListener(l);
    }

    @Deprecated
    public boolean removeErrorListener(ConfigurationErrorListener l) {
        return super.removeErrorListener(l);
    }

    @Deprecated
    public void addErrorListener(ConfigurationErrorListener l) {
        super.addErrorListener(l);
    }

    @Deprecated
    public void addErrorLogListener() {
        super.addErrorLogListener();
    }

    @Deprecated
    public void addProperty(String key, Object value) {
        super.addProperty(key, value);
    }

    @Deprecated
    protected void addPropertyDirect(String key, Object token) {
        super.addPropertyDirect(key, token);
    }

    @Deprecated
    public void clear() {
        super.clear();
    }

    @Deprecated
    public void clearConfigurationListeners() {
        super.clearConfigurationListeners();
    }

    @Deprecated
    public void clearErrorListeners() {
        super.clearErrorListeners();
    }

    @Deprecated
    public void clearProperty(String key) {
        super.clearProperty(key);
    }

    @Deprecated
    protected void clearPropertyDirect(String key) {
        super.clearPropertyDirect(key);
    }

    public boolean containsKey(String key) {
        return super.containsKey(key);
    }

    @Deprecated
    protected ConfigurationErrorEvent createErrorEvent(int type, String propName, Object propValue, Throwable ex) {
        return super.createErrorEvent(type, propName, propValue, ex);
    }

    @Deprecated
    protected ConfigurationEvent createEvent(int type, String propName, Object propValue, boolean before) {
        return super.createEvent(type, propName, propValue, before);
    }

    @Deprecated
    protected ConfigurationInterpolator createInterpolator() {
        return super.createInterpolator();
    }

    @Deprecated
    protected void fireError(int type, String propName, Object propValue, Throwable ex) {
        super.fireError(type, propName, propValue, ex);
    }

    @Deprecated
    protected void fireEvent(int type, String propName, Object propValue, boolean before) {
        super.fireEvent(type, propName, propValue, before);
    }

    @Deprecated
    public BigDecimal getBigDecimal(String key) {
        return super.getBigDecimal(key);
    }

    @Deprecated
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return super.getBigDecimal(key, defaultValue);
    }

    @Deprecated
    public BigInteger getBigInteger(String key) {
        return super.getBigInteger(key);
    }

    @Deprecated
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return super.getBigInteger(key, defaultValue);
    }

    @Deprecated
    public boolean getBoolean(String key) {
        return super.getBoolean(key);
    }

    @Deprecated
    public boolean getBoolean(String key, boolean defaultValue) {
        return super.getBoolean(key, defaultValue);
    }

    @Deprecated
    public Boolean getBoolean(String key, Boolean defaultValue) {
        return super.getBoolean(key, defaultValue);
    }

    @Deprecated
    public byte getByte(String key) {
        return super.getByte(key);
    }

    @Deprecated
    public byte getByte(String key, byte defaultValue) {
        return super.getByte(key, defaultValue);
    }

    @Deprecated
    public Byte getByte(String key, Byte defaultValue) {
        return super.getByte(key, defaultValue);
    }

    @Deprecated
    public Collection getConfigurationListeners() {
        return super.getConfigurationListeners();
    }

    @Deprecated
    public double getDouble(String key) {
        return super.getDouble(key);
    }

    @Deprecated
    public Double getDouble(String key, Double defaultValue) {
        return super.getDouble(key, defaultValue);
    }

    @Deprecated
    public double getDouble(String key, double defaultValue) {
        return super.getDouble(key, defaultValue);
    }

    @Deprecated
    public Collection getErrorListeners() {
        return super.getErrorListeners();
    }

    @Deprecated
    public float getFloat(String key) {
        return super.getFloat(key);
    }

    @Deprecated
    public Float getFloat(String key, Float defaultValue) {
        return super.getFloat(key, defaultValue);
    }

    @Deprecated
    public float getFloat(String key, float defaultValue) {
        return super.getFloat(key, defaultValue);
    }

    @Deprecated
    public int getInt(String key) {
        return super.getInt(key);
    }

    @Deprecated
    public int getInt(String key, int defaultValue) {
        return super.getInt(key, defaultValue);
    }

    @Deprecated
    public Integer getInteger(String key, Integer defaultValue) {
        return super.getInteger(key, defaultValue);
    }

    public Iterator<String> getKeys() {
        return super.getKeys();
    }

    @Deprecated
    public Iterator<String> getKeys(String key) {
        return super.getKeys(key);
    }

    @Deprecated
    public List getList(String key) {
        return super.getList(key);
    }

    @Deprecated
    public List getList(String key, List defaultValue) {
        return super.getList(key, defaultValue);
    }

    @Deprecated
    public char getListDelimiter() {
        return super.getListDelimiter();
    }

    @Deprecated
    public long getLong(String key) {
        return super.getLong(key);
    }

    @Deprecated
    public long getLong(String key, long defaultValue) {
        return super.getLong(key, defaultValue);
    }

    @Deprecated
    public Long getLong(String key, Long defaultValue) {
        return super.getLong(key, defaultValue);
    }

    @Deprecated
    public int getNumberOfConfigurations() {
        return super.getNumberOfConfigurations();
    }

    @Deprecated
    public Properties getProperties(String key) {
        return super.getProperties(key);
    }

    @Deprecated
    public Properties getProperties(String key, Properties defaults) {
        return super.getProperties(key, defaults);
    }

    @Deprecated
    public Object getProperty(String key) {
        return super.getProperty(key);
    }

    @Deprecated
    public short getShort(String key) {
        return super.getShort(key);
    }

    @Deprecated
    public short getShort(String key, short defaultValue) {
        return super.getShort(key, defaultValue);
    }

    @Deprecated
    public Short getShort(String key, Short defaultValue) {
        return super.getShort(key, defaultValue);
    }

    public String getString(String key) {
        return super.getString(key);
    }

    @Deprecated
    public String getString(String key, String defaultValue) {
        return super.getString(key, defaultValue);
    }

    @Deprecated
    public String[] getStringArray(String key) {
        return super.getStringArray(key);
    }

    @Deprecated
    protected Object interpolate(Object value) {
        return super.interpolate(value);
    }

    @Deprecated
    protected String interpolate(String base) {
        return super.interpolate(base);
    }

    @Deprecated
    protected String interpolateHelper(String base, List priorVariables) {
        return super.interpolateHelper(base, priorVariables);
    }

    @Deprecated
    public boolean isDelimiterParsingDisabled() {
        return super.isDelimiterParsingDisabled();
    }

    @Deprecated
    public boolean isDetailEvents() {
        return super.isDetailEvents();
    }

    @Deprecated
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Deprecated
    public boolean isThrowExceptionOnMissing() {
        return super.isThrowExceptionOnMissing();
    }

    @Deprecated
    protected Object resolveContainerStore(String key) {
        return super.resolveContainerStore(key);
    }

    @Deprecated
    public void setDelimiterParsingDisabled(boolean delimiterParsingDisabled) {
        super.setDelimiterParsingDisabled(delimiterParsingDisabled);
    }

    @Deprecated
    public void setDetailEvents(boolean enable) {
        super.setDetailEvents(enable);
    }

    @Deprecated
    public void setListDelimiter(char listDelimiter) {
        super.setListDelimiter(listDelimiter);
    }

    @Deprecated
    public void setProperty(String key, Object value) {
        super.setProperty(key, value);
    }

    @Deprecated
    public void setThrowExceptionOnMissing(boolean throwExceptionOnMissing) {
        super.setThrowExceptionOnMissing(throwExceptionOnMissing);
    }

    public static enum ClientProperty {
        RPC_SSL_TRUSTSTORE_PATH(Property.RPC_SSL_TRUSTSTORE_PATH),
        RPC_SSL_TRUSTSTORE_PASSWORD(Property.RPC_SSL_TRUSTSTORE_PASSWORD),
        RPC_SSL_TRUSTSTORE_TYPE(Property.RPC_SSL_TRUSTSTORE_TYPE),
        RPC_SSL_KEYSTORE_PATH(Property.RPC_SSL_KEYSTORE_PATH),
        RPC_SSL_KEYSTORE_PASSWORD(Property.RPC_SSL_KEYSTORE_PASSWORD),
        RPC_SSL_KEYSTORE_TYPE(Property.RPC_SSL_KEYSTORE_TYPE),
        RPC_USE_JSSE(Property.RPC_USE_JSSE),
        GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS),
        INSTANCE_RPC_SSL_CLIENT_AUTH(Property.INSTANCE_RPC_SSL_CLIENT_AUTH),
        INSTANCE_RPC_SSL_ENABLED(Property.INSTANCE_RPC_SSL_ENABLED),
        INSTANCE_ZK_HOST(Property.INSTANCE_ZK_HOST),
        INSTANCE_ZK_TIMEOUT(Property.INSTANCE_ZK_TIMEOUT),
        INSTANCE_NAME("instance.name", null, PropertyType.STRING, "Name of Accumulo instance to connect to"),
        INSTANCE_ID("instance.id", null, PropertyType.STRING, "UUID of Accumulo instance to connect to"),
        TRACE_SPAN_RECEIVERS(Property.TRACE_SPAN_RECEIVERS),
        TRACE_SPAN_RECEIVER_PREFIX(Property.TRACE_SPAN_RECEIVER_PREFIX),
        TRACE_ZK_PATH(Property.TRACE_ZK_PATH),
        INSTANCE_RPC_SASL_ENABLED(Property.INSTANCE_RPC_SASL_ENABLED),
        RPC_SASL_QOP(Property.RPC_SASL_QOP),
        KERBEROS_SERVER_PRIMARY("kerberos.server.primary", "accumulo", PropertyType.STRING, "The first component of the Kerberos principal, the 'primary', that Accumulo servers use to login");

        private String key;
        private String defaultValue;
        private PropertyType type;
        private String description;
        private Property accumuloProperty = null;

        private ClientProperty(Property prop) {
            this(prop.getKey(), prop.getDefaultValue(), prop.getType(), prop.getDescription());
            this.accumuloProperty = prop;
        }

        private ClientProperty(String key, String defaultValue, PropertyType type, String description) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.type = type;
            this.description = description;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Deprecated
        public PropertyType getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        @Deprecated
        public Property getAccumuloProperty() {
            return this.accumuloProperty;
        }

        public static ClientProperty getPropertyByKey(String key) {
            for (ClientProperty prop : ClientProperty.values()) {
                if (!prop.getKey().equals(key)) continue;
                return prop;
            }
            return null;
        }
    }
}

