/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.bulk;

import java.net.InetAddress;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.bulk.BulkPlusOne;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class Setup
extends Test {
    private static final int MAX_POOL_SIZE = 8;
    static String tableName = null;

    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Random rand = new Random();
        String hostname = InetAddress.getLocalHost().getHostName().replaceAll("[-.]", "_");
        String pid = env.getPid();
        tableName = String.format("bulk_%s_%s_%d", hostname, pid, System.currentTimeMillis());
        this.log.info((Object)("Starting bulk test on " + tableName));
        TableOperations tableOps = env.getConnector().tableOperations();
        try {
            if (!tableOps.exists(Setup.getTableName())) {
                tableOps.create(Setup.getTableName());
                IteratorSetting is = new IteratorSetting(10, SummingCombiner.class);
                SummingCombiner.setEncodingType((IteratorSetting)is, (LongCombiner.Type)LongCombiner.Type.STRING);
                SummingCombiner.setCombineAllColumns((IteratorSetting)is, (boolean)true);
                tableOps.attachIterator(Setup.getTableName(), is);
            }
        }
        catch (TableExistsException is) {
            // empty catch block
        }
        state.set("rand", rand);
        state.set("fs", FileSystem.get((Configuration)CachedConfiguration.getInstance()));
        state.set("bulkImportSuccess", "true");
        BulkPlusOne.counter.set(0L);
        SimpleThreadPool e = new SimpleThreadPool(8, "bulkImportPool");
        state.set("pool", e);
    }

    public static String getTableName() {
        return tableName;
    }

    public static ThreadPoolExecutor getThreadPool(State state) {
        return (ThreadPoolExecutor)state.get("pool");
    }

    public static void run(State state, Runnable r) {
        Setup.getThreadPool(state).submit(r);
    }
}

