/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.proxy;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.proxy.Proxy;
import org.apache.accumulo.proxy.Util;
import org.apache.accumulo.proxy.thrift.BatchScanOptions;
import org.apache.accumulo.proxy.thrift.ColumnUpdate;
import org.apache.accumulo.proxy.thrift.Key;
import org.apache.accumulo.proxy.thrift.KeyValue;
import org.apache.accumulo.proxy.thrift.Range;
import org.apache.accumulo.proxy.thrift.ScanColumn;
import org.apache.accumulo.proxy.thrift.ScanOptions;
import org.apache.accumulo.proxy.thrift.ScanResult;
import org.apache.accumulo.proxy.thrift.TimeType;
import org.apache.accumulo.test.proxy.TestProxyClient;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestProxyReadWrite {
    protected static TServer proxy;
    protected static TestProxyClient tpc;
    protected static ByteBuffer userpass;
    protected static final int port = 10194;
    protected static final String testtable = "testtable";

    @BeforeClass
    public static void setup() throws Exception {
        Properties prop = new Properties();
        prop.setProperty("useMockInstance", "true");
        prop.put("tokenClass", PasswordToken.class.getName());
        proxy = Proxy.createProxyServer((HostAndPort)HostAndPort.fromParts((String)"localhost", (int)10194), (TProtocolFactory)new TCompactProtocol.Factory(), (Properties)prop).server;
        tpc = new TestProxyClient("localhost", 10194);
        userpass = tpc.proxy().login("root", Collections.singletonMap("password", ""));
    }

    @AfterClass
    public static void tearDown() throws InterruptedException {
        proxy.stop();
    }

    @Before
    public void makeTestTable() throws Exception {
        tpc.proxy().createTable(userpass, testtable, true, TimeType.MILLIS);
    }

    @After
    public void deleteTestTable() throws Exception {
        tpc.proxy().deleteTable(userpass, testtable);
    }

    private static void addMutation(Map<ByteBuffer, List<ColumnUpdate>> mutations, String row, String cf, String cq, String value) {
        ColumnUpdate update = new ColumnUpdate(ByteBuffer.wrap(cf.getBytes()), ByteBuffer.wrap(cq.getBytes()));
        update.setValue(value.getBytes());
        mutations.put(ByteBuffer.wrap(row.getBytes()), Collections.singletonList(update));
    }

    private static void addMutation(Map<ByteBuffer, List<ColumnUpdate>> mutations, String row, String cf, String cq, String vis, String value) {
        ColumnUpdate update = new ColumnUpdate(ByteBuffer.wrap(cf.getBytes()), ByteBuffer.wrap(cq.getBytes()));
        update.setValue(value.getBytes());
        update.setColVisibility(vis.getBytes());
        mutations.put(ByteBuffer.wrap(row.getBytes()), Collections.singletonList(update));
    }

    @Test
    public void readWriteBatchOneShotWithRange() throws Exception {
        int maxInserts = 100000;
        HashMap<ByteBuffer, List<ColumnUpdate>> mutations = new HashMap<ByteBuffer, List<ColumnUpdate>>();
        String format = "%1$05d";
        for (int i = 0; i < maxInserts; ++i) {
            TestProxyReadWrite.addMutation(mutations, String.format(format, i), "cf" + i, "cq" + i, Util.randString((int)10));
            if (i % 1000 != 0 && i != maxInserts - 1) continue;
            tpc.proxy().updateAndFlush(userpass, testtable, mutations);
            mutations.clear();
        }
        Key stop = new Key();
        stop.setRow("5".getBytes());
        BatchScanOptions options = new BatchScanOptions();
        options.ranges = Collections.singletonList(new Range(null, false, stop, false));
        String cookie = tpc.proxy().createBatchScanner(userpass, testtable, options);
        int i = 0;
        boolean hasNext = true;
        int k = 1000;
        while (hasNext) {
            ScanResult kvList = tpc.proxy().nextK(cookie, k);
            i += kvList.getResultsSize();
            hasNext = kvList.isMore();
        }
        Assert.assertEquals((long)i, (long)50000L);
    }

    @Test
    public void readWriteBatchOneShotWithColumnFamilyOnly() throws Exception {
        int maxInserts = 100000;
        HashMap<ByteBuffer, List<ColumnUpdate>> mutations = new HashMap<ByteBuffer, List<ColumnUpdate>>();
        String format = "%1$05d";
        for (int i = 0; i < maxInserts; ++i) {
            TestProxyReadWrite.addMutation(mutations, String.format(format, i), "cf" + i % 2, "cq" + i % 2, Util.randString((int)10));
            if (i % 1000 != 0 && i != maxInserts - 1) continue;
            tpc.proxy().updateAndFlush(userpass, testtable, mutations);
            mutations.clear();
        }
        BatchScanOptions options = new BatchScanOptions();
        ScanColumn sc = new ScanColumn();
        sc.colFamily = ByteBuffer.wrap("cf0".getBytes());
        options.columns = Collections.singletonList(sc);
        String cookie = tpc.proxy().createBatchScanner(userpass, testtable, options);
        int i = 0;
        boolean hasNext = true;
        int k = 1000;
        while (hasNext) {
            ScanResult kvList = tpc.proxy().nextK(cookie, k);
            i += kvList.getResultsSize();
            hasNext = kvList.isMore();
        }
        Assert.assertEquals((long)i, (long)50000L);
    }

    @Test
    public void readWriteBatchOneShotWithFullColumn() throws Exception {
        int maxInserts = 100000;
        HashMap<ByteBuffer, List<ColumnUpdate>> mutations = new HashMap<ByteBuffer, List<ColumnUpdate>>();
        String format = "%1$05d";
        for (int i = 0; i < maxInserts; ++i) {
            TestProxyReadWrite.addMutation(mutations, String.format(format, i), "cf" + i % 2, "cq" + i % 2, Util.randString((int)10));
            if (i % 1000 != 0 && i != maxInserts - 1) continue;
            tpc.proxy().updateAndFlush(userpass, testtable, mutations);
            mutations.clear();
        }
        BatchScanOptions options = new BatchScanOptions();
        ScanColumn sc = new ScanColumn();
        sc.colFamily = ByteBuffer.wrap("cf0".getBytes());
        sc.colQualifier = ByteBuffer.wrap("cq0".getBytes());
        options.columns = Collections.singletonList(sc);
        String cookie = tpc.proxy().createBatchScanner(userpass, testtable, options);
        int i = 0;
        boolean hasNext = true;
        int k = 1000;
        while (hasNext) {
            ScanResult kvList = tpc.proxy().nextK(cookie, k);
            i += kvList.getResultsSize();
            hasNext = kvList.isMore();
        }
        Assert.assertEquals((long)i, (long)50000L);
    }

    @Test
    public void readWriteBatchOneShotWithFilterIterator() throws Exception {
        int maxInserts = 10000;
        HashMap<ByteBuffer, List<ColumnUpdate>> mutations = new HashMap<ByteBuffer, List<ColumnUpdate>>();
        String format = "%1$05d";
        for (int i = 0; i < maxInserts; ++i) {
            TestProxyReadWrite.addMutation(mutations, String.format(format, i), "cf" + i, "cq" + i, Util.randString((int)10));
            if (i % 1000 != 0 && i != maxInserts - 1) continue;
            tpc.proxy().updateAndFlush(userpass, testtable, mutations);
            mutations.clear();
        }
        String regex = ".*[02468]";
        IteratorSetting is = new IteratorSetting(50, regex, RegExFilter.class);
        RegExFilter.setRegexs((IteratorSetting)is, (String)regex, null, null, null, (boolean)false);
        org.apache.accumulo.proxy.thrift.IteratorSetting pis = Util.iteratorSetting2ProxyIteratorSetting((IteratorSetting)is);
        ScanOptions opts = new ScanOptions();
        opts.iterators = Collections.singletonList(pis);
        String cookie = tpc.proxy().createScanner(userpass, testtable, opts);
        int i = 0;
        boolean hasNext = true;
        int k = 1000;
        while (hasNext) {
            ScanResult kvList = tpc.proxy().nextK(cookie, k);
            for (KeyValue kv : kvList.getResults()) {
                Assert.assertEquals((long)Integer.parseInt(new String(kv.getKey().getRow())), (long)i);
                i += 2;
            }
            hasNext = kvList.isMore();
        }
    }

    @Test
    public void readWriteOneShotWithRange() throws Exception {
        int maxInserts = 100000;
        HashMap<ByteBuffer, List<ColumnUpdate>> mutations = new HashMap<ByteBuffer, List<ColumnUpdate>>();
        String format = "%1$05d";
        for (int i = 0; i < maxInserts; ++i) {
            TestProxyReadWrite.addMutation(mutations, String.format(format, i), "cf" + i, "cq" + i, Util.randString((int)10));
            if (i % 1000 != 0 && i != maxInserts - 1) continue;
            tpc.proxy().updateAndFlush(userpass, testtable, mutations);
            mutations.clear();
        }
        Key stop = new Key();
        stop.setRow("5".getBytes());
        ScanOptions opts = new ScanOptions();
        opts.range = new Range(null, false, stop, false);
        String cookie = tpc.proxy().createScanner(userpass, testtable, opts);
        int i = 0;
        boolean hasNext = true;
        int k = 1000;
        while (hasNext) {
            ScanResult kvList = tpc.proxy().nextK(cookie, k);
            i += kvList.getResultsSize();
            hasNext = kvList.isMore();
        }
        Assert.assertEquals((long)i, (long)50000L);
    }

    @Test
    public void readWriteOneShotWithFilterIterator() throws Exception {
        int maxInserts = 10000;
        HashMap<ByteBuffer, List<ColumnUpdate>> mutations = new HashMap<ByteBuffer, List<ColumnUpdate>>();
        String format = "%1$05d";
        for (int i = 0; i < maxInserts; ++i) {
            TestProxyReadWrite.addMutation(mutations, String.format(format, i), "cf" + i, "cq" + i, Util.randString((int)10));
            if (i % 1000 != 0 && i != maxInserts - 1) continue;
            tpc.proxy().updateAndFlush(userpass, testtable, mutations);
            mutations.clear();
        }
        String regex = ".*[02468]";
        IteratorSetting is = new IteratorSetting(50, regex, RegExFilter.class);
        RegExFilter.setRegexs((IteratorSetting)is, (String)regex, null, null, null, (boolean)false);
        org.apache.accumulo.proxy.thrift.IteratorSetting pis = Util.iteratorSetting2ProxyIteratorSetting((IteratorSetting)is);
        ScanOptions opts = new ScanOptions();
        opts.iterators = Collections.singletonList(pis);
        String cookie = tpc.proxy().createScanner(userpass, testtable, opts);
        int i = 0;
        boolean hasNext = true;
        int k = 1000;
        while (hasNext) {
            ScanResult kvList = tpc.proxy().nextK(cookie, k);
            for (KeyValue kv : kvList.getResults()) {
                Assert.assertEquals((long)Integer.parseInt(new String(kv.getKey().getRow())), (long)i);
                i += 2;
            }
            hasNext = kvList.isMore();
        }
    }

    public void manyWritesAndReads() throws Exception {
        int maxInserts = 1000000;
        HashMap<ByteBuffer, List<ColumnUpdate>> mutations = new HashMap<ByteBuffer, List<ColumnUpdate>>();
        String format = "%1$06d";
        String writer = tpc.proxy().createWriter(userpass, testtable, null);
        for (int i = 0; i < maxInserts; ++i) {
            TestProxyReadWrite.addMutation(mutations, String.format(format, i), "cf" + i, "cq" + i, Util.randString((int)10));
            if (i % 1000 != 0 && i != maxInserts - 1) continue;
            tpc.proxy().update(writer, mutations);
            mutations.clear();
        }
        tpc.proxy().flush(writer);
        tpc.proxy().closeWriter(writer);
        String cookie = tpc.proxy().createScanner(userpass, testtable, null);
        int i = 0;
        boolean hasNext = true;
        int k = 1000;
        while (hasNext) {
            ScanResult kvList = tpc.proxy().nextK(cookie, k);
            for (KeyValue kv : kvList.getResults()) {
                Assert.assertEquals((long)Integer.parseInt(new String(kv.getKey().getRow())), (long)i);
                ++i;
            }
            hasNext = kvList.isMore();
            if (!hasNext) continue;
            Assert.assertEquals((long)k, (long)kvList.getResults().size());
        }
        Assert.assertEquals((long)maxInserts, (long)i);
    }

    @Test
    public void asynchReadWrite() throws Exception {
        int maxInserts = 10000;
        HashMap<ByteBuffer, List<ColumnUpdate>> mutations = new HashMap<ByteBuffer, List<ColumnUpdate>>();
        String format = "%1$05d";
        String writer = tpc.proxy().createWriter(userpass, testtable, null);
        for (int i = 0; i < maxInserts; ++i) {
            TestProxyReadWrite.addMutation(mutations, String.format(format, i), "cf" + i, "cq" + i, Util.randString((int)10));
            if (i % 1000 != 0 && i != maxInserts - 1) continue;
            tpc.proxy().update(writer, mutations);
            mutations.clear();
        }
        tpc.proxy().flush(writer);
        tpc.proxy().closeWriter(writer);
        String regex = ".*[02468]";
        IteratorSetting is = new IteratorSetting(50, regex, RegExFilter.class);
        RegExFilter.setRegexs((IteratorSetting)is, (String)regex, null, null, null, (boolean)false);
        org.apache.accumulo.proxy.thrift.IteratorSetting pis = Util.iteratorSetting2ProxyIteratorSetting((IteratorSetting)is);
        ScanOptions opts = new ScanOptions();
        opts.iterators = Collections.singletonList(pis);
        String cookie = tpc.proxy().createScanner(userpass, testtable, opts);
        int i = 0;
        boolean hasNext = true;
        int k = 1000;
        int numRead = 0;
        while (hasNext) {
            ScanResult kvList = tpc.proxy().nextK(cookie, k);
            for (KeyValue kv : kvList.getResults()) {
                Assert.assertEquals((long)i, (long)Integer.parseInt(new String(kv.getKey().getRow())));
                ++numRead;
                i += 2;
            }
            hasNext = kvList.isMore();
        }
        Assert.assertEquals((long)(maxInserts / 2), (long)numRead);
    }

    @Test
    public void testVisibility() throws Exception {
        HashSet<ByteBuffer> auths = new HashSet<ByteBuffer>();
        auths.add(ByteBuffer.wrap("even".getBytes()));
        tpc.proxy().changeUserAuthorizations(userpass, "root", auths);
        int maxInserts = 10000;
        HashMap<ByteBuffer, List<ColumnUpdate>> mutations = new HashMap<ByteBuffer, List<ColumnUpdate>>();
        String format = "%1$05d";
        String writer = tpc.proxy().createWriter(userpass, testtable, null);
        for (int i = 0; i < maxInserts; ++i) {
            if (i % 2 == 0) {
                TestProxyReadWrite.addMutation(mutations, String.format(format, i), "cf" + i, "cq" + i, "even", Util.randString((int)10));
            } else {
                TestProxyReadWrite.addMutation(mutations, String.format(format, i), "cf" + i, "cq" + i, "odd", Util.randString((int)10));
            }
            if (i % 1000 != 0 && i != maxInserts - 1) continue;
            tpc.proxy().update(writer, mutations);
            mutations.clear();
        }
        tpc.proxy().flush(writer);
        tpc.proxy().closeWriter(writer);
        ScanOptions opts = new ScanOptions();
        opts.authorizations = auths;
        String cookie = tpc.proxy().createScanner(userpass, testtable, opts);
        int i = 0;
        boolean hasNext = true;
        int k = 1000;
        int numRead = 0;
        while (hasNext) {
            ScanResult kvList = tpc.proxy().nextK(cookie, k);
            for (KeyValue kv : kvList.getResults()) {
                Assert.assertEquals((long)Integer.parseInt(new String(kv.getKey().getRow())), (long)i);
                i += 2;
                ++numRead;
            }
            hasNext = kvList.isMore();
        }
        Assert.assertEquals((long)(maxInserts / 2), (long)numRead);
    }
}

