/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.test.functional.CacheTestClean;
import org.apache.accumulo.test.functional.CacheTestReader;
import org.apache.accumulo.test.functional.CacheTestWriter;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ZooCacheIT
extends ConfigurableMacBase {
    private static String pathName = "/zcTest-42";
    private static File testDir;

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @BeforeClass
    public static void createTestDirectory() {
        testDir = new File(ZooCacheIT.createTestDir(ZooCacheIT.class.getName()), pathName);
        FileUtils.deleteQuietly((File)testDir);
        Assert.assertTrue((boolean)testDir.mkdir());
    }

    @Test
    public void test() throws Exception {
        Assert.assertEquals((long)0L, (long)this.exec(CacheTestClean.class, pathName, testDir.getAbsolutePath()).waitFor());
        final AtomicReference ref = new AtomicReference();
        ArrayList<1> threads = new ArrayList<1>();
        for (int i = 0; i < 3; ++i) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        CacheTestReader.main(new String[]{pathName, testDir.getAbsolutePath(), ZooCacheIT.this.getConnector().getInstance().getZooKeepers()});
                    }
                    catch (Exception ex) {
                        ref.set(ex);
                    }
                }
            };
            thread.start();
            threads.add(thread);
        }
        Assert.assertEquals((long)0L, (long)this.exec(CacheTestWriter.class, pathName, testDir.getAbsolutePath(), "3", "50").waitFor());
        for (Thread thread : threads) {
            thread.join();
            if (ref.get() == null) continue;
            throw (Exception)ref.get();
        }
    }
}

