/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class SparseColumnFamilyIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void sparceColumnFamily() throws Exception {
        int i;
        String scftt = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        c.tableOperations().create(scftt);
        BatchWriter bw = c.createBatchWriter(scftt, new BatchWriterConfig());
        bw.addMutation(this.nm(0, 1, 0));
        for (i = 1; i < 99999; ++i) {
            bw.addMutation(this.nm(i * 2, 0, i));
        }
        bw.addMutation(this.nm(199998, 1, 99999));
        bw.flush();
        c.tableOperations().flush(scftt, null, null, true);
        for (i = 0; i < 100000; ++i) {
            bw.addMutation(this.nm(i * 2 + 1, i % 2 == 0 ? 0 : 1, i));
        }
        bw.close();
        c.tableOperations().flush(scftt, null, null, true);
        Scanner scanner = c.createScanner(scftt, Authorizations.EMPTY);
        for (int i2 = 0; i2 < 200; ++i2) {
            Map.Entry entry;
            scanner.setRange(new Range((CharSequence)String.format("%06d", i2), null));
            scanner.clearColumns();
            scanner.setBatchSize(3);
            scanner.fetchColumnFamily(new Text(String.format("%03d", 1)));
            Iterator iter = scanner.iterator();
            if (!iter.hasNext() || "001".equals(((Key)(entry = (Map.Entry)iter.next()).getKey()).getColumnFamilyData().toString())) continue;
            throw new Exception();
        }
    }

    private Mutation nm(int row, int cf, int val) {
        Mutation m = new Mutation((CharSequence)String.format("%06d", row));
        m.put((CharSequence)String.format("%03d", cf), (CharSequence)"", (CharSequence)("" + val));
        return m;
    }
}

