/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Combiner;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.BadCombiner;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class ServerSideErrorIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void run() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        IteratorSetting is = new IteratorSetting(5, "Bad Aggregator", BadCombiner.class);
        Combiner.setColumns((IteratorSetting)is, Collections.singletonList(new IteratorSetting.Column("acf")));
        c.tableOperations().attachIterator(tableName, is);
        BatchWriter bw = c.createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m = new Mutation(new Text("r1"));
        m.put(new Text("acf"), new Text("foo"), new Value(new byte[]{49}));
        bw.addMutation(m);
        bw.close();
        Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);
        boolean caught = false;
        try {
            for (Object entry : scanner) {
                entry.getKey();
            }
        }
        catch (Exception e) {
            caught = true;
        }
        if (!caught) {
            throw new Exception("Scan did not fail");
        }
        BatchScanner bs = c.createBatchScanner(tableName, Authorizations.EMPTY, 2);
        bs.setRanges(Collections.singleton(new Range()));
        caught = false;
        try {
            for (Object entry : bs) {
                entry.getKey();
            }
        }
        catch (Exception e) {
            caught = true;
        }
        finally {
            bs.close();
        }
        if (!caught) {
            throw new Exception("batch scan did not fail");
        }
        TableOperations to = c.tableOperations();
        for (Map.Entry e : to.getProperties(tableName)) {
            to.removeProperty(tableName, (String)e.getKey());
        }
        UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        scanner = c.createScanner(tableName, Authorizations.EMPTY);
        for (Map.Entry entry : scanner) {
            entry.getKey();
        }
        scanner.addScanIterator(new IteratorSetting(100, "bogus", "com.bogus.iterator"));
        caught = false;
        try {
            for (Map.Entry entry : scanner) {
                entry.getKey();
            }
        }
        catch (Exception e) {
            caught = true;
        }
        if (!caught) {
            throw new Exception("Scan did not fail");
        }
    }
}

