/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class ScannerContextIT
extends AccumuloClusterHarness {
    private static final String CONTEXT = ScannerContextIT.class.getSimpleName();
    private static final String CONTEXT_PROPERTY = Property.VFS_CONTEXT_CLASSPATH_PROPERTY + CONTEXT;
    private static final String CONTEXT_DIR = "file://" + System.getProperty("user.dir") + "/target";
    private static final String CONTEXT_CLASSPATH = CONTEXT_DIR + "/Test.jar";
    private static int ITERATIONS = 10;
    private static final long WAIT = 7000L;
    private FileSystem fs;

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Before
    public void checkCluster() throws Exception {
        Assume.assumeTrue((ScannerContextIT.getClusterType() == AccumuloClusterHarness.ClusterType.MINI ? 1 : 0) != 0);
        MiniAccumuloClusterImpl.class.cast(ScannerContextIT.getCluster());
        this.fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
    }

    private Path copyTestIteratorsJarToTmp() throws IOException {
        Path baseDir = new Path(System.getProperty("user.dir"));
        Path targetDir = new Path(baseDir, "target");
        Path jarPath = new Path(targetDir, "TestJar-Iterators.jar");
        Path dstPath = new Path(CONTEXT_DIR + "/Test.jar");
        this.fs.copyFromLocalFile(jarPath, dstPath);
        UtilWaitThread.sleep((long)7000L);
        return dstPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        Path dstPath = this.copyTestIteratorsJarToTmp();
        try {
            Connector c = this.getConnector();
            c.instanceOperations().setProperty(CONTEXT_PROPERTY, CONTEXT_CLASSPATH);
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            BatchWriter bw = c.createBatchWriter(tableName, new BatchWriterConfig());
            for (int i = 0; i < ITERATIONS; ++i) {
                Mutation m = new Mutation((CharSequence)("row" + i));
                m.put((CharSequence)"cf", (CharSequence)"col1", (CharSequence)"Test");
                bw.addMutation(m);
            }
            bw.close();
            this.scanCheck(c, tableName, null, null, "Test");
            this.batchCheck(c, tableName, null, null, "Test");
            IteratorSetting cfg = new IteratorSetting(21, "reverse", "org.apache.accumulo.test.functional.ValueReversingIterator");
            try {
                this.scanCheck(c, tableName, cfg, null, "tseT");
                Assert.fail((String)"This should have failed because context was not set");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.batchCheck(c, tableName, cfg, null, "tseT");
                Assert.fail((String)"This should have failed because context was not set");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.scanCheck(c, tableName, cfg, CONTEXT, "tseT");
            this.batchCheck(c, tableName, cfg, CONTEXT, "tseT");
        }
        finally {
            this.fs.delete(dstPath, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanContextOverridesTableContext() throws Exception {
        Path dstPath = this.copyTestIteratorsJarToTmp();
        try {
            Connector c = this.getConnector();
            String tableContext = "FOO";
            String tableContextProperty = Property.VFS_CONTEXT_CLASSPATH_PROPERTY + tableContext;
            String tableContextDir = "file://" + System.getProperty("user.dir") + "/target";
            String tableContextClasspath = tableContextDir + "/TestFoo.jar";
            c.instanceOperations().setProperty(tableContextProperty, tableContextClasspath);
            c.instanceOperations().setProperty(CONTEXT_PROPERTY, CONTEXT_CLASSPATH);
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            c.tableOperations().setProperty(tableName, Property.TABLE_CLASSPATH.getKey(), tableContext);
            BatchWriter bw = c.createBatchWriter(tableName, new BatchWriterConfig());
            for (int i = 0; i < ITERATIONS; ++i) {
                Mutation m = new Mutation((CharSequence)("row" + i));
                m.put((CharSequence)"cf", (CharSequence)"col1", (CharSequence)"Test");
                bw.addMutation(m);
            }
            bw.close();
            this.scanCheck(c, tableName, null, null, "Test");
            this.batchCheck(c, tableName, null, null, "Test");
            IteratorSetting cfg = new IteratorSetting(21, "reverse", "org.apache.accumulo.test.functional.ValueReversingIterator");
            try {
                this.scanCheck(c, tableName, cfg, null, "tseT");
                Assert.fail((String)"This should have failed because context was not set");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.batchCheck(c, tableName, cfg, null, "tseT");
                Assert.fail((String)"This should have failed because context was not set");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.scanCheck(c, tableName, cfg, CONTEXT, "tseT");
            this.batchCheck(c, tableName, cfg, CONTEXT, "tseT");
        }
        finally {
            this.fs.delete(dstPath, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneScannerDoesntInterfereWithAnother() throws Exception {
        Path dstPath = this.copyTestIteratorsJarToTmp();
        try {
            Connector c = this.getConnector();
            c.instanceOperations().setProperty(CONTEXT_PROPERTY, CONTEXT_CLASSPATH);
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            BatchWriter bw = c.createBatchWriter(tableName, new BatchWriterConfig());
            for (int i = 0; i < ITERATIONS; ++i) {
                Mutation m = new Mutation((CharSequence)("row" + i));
                m.put((CharSequence)"cf", (CharSequence)"col1", (CharSequence)"Test");
                bw.addMutation(m);
            }
            bw.close();
            Scanner one = c.createScanner(tableName, Authorizations.EMPTY);
            Scanner two = c.createScanner(tableName, Authorizations.EMPTY);
            IteratorSetting cfg = new IteratorSetting(21, "reverse", "org.apache.accumulo.test.functional.ValueReversingIterator");
            one.addScanIterator(cfg);
            one.setClassLoaderContext(CONTEXT);
            Iterator iterator = one.iterator();
            for (int i = 0; i < ITERATIONS; ++i) {
                Assert.assertTrue((boolean)iterator.hasNext());
                Map.Entry next = (Map.Entry)iterator.next();
                Assert.assertEquals((Object)"tseT", (Object)((Value)next.getValue()).toString());
            }
            Iterator iterator2 = two.iterator();
            for (int i = 0; i < ITERATIONS; ++i) {
                Assert.assertTrue((boolean)iterator2.hasNext());
                Map.Entry next = (Map.Entry)iterator2.next();
                Assert.assertEquals((Object)"Test", (Object)((Value)next.getValue()).toString());
            }
        }
        finally {
            this.fs.delete(dstPath, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClearContext() throws Exception {
        Path dstPath = this.copyTestIteratorsJarToTmp();
        try {
            Map.Entry next;
            int i;
            Connector c = this.getConnector();
            c.instanceOperations().setProperty(CONTEXT_PROPERTY, CONTEXT_CLASSPATH);
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            BatchWriter bw = c.createBatchWriter(tableName, new BatchWriterConfig());
            for (int i2 = 0; i2 < ITERATIONS; ++i2) {
                Mutation m = new Mutation((CharSequence)("row" + i2));
                m.put((CharSequence)"cf", (CharSequence)"col1", (CharSequence)"Test");
                bw.addMutation(m);
            }
            bw.close();
            Scanner one = c.createScanner(tableName, Authorizations.EMPTY);
            IteratorSetting cfg = new IteratorSetting(21, "reverse", "org.apache.accumulo.test.functional.ValueReversingIterator");
            one.addScanIterator(cfg);
            one.setClassLoaderContext(CONTEXT);
            Iterator iterator = one.iterator();
            for (i = 0; i < ITERATIONS; ++i) {
                Assert.assertTrue((boolean)iterator.hasNext());
                next = (Map.Entry)iterator.next();
                Assert.assertEquals((Object)"tseT", (Object)((Value)next.getValue()).toString());
            }
            one.removeScanIterator("reverse");
            one.clearClassLoaderContext();
            iterator = one.iterator();
            for (i = 0; i < ITERATIONS; ++i) {
                Assert.assertTrue((boolean)iterator.hasNext());
                next = (Map.Entry)iterator.next();
                Assert.assertEquals((Object)"Test", (Object)((Value)next.getValue()).toString());
            }
        }
        finally {
            this.fs.delete(dstPath, true);
        }
    }

    private void scanCheck(Connector c, String tableName, IteratorSetting cfg, String context, String expected) throws Exception {
        Scanner bs = c.createScanner(tableName, Authorizations.EMPTY);
        if (null != context) {
            bs.setClassLoaderContext(context);
        }
        if (null != cfg) {
            bs.addScanIterator(cfg);
        }
        Iterator iterator = bs.iterator();
        for (int i = 0; i < ITERATIONS; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Map.Entry next = (Map.Entry)iterator.next();
            Assert.assertEquals((Object)expected, (Object)((Value)next.getValue()).toString());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchCheck(Connector c, String tableName, IteratorSetting cfg, String context, String expected) throws Exception {
        bs.setRanges(Collections.singleton(new Range()));
        try (BatchScanner bs = c.createBatchScanner(tableName, Authorizations.EMPTY, 1);){
            if (null != context) {
                bs.setClassLoaderContext(context);
            }
            if (null != cfg) {
                bs.addScanIterator(cfg);
            }
            Iterator iterator = bs.iterator();
            for (int i = 0; i < ITERATIONS; ++i) {
                Assert.assertTrue((boolean)iterator.hasNext());
                Map.Entry next = (Map.Entry)iterator.next();
                Assert.assertEquals((Object)expected, (Object)((Value)next.getValue()).toString());
            }
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }
}

