/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.AdminUtil;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.fate.ZooStore;
import org.apache.accumulo.fate.zookeeper.IZooReader;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.server.zookeeper.ZooReaderWriterFactory;
import org.apache.accumulo.test.TestIngest;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;

public class FunctionalTestUtils {
    public static int countRFiles(Connector c, String tableName) throws Exception {
        Scanner scanner = c.createScanner("accumulo.metadata", Authorizations.EMPTY);
        String tableId = (String)c.tableOperations().tableIdMap().get(tableName);
        scanner.setRange(MetadataSchema.TabletsSection.getRange((String)tableId));
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        return Iterators.size((Iterator)scanner.iterator());
    }

    static void checkRFiles(Connector c, String tableName, int minTablets, int maxTablets, int minRFiles, int maxRFiles) throws Exception {
        Scanner scanner = c.createScanner("accumulo.metadata", Authorizations.EMPTY);
        String tableId = (String)c.tableOperations().tableIdMap().get(tableName);
        scanner.setRange(new Range(new Text(tableId + ";"), true, new Text(tableId + "<"), true));
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
        HashMap<Text, Integer> tabletFileCounts = new HashMap<Text, Integer>();
        for (Map.Entry entry : scanner) {
            Text row = ((Key)entry.getKey()).getRow();
            Integer count = (Integer)tabletFileCounts.get(row);
            if (count == null) {
                count = 0;
            }
            if (((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                count = count + 1;
            }
            tabletFileCounts.put(row, count);
        }
        if (tabletFileCounts.size() < minTablets || tabletFileCounts.size() > maxTablets) {
            throw new Exception("Did not find expected number of tablets " + tabletFileCounts.size());
        }
        Set es = tabletFileCounts.entrySet();
        for (Map.Entry entry : es) {
            if ((Integer)entry.getValue() <= maxRFiles && (Integer)entry.getValue() >= minRFiles) continue;
            throw new Exception("tablet " + entry.getKey() + " has " + entry.getValue() + " map files");
        }
    }

    public static void bulkImport(Connector c, FileSystem fs, String table, String dir) throws Exception {
        String failDir = dir + "_failures";
        Path failPath = new Path(failDir);
        fs.delete(failPath, true);
        fs.mkdirs(failPath);
        c.tableOperations().importDirectory(table, dir, failDir, false);
        if (fs.listStatus(failPath).length > 0) {
            throw new Exception("Some files failed to bulk import");
        }
    }

    public static void checkSplits(Connector c, String table, int min, int max) throws Exception {
        Collection splits = c.tableOperations().listSplits(table);
        if (splits.size() < min || splits.size() > max) {
            throw new Exception("# of table splits points out of range, #splits=" + splits.size() + " table=" + table + " min=" + min + " max=" + max);
        }
    }

    public static void createRFiles(final Connector c, final FileSystem fs, String path, int rows, int splits, int threads) throws Exception {
        fs.delete(new Path(path), true);
        ExecutorService threadPool = Executors.newFixedThreadPool(threads);
        final AtomicBoolean fail = new AtomicBoolean(false);
        for (int i = 0; i < rows; i += rows / splits) {
            final TestIngest.Opts opts = new TestIngest.Opts();
            opts.outputFile = String.format("%s/mf%s", path, i);
            opts.random = 56;
            opts.timestamp = 1L;
            opts.dataSize = 50;
            opts.rows = rows / splits;
            opts.startRow = i;
            opts.cols = 1;
            threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        TestIngest.ingest(c, fs, opts, new BatchWriterOpts());
                    }
                    catch (Exception e) {
                        fail.set(true);
                    }
                }
            });
        }
        threadPool.shutdown();
        threadPool.awaitTermination(1L, TimeUnit.HOURS);
        Assert.assertFalse((boolean)fail.get());
    }

    public static String readAll(InputStream is) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        StringBuilder result = new StringBuilder();
        while ((n = is.read(buffer)) > 0) {
            result.append(new String(buffer, 0, n));
        }
        return result.toString();
    }

    public static String readAll(MiniAccumuloClusterImpl c, Class<?> klass, Process p) throws Exception {
        for (MiniAccumuloClusterImpl.LogWriter writer : c.getLogWriters()) {
            writer.flush();
        }
        return FunctionalTestUtils.readAll(new FileInputStream(c.getConfig().getLogDir() + "/" + klass.getSimpleName() + "_" + p.hashCode() + ".out"));
    }

    static Mutation nm(String row, String cf, String cq, Value value) {
        Mutation m = new Mutation(new Text(row));
        m.put(new Text(cf), new Text(cq), value);
        return m;
    }

    static Mutation nm(String row, String cf, String cq, String value) {
        return FunctionalTestUtils.nm(row, cf, cq, new Value(value.getBytes()));
    }

    public static SortedSet<Text> splits(String[] splits) {
        TreeSet<Text> result = new TreeSet<Text>();
        for (String split : splits) {
            result.add(new Text(split));
        }
        return result;
    }

    public static void assertNoDanglingFateLocks(Instance instance, AccumuloCluster cluster) {
        AdminUtil.FateStatus fateStatus = FunctionalTestUtils.getFateStatus(instance, cluster);
        Assert.assertEquals((String)("Dangling FATE locks : " + fateStatus.getDanglingHeldLocks()), (long)0L, (long)fateStatus.getDanglingHeldLocks().size());
        Assert.assertEquals((String)("Dangling FATE locks : " + fateStatus.getDanglingWaitingLocks()), (long)0L, (long)fateStatus.getDanglingWaitingLocks().size());
    }

    private static AdminUtil.FateStatus getFateStatus(Instance instance, AccumuloCluster cluster) {
        try {
            AdminUtil admin = new AdminUtil(false);
            String secret = cluster.getSiteConfiguration().get(Property.INSTANCE_SECRET);
            IZooReaderWriter zk = new ZooReaderWriterFactory().getZooReaderWriter(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut(), secret);
            ZooStore zs = new ZooStore(ZooUtil.getRoot((Instance)instance) + "/fate", zk);
            AdminUtil.FateStatus fateStatus = admin.getStatus((ReadOnlyTStore)zs, (IZooReader)zk, ZooUtil.getRoot((Instance)instance) + "/table_locks", null, null);
            return fateStatus;
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException(e);
        }
    }
}

