/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteRowsSplitIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(DeleteRowsSplitIT.class);
    private static final String LETTERS = "abcdefghijklmnopqrstuvwxyz";
    static final SortedSet<Text> SPLITS = new TreeSet<Text>();
    static final List<String> ROWS = new ArrayList<String>();

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Test
    public void run() throws Exception {
        final String tableName = this.getUniqueNames(1)[0];
        final Connector conn = this.getConnector();
        int test = 0;
        while (test < 10) {
            log.info("Test " + test);
            conn.tableOperations().create(tableName);
            this.fillTable(conn, tableName);
            Text start = new Text();
            final Text end = new Text();
            this.generateRandomRange(start, end);
            final boolean[] fail = new boolean[]{false};
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    try {
                        SortedSet<Text> afterEnd = SPLITS.tailSet(new Text(end.toString() + "\u0000"));
                        conn.tableOperations().addSplits(tableName, afterEnd);
                        return;
                    }
                    catch (Exception ex) {
                        log.error("Exception", (Throwable)ex);
                        boolean[] blArray = fail;
                        synchronized (fail) {
                            fail[0] = true;
                            // ** MonitorExit[var2_3] (shouldn't be in output)
                            return;
                        }
                    }
                }
            };
            t.start();
            UtilWaitThread.sleepUninterruptibly((long)(test * 2), (TimeUnit)TimeUnit.MILLISECONDS);
            conn.tableOperations().deleteRows(tableName, start, end);
            t.join();
            boolean[] blArray = fail;
            // MONITORENTER : fail
            Assert.assertTrue((!fail[0] ? 1 : 0) != 0);
            // MONITOREXIT : blArray
            Scanner scanner = conn.createScanner(tableName, Authorizations.EMPTY);
            for (Map.Entry entry : scanner) {
                Text row = ((Key)entry.getKey()).getRow();
                Assert.assertTrue((row.compareTo((BinaryComparable)start) <= 0 || row.compareTo((BinaryComparable)end) > 0 ? 1 : 0) != 0);
            }
            conn.tableOperations().delete(tableName);
            ++test;
        }
    }

    private void generateRandomRange(Text start, Text end) {
        ArrayList<String> bunch = new ArrayList<String>(ROWS);
        Collections.shuffle(bunch);
        if (((String)bunch.get(0)).compareTo((String)bunch.get(1)) < 0) {
            start.set((String)bunch.get(0));
            end.set((String)bunch.get(1));
        } else {
            start.set((String)bunch.get(1));
            end.set((String)bunch.get(0));
        }
    }

    private void fillTable(Connector conn, String table) throws Exception {
        BatchWriter bw = conn.createBatchWriter(table, new BatchWriterConfig());
        for (String row : ROWS) {
            Mutation m = new Mutation((CharSequence)row);
            m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
            bw.addMutation(m);
        }
        bw.close();
    }

    static {
        for (byte b : LETTERS.getBytes(StandardCharsets.UTF_8)) {
            SPLITS.add(new Text(new byte[]{b}));
            ROWS.add(new String(new byte[]{b}, StandardCharsets.UTF_8));
        }
    }
}

