/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurableCompactionIT
extends ConfigurableMacBase {
    static final Random r = new Random();

    @Override
    public int defaultTimeoutSeconds() {
        return 120;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setSiteConfig(Collections.singletonMap(Property.TSERV_MAJC_DELAY.getKey(), "1s"));
    }

    @Test
    public void test() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_COMPACTION_STRATEGY.getKey(), SimpleCompactionStrategy.class.getName());
        this.runTest(c, tableName, 3);
        c.tableOperations().setProperty(tableName, Property.TABLE_COMPACTION_STRATEGY_PREFIX.getKey() + "count", "5");
        this.runTest(c, tableName, 5);
    }

    @Test
    public void testPerTableClasspath() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        File destFile = ConfigurableCompactionIT.installJar(this.getCluster().getConfig().getAccumuloDir(), "/TestCompactionStrat.jar");
        c.tableOperations().create(tableName);
        c.instanceOperations().setProperty(Property.VFS_CONTEXT_CLASSPATH_PROPERTY.getKey() + "context1", destFile.toString());
        c.tableOperations().setProperty(tableName, Property.TABLE_MAJC_RATIO.getKey(), "10");
        c.tableOperations().setProperty(tableName, Property.TABLE_CLASSPATH.getKey(), "context1");
        c.tableOperations().setProperty(tableName, Property.TABLE_COMPACTION_STRATEGY.getKey(), "org.apache.accumulo.test.EfgCompactionStrat");
        c.tableOperations().addSplits(tableName, new TreeSet<Text>(Arrays.asList(new Text("efg"))));
        for (char ch = 'a'; ch < 'l'; ch = (char)(ch + '\u0001')) {
            this.writeFlush(c, tableName, ch + "");
        }
        while (this.countFiles(c, tableName) != 7) {
            UtilWaitThread.sleep((long)200L);
        }
    }

    private static File installJar(File destDir, String jarFile) throws IOException {
        File destName = new File(destDir, new File(jarFile).getName());
        FileUtils.copyInputStreamToFile((InputStream)ConfigurableCompactionIT.class.getResourceAsStream(jarFile), (File)destName);
        return destName;
    }

    private void writeFlush(Connector conn, String tablename, String row) throws Exception {
        BatchWriter bw = conn.createBatchWriter(tablename, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)row);
        m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
        bw.addMutation(m);
        bw.close();
        conn.tableOperations().flush(tablename, null, null, true);
    }

    private void makeFile(Connector conn, String tablename) throws Exception {
        BatchWriter bw = conn.createBatchWriter(tablename, new BatchWriterConfig());
        byte[] empty = new byte[]{};
        byte[] row = new byte[10];
        r.nextBytes(row);
        Mutation m = new Mutation(row, 0, 10);
        m.put(empty, empty, empty);
        bw.addMutation(m);
        bw.flush();
        bw.close();
        conn.tableOperations().flush(tablename, null, null, true);
    }

    private void runTest(Connector c, String tableName, int n) throws Exception {
        int i;
        for (i = this.countFiles(c, tableName); i < n - 1; ++i) {
            this.makeFile(c, tableName);
        }
        Assert.assertEquals((long)(n - 1), (long)this.countFiles(c, tableName));
        this.makeFile(c, tableName);
        for (i = 0; i < 10; ++i) {
            int count = this.countFiles(c, tableName);
            Assert.assertTrue((count == 1 || count == n ? 1 : 0) != 0);
            if (count == 1) break;
            UtilWaitThread.sleep((long)1000L);
        }
    }

    private int countFiles(Connector c, String tableName) throws Exception {
        Scanner s = c.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        return Iterators.size((Iterator)s.iterator());
    }

    public static class SimpleCompactionStrategy
    extends CompactionStrategy {
        int count = 3;

        public void init(Map<String, String> options) {
            String countString = options.get("count");
            if (countString != null) {
                this.count = Integer.parseInt(countString);
            }
        }

        public boolean shouldCompact(MajorCompactionRequest request) throws IOException {
            return request.getFiles().size() == this.count;
        }

        public CompactionPlan getCompactionPlan(MajorCompactionRequest request) throws IOException {
            CompactionPlan result = new CompactionPlan();
            result.inputFiles.addAll(request.getFiles().keySet());
            return result;
        }
    }
}

