/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalanceInPresenceOfOfflineTableIT
extends AccumuloClusterHarness {
    private static Logger log = LoggerFactory.getLogger(BalanceInPresenceOfOfflineTableIT.class);
    private static final int NUM_SPLITS = 200;
    private String UNUSED_TABLE;
    private String TEST_TABLE;
    private Connector connector;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_MAXMEM.getKey(), "10K");
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "0");
        cfg.setSiteConfig(siteConfig);
        if (cfg.getNumTservers() < 2) {
            cfg.setNumTservers(2);
        }
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 600;
    }

    @Before
    public void setupTables() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException {
        Connector conn = this.getConnector();
        Assume.assumeTrue((String)"Not enough tservers to run test", (conn.instanceOperations().getTabletServers().size() >= 2 ? 1 : 0) != 0);
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 0; i < 200; ++i) {
            splits.add(new Text(String.format("%08x", i * 1000)));
        }
        String[] names = this.getUniqueNames(2);
        this.UNUSED_TABLE = names[0];
        this.TEST_TABLE = names[1];
        this.connector = this.getConnector();
        this.connector.tableOperations().create(this.UNUSED_TABLE);
        this.connector.tableOperations().addSplits(this.UNUSED_TABLE, splits);
        this.connector.tableOperations().offline(this.UNUSED_TABLE);
        this.connector.tableOperations().create(this.TEST_TABLE);
        this.connector.tableOperations().setProperty(this.TEST_TABLE, Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void test() throws Exception {
        log.info("Test that balancing is not stopped by an offline table with outstanding migrations.");
        log.debug("starting test ingestion");
        TestIngest.Opts opts = new TestIngest.Opts();
        VerifyIngest.Opts vopts = new VerifyIngest.Opts();
        ClientConfiguration conf = cluster.getClientConfig();
        if (conf.hasSasl()) {
            opts.updateKerberosCredentials(cluster.getClientConfig());
            vopts.updateKerberosCredentials(cluster.getClientConfig());
        } else {
            opts.setPrincipal("root");
            vopts.setPrincipal("root");
        }
        opts.rows = 200000;
        vopts.rows = 200000;
        opts.setTableName(this.TEST_TABLE);
        TestIngest.ingest(this.connector, opts, new BatchWriterOpts());
        this.connector.tableOperations().flush(this.TEST_TABLE, null, null, true);
        vopts.setTableName(this.TEST_TABLE);
        VerifyIngest.verifyIngest(this.connector, vopts, new ScannerOpts());
        log.debug("waiting for balancing, up to ~5 minutes to allow for migration cleanup.");
        long startTime = System.currentTimeMillis();
        long currentWait = 10000L;
        boolean balancingWorked = false;
        Credentials creds = new Credentials(BalanceInPresenceOfOfflineTableIT.getAdminPrincipal(), BalanceInPresenceOfOfflineTableIT.getAdminToken());
        while (!balancingWorked && System.currentTimeMillis() - startTime < 315000L) {
            MasterMonitorInfo stats;
            block15: {
                Thread.sleep(currentWait);
                currentWait *= 2L;
                log.debug("fetch the list of tablets assigned to each tserver.");
                MasterClientService.Client client = null;
                stats = null;
                try {
                    ZooKeeperInstance instance = new ZooKeeperInstance(cluster.getClientConfig());
                    client = MasterClient.getConnectionWithRetry((ClientContext)new ClientContext((Instance)instance, creds, cluster.getClientConfig()));
                    stats = client.getMasterStats(Tracer.traceInfo(), creds.toThrift((Instance)instance));
                    if (client == null) break block15;
                }
                catch (ThriftSecurityException exception) {
                    try {
                        throw new AccumuloSecurityException(exception);
                        catch (TException exception2) {
                            throw new AccumuloException((Throwable)exception2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (client != null) {
                            MasterClient.close(client);
                        }
                        throw throwable;
                    }
                }
                MasterClient.close((MasterClientService.Iface)client);
            }
            if (stats.getTServerInfoSize() < 2) {
                log.debug("we need >= 2 servers. sleeping for " + currentWait + "ms");
                continue;
            }
            if (stats.getUnassignedTablets() != 0) {
                log.debug("We shouldn't have unassigned tablets. sleeping for " + currentWait + "ms");
                continue;
            }
            long[] tabletsPerServer = new long[stats.getTServerInfoSize()];
            Arrays.fill(tabletsPerServer, 0L);
            for (int i = 0; i < stats.getTServerInfoSize(); ++i) {
                for (Map.Entry entry : ((TabletServerStatus)stats.getTServerInfo().get(i)).getTableMap().entrySet()) {
                    int n = i;
                    tabletsPerServer[n] = tabletsPerServer[n] + (long)((TableInfo)entry.getValue()).getTablets();
                }
            }
            if (tabletsPerServer[0] <= 10L) {
                log.debug("We should have > 10 tablets. sleeping for " + currentWait + "ms");
                continue;
            }
            long min = NumberUtils.min((long[])tabletsPerServer);
            long max = NumberUtils.max((long[])tabletsPerServer);
            log.debug("Min=" + min + ", Max=" + max);
            if ((double)min / (double)max < 0.5) {
                log.debug("ratio of min to max tablets per server should be roughly even. sleeping for " + currentWait + "ms");
                continue;
            }
            balancingWorked = true;
        }
        Assert.assertTrue((String)"did not properly balance", (boolean)balancingWorked);
    }
}

