/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import com.beust.jcommander.Parameter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.cli.BatchScannerOpts;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.server.cli.ClientOnDefaultTable;
import org.apache.hadoop.io.Text;

public class UndefinedAnalyzer {
    public static void main(String[] args) throws Exception {
        String line;
        Opts opts = new Opts();
        BatchScannerOpts bsOpts = new BatchScannerOpts();
        opts.parseArgs(UndefinedAnalyzer.class.getName(), args, new Object[]{bsOpts});
        ArrayList<UndefinedNode> undefs = new ArrayList<UndefinedNode>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            String[] tokens = line.split("\\s");
            String undef = tokens[0];
            String ref = tokens[1];
            undefs.add(new UndefinedNode(undef, ref));
        }
        Connector conn = opts.getConnector();
        BatchScanner bscanner = conn.createBatchScanner(opts.getTableName(), opts.auths, bsOpts.scanThreads.intValue());
        bscanner.setTimeout(bsOpts.scanTimeout.longValue(), TimeUnit.MILLISECONDS);
        ArrayList<Range> refs = new ArrayList<Range>();
        for (UndefinedNode undefinedNode : undefs) {
            refs.add(new Range(new Text(undefinedNode.ref)));
        }
        bscanner.setRanges(refs);
        HashMap<String, ArrayList<String>> refInfo = new HashMap<String, ArrayList<String>>();
        for (Map.Entry entry : bscanner) {
            String ref = ((Key)entry.getKey()).getRow().toString();
            ArrayList<String> vals = (ArrayList<String>)refInfo.get(ref);
            if (vals == null) {
                vals = new ArrayList<String>();
                refInfo.put(ref, vals);
            }
            vals.add(((Value)entry.getValue()).toString());
        }
        bscanner.close();
        IngestInfo ingestInfo = new IngestInfo(opts.logDir);
        TabletHistory tabletHistory = new TabletHistory(Tables.getTableId((Instance)conn.getInstance(), (String)opts.getTableName()), opts.logDir);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        for (UndefinedNode undefinedNode : undefs) {
            List refVals = (List)refInfo.get(undefinedNode.ref);
            if (refVals != null) {
                for (String refVal : refVals) {
                    TabletAssignment ta = null;
                    String[] tokens = refVal.split(":");
                    String uuid = tokens[0];
                    String count = tokens[1];
                    String t1 = "";
                    String t2 = "";
                    Iterator<Long> times = ingestInfo.getTimes(uuid, Long.parseLong(count, 16));
                    if (times != null && times.hasNext()) {
                        long time2 = times.next();
                        t2 = sdf.format(new Date(time2));
                        if (times.hasNext()) {
                            long time1 = times.next();
                            t1 = sdf.format(new Date(time1));
                            ta = tabletHistory.findMostRecentAssignment(undefinedNode.undef, time1, time2);
                        }
                    }
                    if (ta == null) {
                        System.out.println(undefinedNode.undef + " " + undefinedNode.ref + " " + uuid + " " + t1 + " " + t2);
                        continue;
                    }
                    System.out.println(undefinedNode.undef + " " + undefinedNode.ref + " " + ta.tablet + " " + ta.server + " " + uuid + " " + t1 + " " + t2);
                }
                continue;
            }
            System.out.println(undefinedNode.undef + " " + undefinedNode.ref);
        }
    }

    static class Opts
    extends ClientOnDefaultTable {
        @Parameter(names={"--logdir"}, description="directory containing the log files", required=true)
        String logDir;

        Opts() {
            super("ci");
        }
    }

    static class TabletHistory {
        List<TabletAssignment> assignments = new ArrayList<TabletAssignment>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TabletHistory(String tableId, String acuLogDir) throws Exception {
            File dir = new File(acuLogDir);
            File[] masterLogs = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches("master.*debug.log.*");
                }
            });
            SimpleDateFormat sdf = new SimpleDateFormat("dd HH:mm:ss,SSS yyyy MM");
            String currentYear = Calendar.getInstance().get(1) + "";
            String currentMonth = Calendar.getInstance().get(2) + 1 + "";
            if (masterLogs != null) {
                for (File masterLog : masterLogs) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(masterLog), StandardCharsets.UTF_8));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (!line.contains("TABLET_LOADED")) continue;
                            String[] tokens = line.split("\\s+");
                            String tablet = tokens[8];
                            String server = tokens[10];
                            int pos1 = -1;
                            int pos2 = -1;
                            int pos3 = -1;
                            for (int i = 0; i < tablet.length(); ++i) {
                                if (tablet.charAt(i) != '<' && tablet.charAt(i) != ';') continue;
                                if (pos1 == -1) {
                                    pos1 = i;
                                    continue;
                                }
                                if (pos2 == -1) {
                                    pos2 = i;
                                    continue;
                                }
                                pos3 = i;
                            }
                            if (pos1 > 0 && pos2 > 0 && pos3 == -1) {
                                String prevEndRow;
                                String tid = tablet.substring(0, pos1);
                                String endRow = tablet.charAt(pos1) == '<' ? "8000000000000000" : tablet.substring(pos1 + 1, pos2);
                                String string = prevEndRow = tablet.charAt(pos2) == '<' ? "" : tablet.substring(pos2 + 1);
                                if (!tid.equals(tableId)) continue;
                                Date date = sdf.parse(tokens[0] + " " + tokens[1] + " " + currentYear + " " + currentMonth);
                                this.assignments.add(new TabletAssignment(tablet, endRow, prevEndRow, server, date.getTime()));
                                continue;
                            }
                            if (tablet.startsWith("!0")) continue;
                            System.err.println("Cannot parse tablet " + tablet);
                        }
                    }
                }
            }
        }

        TabletAssignment findMostRecentAssignment(String row, long time1, long time2) {
            long latest = Long.MIN_VALUE;
            TabletAssignment ret = null;
            for (TabletAssignment assignment : this.assignments) {
                if (!assignment.contains(row) || assignment.time > time2 || assignment.time <= latest) continue;
                latest = assignment.time;
                ret = assignment;
            }
            return ret;
        }
    }

    static class TabletAssignment {
        String tablet;
        String endRow;
        String prevEndRow;
        String server;
        long time;

        TabletAssignment(String tablet, String er, String per, String server, long time) {
            this.tablet = tablet;
            this.endRow = er;
            this.prevEndRow = per;
            this.server = server;
            this.time = time;
        }

        public boolean contains(String row) {
            return this.prevEndRow.compareTo(row) < 0 && this.endRow.compareTo(row) >= 0;
        }
    }

    static class IngestInfo {
        Map<String, TreeMap<Long, Long>> flushes = new HashMap<String, TreeMap<Long, Long>>();

        public IngestInfo(String logDir) throws Exception {
            File dir = new File(logDir);
            File[] ingestLogs = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("ingest.out");
                }
            });
            if (ingestLogs != null) {
                for (File log : ingestLogs) {
                    this.parseLog(log);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseLog(File log) throws Exception {
            TreeMap tm = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(log), StandardCharsets.UTF_8));){
                String time;
                String[] tokens;
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("UUID")) continue;
                    tokens = line.split("\\s");
                    time = tokens[1];
                    String uuid = tokens[2];
                    if (this.flushes.containsKey(uuid)) {
                        System.err.println("WARN Duplicate uuid " + log);
                        return;
                    }
                    tm = new TreeMap(Collections.reverseOrder());
                    tm.put(0L, Long.parseLong(time));
                    this.flushes.put(uuid, tm);
                    break;
                }
                if (tm == null) {
                    System.err.println("WARN Bad ingest log " + log);
                    return;
                }
                while ((line = reader.readLine()) != null) {
                    tokens = line.split("\\s");
                    if (!tokens[0].equals("FLUSH")) continue;
                    time = tokens[1];
                    String count = tokens[4];
                    tm.put(Long.parseLong(count), Long.parseLong(time));
                }
            }
        }

        Iterator<Long> getTimes(String uuid, long count) {
            TreeMap<Long, Long> tm = this.flushes.get(uuid);
            if (tm == null) {
                return null;
            }
            return tm.tailMap(count).values().iterator();
        }
    }

    static class UndefinedNode {
        String undef;
        String ref;

        public UndefinedNode(String undef2, String ref2) {
            this.undef = undef2;
            this.ref = ref2;
        }
    }
}

