/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.fs.PerTableVolumeChooser;
import org.apache.accumulo.server.fs.PreferredVolumeChooser;
import org.apache.accumulo.server.fs.RandomVolumeChooser;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class VolumeChooserIT
extends ConfigurableMacBase {
    private static final Text EMPTY = new Text();
    private static final Value EMPTY_VALUE = new Value(new byte[0]);
    private File volDirBase;
    private Path v1;
    private Path v2;
    private Path v3;
    private Path v4;
    private String[] rows = "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z".split(",");
    private String namespace1;
    private String namespace2;

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(2);
        this.namespace1 = "ns_" + this.getUniqueNames(2)[0];
        this.namespace2 = "ns_" + this.getUniqueNames(2)[1];
        HashMap<String, String> siteConfig = new HashMap<String, String>();
        siteConfig.put(Property.GENERAL_VOLUME_CHOOSER.getKey(), PerTableVolumeChooser.class.getName());
        cfg.setSiteConfig(siteConfig);
        File baseDir = cfg.getDir();
        this.volDirBase = new File(baseDir, "volumes");
        File v1f = new File(this.volDirBase, "v1");
        File v2f = new File(this.volDirBase, "v2");
        File v3f = new File(this.volDirBase, "v3");
        File v4f = new File(this.volDirBase, "v4");
        this.v1 = new Path("file://" + v1f.getAbsolutePath());
        this.v2 = new Path("file://" + v2f.getAbsolutePath());
        this.v3 = new Path("file://" + v3f.getAbsolutePath());
        this.v4 = new Path("file://" + v4f.getAbsolutePath());
        cfg.setProperty(Property.INSTANCE_VOLUMES, this.v1.toString() + "," + this.v2.toString() + "," + this.v4.toString());
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        super.configure(cfg, hadoopCoreSite);
    }

    public void addSplits(Connector connector, String tableName) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        TreeSet<Text> partitions = new TreeSet<Text>();
        for (String s : "b,e,g,j,l,o,q,t,v,y".split(",")) {
            partitions.add(new Text(s));
        }
        connector.tableOperations().addSplits(tableName, partitions);
    }

    public void writeAndReadData(Connector connector, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        BatchWriter bw = connector.createBatchWriter(tableName, new BatchWriterConfig());
        for (String s : this.rows) {
            Mutation m = new Mutation(new Text(s));
            m.put(EMPTY, EMPTY, EMPTY_VALUE);
            bw.addMutation(m);
        }
        bw.close();
        connector.tableOperations().flush(tableName, null, null, true);
        Scanner scanner = connector.createScanner(tableName, Authorizations.EMPTY);
        int i = 0;
        for (Map.Entry entry : scanner) {
            Assert.assertEquals((String)"Data read is not data written", (Object)this.rows[i++], (Object)((Key)entry.getKey()).getRow().toString());
        }
    }

    public void verifyVolumes(Connector connector, String tableName, Range tableRange, String vol) throws TableNotFoundException {
        ArrayList<String> volumes = new ArrayList<String>();
        for (String s : vol.split(",")) {
            volumes.add(s);
        }
        Scanner scanner = connector.createScanner("accumulo.metadata", Authorizations.EMPTY);
        scanner.setRange(tableRange);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        int fileCount = 0;
        for (Map.Entry entry : scanner) {
            boolean inVolume = false;
            for (String volume : volumes) {
                if (!((Key)entry.getKey()).getColumnQualifier().toString().contains(volume)) continue;
                inVolume = true;
            }
            Assert.assertTrue((String)"Data not written to the correct volumes", (boolean)inVolume);
            ++fileCount;
        }
        Assert.assertEquals((String)"Wrong number of files", (long)11L, (long)fileCount);
    }

    @Test
    public void twoTablesPreferredVolumeChooser() throws Exception {
        log.info("Starting twoTablesPreferredVolumeChooser");
        Connector connector = this.getConnector();
        connector.namespaceOperations().create(this.namespace1);
        String propertyName = Property.TABLE_VOLUME_CHOOSER.getKey();
        String volume = PreferredVolumeChooser.class.getName();
        connector.namespaceOperations().setProperty(this.namespace1, propertyName, volume);
        propertyName = "table.custom.preferredVolumes";
        volume = this.v2.toString();
        connector.namespaceOperations().setProperty(this.namespace1, propertyName, volume);
        String tableName = this.namespace1 + ".1";
        connector.tableOperations().create(tableName);
        String tableID = (String)connector.tableOperations().tableIdMap().get(tableName);
        this.addSplits(connector, tableName);
        this.writeAndReadData(connector, tableName);
        this.verifyVolumes(connector, tableName, MetadataSchema.TabletsSection.getRange((String)tableID), volume);
        connector.namespaceOperations().create(this.namespace2);
        propertyName = Property.TABLE_VOLUME_CHOOSER.getKey();
        volume = PreferredVolumeChooser.class.getName();
        connector.namespaceOperations().setProperty(this.namespace2, propertyName, volume);
        propertyName = "table.custom.preferredVolumes";
        volume = this.v1.toString();
        connector.namespaceOperations().setProperty(this.namespace2, propertyName, volume);
        String tableName2 = this.namespace2 + ".1";
        connector.tableOperations().create(tableName2);
        String tableID2 = (String)connector.tableOperations().tableIdMap().get(tableName2);
        this.addSplits(connector, tableName2);
        this.writeAndReadData(connector, tableName2);
        this.verifyVolumes(connector, tableName2, MetadataSchema.TabletsSection.getRange((String)tableID2), volume);
    }

    @Test
    public void twoTablesRandomVolumeChooser() throws Exception {
        log.info("Starting twoTablesRandomVolumeChooser()");
        Connector connector = this.getConnector();
        connector.namespaceOperations().create(this.namespace1);
        String propertyName = Property.TABLE_VOLUME_CHOOSER.getKey();
        String volume = RandomVolumeChooser.class.getName();
        connector.namespaceOperations().setProperty(this.namespace1, propertyName, volume);
        String tableName = this.namespace1 + ".1";
        connector.tableOperations().create(tableName);
        String tableID = (String)connector.tableOperations().tableIdMap().get(tableName);
        this.addSplits(connector, tableName);
        this.writeAndReadData(connector, tableName);
        this.verifyVolumes(connector, tableName, MetadataSchema.TabletsSection.getRange((String)tableID), this.v1.toString() + "," + this.v2.toString() + "," + this.v4.toString());
        connector.namespaceOperations().create(this.namespace2);
        propertyName = Property.TABLE_VOLUME_CHOOSER.getKey();
        volume = RandomVolumeChooser.class.getName();
        connector.namespaceOperations().setProperty(this.namespace2, propertyName, volume);
        String tableName2 = this.namespace2 + ".1";
        connector.tableOperations().create(tableName2);
        String tableID2 = (String)connector.tableOperations().tableIdMap().get(tableName);
        this.addSplits(connector, tableName2);
        this.writeAndReadData(connector, tableName2);
        this.verifyVolumes(connector, tableName2, MetadataSchema.TabletsSection.getRange((String)tableID2), this.v1.toString() + "," + this.v2.toString() + "," + this.v4.toString());
    }

    @Test
    public void twoTablesDiffChoosers() throws Exception {
        log.info("Starting twoTablesDiffChoosers");
        Connector connector = this.getConnector();
        connector.namespaceOperations().create(this.namespace1);
        String propertyName = Property.TABLE_VOLUME_CHOOSER.getKey();
        String volume = RandomVolumeChooser.class.getName();
        connector.namespaceOperations().setProperty(this.namespace1, propertyName, volume);
        String tableName = this.namespace1 + ".1";
        connector.tableOperations().create(tableName);
        String tableID = (String)connector.tableOperations().tableIdMap().get(tableName);
        this.addSplits(connector, tableName);
        this.writeAndReadData(connector, tableName);
        this.verifyVolumes(connector, tableName, MetadataSchema.TabletsSection.getRange((String)tableID), this.v1.toString() + "," + this.v2.toString() + "," + this.v4.toString());
        connector.namespaceOperations().create(this.namespace2);
        propertyName = Property.TABLE_VOLUME_CHOOSER.getKey();
        volume = PreferredVolumeChooser.class.getName();
        connector.namespaceOperations().setProperty(this.namespace2, propertyName, volume);
        propertyName = "table.custom.preferredVolumes";
        volume = this.v1.toString();
        connector.namespaceOperations().setProperty(this.namespace2, propertyName, volume);
        String tableName2 = this.namespace2 + ".1";
        connector.tableOperations().create(tableName2);
        String tableID2 = (String)connector.tableOperations().tableIdMap().get(tableName2);
        this.addSplits(connector, tableName2);
        this.writeAndReadData(connector, tableName2);
        this.verifyVolumes(connector, tableName2, MetadataSchema.TabletsSection.getRange((String)tableID2), volume);
    }

    @Test
    public void missingVolumePreferredVolumeChooser() throws Exception {
        log.info("Starting missingVolumePreferredVolumeChooser");
        Connector connector = this.getConnector();
        connector.namespaceOperations().create(this.namespace1);
        String propertyName = Property.TABLE_VOLUME_CHOOSER.getKey();
        String volume = PreferredVolumeChooser.class.getName();
        connector.namespaceOperations().setProperty(this.namespace1, propertyName, volume);
        String tableName = this.namespace1 + ".1";
        connector.tableOperations().create(tableName);
        String tableID = (String)connector.tableOperations().tableIdMap().get(tableName);
        this.addSplits(connector, tableName);
        this.writeAndReadData(connector, tableName);
        this.verifyVolumes(connector, tableName, MetadataSchema.TabletsSection.getRange((String)tableID), this.v1.toString() + "," + this.v2.toString() + "," + this.v4.toString());
    }

    @Test
    public void notInstancePreferredVolumeChooser() throws Exception {
        log.info("Starting notInstancePreferredVolumeChooser");
        Connector connector = this.getConnector();
        connector.namespaceOperations().create(this.namespace1);
        String propertyName = Property.TABLE_VOLUME_CHOOSER.getKey();
        String volume = PreferredVolumeChooser.class.getName();
        connector.namespaceOperations().setProperty(this.namespace1, propertyName, volume);
        propertyName = "table.custom.preferredVolumes";
        volume = this.v3.toString();
        connector.namespaceOperations().setProperty(this.namespace1, propertyName, volume);
        String tableName = this.namespace1 + ".1";
        connector.tableOperations().create(tableName);
        String tableID = (String)connector.tableOperations().tableIdMap().get(tableName);
        this.addSplits(connector, tableName);
        this.writeAndReadData(connector, tableName);
        this.verifyVolumes(connector, tableName, MetadataSchema.TabletsSection.getRange((String)tableID), this.v1.toString() + "," + this.v2.toString() + "," + this.v4.toString());
    }

    @Test
    public void chooserNotSpecified() throws Exception {
        log.info("Starting chooserNotSpecified");
        Connector connector = this.getConnector();
        String tableName = this.getUniqueNames(2)[0];
        connector.tableOperations().create(tableName);
        String tableID = (String)connector.tableOperations().tableIdMap().get(tableName);
        this.addSplits(connector, tableName);
        this.writeAndReadData(connector, tableName);
        this.verifyVolumes(connector, tableName, MetadataSchema.TabletsSection.getRange((String)tableID), this.v1.toString() + "," + this.v2.toString() + "," + this.v4.toString());
    }
}

