/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.ThriftTransportKey;
import org.apache.accumulo.core.client.impl.ThriftTransportPool;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportCachingIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(TransportCachingIT.class);

    @Test
    public void testCachedTransport() {
        Connector conn = this.getConnector();
        Instance instance = conn.getInstance();
        ClientConfiguration clientConf = cluster.getClientConfig();
        ClientContext context = new ClientContext(instance, new Credentials(TransportCachingIT.getAdminPrincipal(), TransportCachingIT.getAdminToken()), clientConf);
        long rpcTimeout = DefaultConfiguration.getTimeInMillis((String)Property.GENERAL_RPC_TIMEOUT.getDefaultValue());
        ArrayList<ThriftTransportKey> servers = new ArrayList<ThriftTransportKey>();
        ZooCache zc = new ZooCacheFactory().getZooCache(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut());
        for (String tserver : zc.getChildren(ZooUtil.getRoot((Instance)instance) + "/tservers")) {
            String strData;
            String path = ZooUtil.getRoot((Instance)instance) + "/tservers" + "/" + tserver;
            byte[] data = ZooUtil.getLockData((ZooCache)zc, (String)path);
            if (data == null || (strData = new String(data, StandardCharsets.UTF_8)).equals("master")) continue;
            servers.add(new ThriftTransportKey(new ServerServices(strData).getAddress(ServerServices.Service.TSERV_CLIENT), rpcTimeout, context));
        }
        ThriftTransportPool pool = ThriftTransportPool.getInstance();
        TTransport first = null;
        while (null == first) {
            try {
                first = (TTransport)pool.getAnyTransport(servers, true).getSecond();
            }
            catch (TTransportException e) {
                log.warn("Failed to obtain transport to " + servers);
            }
        }
        Assert.assertNotNull(first);
        pool.returnTransport(first);
        TTransport second = null;
        while (null == second) {
            try {
                second = (TTransport)pool.getAnyTransport(servers, true).getSecond();
            }
            catch (TTransportException e) {
                log.warn("Failed obtain 2nd transport to " + servers);
            }
        }
        Assert.assertTrue((String)"Expected the first and second to be the same instance", (first == second ? 1 : 0) != 0);
        pool.returnTransport(second);
        TTransport third = null;
        while (null == third) {
            try {
                third = (TTransport)pool.getAnyTransport(servers, false).getSecond();
            }
            catch (TTransportException e) {
                log.warn("Failed obtain 2nd transport to " + servers);
            }
        }
        Assert.assertFalse((String)"Expected second and third transport to be different instances", (second == third ? 1 : 0) != 0);
        pool.returnTransport(third);
    }
}

