/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class TabletServerHdfsRestartIT
extends ConfigurableMacBase {
    private static final int N = 1000;

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.useMiniDFS(true);
        cfg.setNumTservers(1);
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void test() throws Exception {
        Connector conn = this.getConnector();
        Assert.assertEquals((long)1L, (long)conn.instanceOperations().getTabletServers().size());
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        BatchWriter bw = conn.createBatchWriter(tableName, null);
        for (int i = 0; i < 1000; ++i) {
            Mutation m = new Mutation((CharSequence)("" + i));
            m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
            bw.addMutation(m);
        }
        bw.close();
        conn.tableOperations().flush(tableName, null, null, true);
        this.cluster.getMiniDfs().restartNameNode(false);
        Assert.assertEquals((long)1000L, (long)Iterators.size((Iterator)conn.createScanner(tableName, Authorizations.EMPTY).iterator()));
    }
}

