/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.data.Mutation;

public class NullBatchWriter
implements BatchWriter {
    private int mutationsAdded;
    private long startTime;

    public void addMutation(Mutation m) throws MutationsRejectedException {
        if (this.mutationsAdded == 0) {
            this.startTime = System.currentTimeMillis();
        }
        ++this.mutationsAdded;
        m.numBytes();
    }

    public void addMutations(Iterable<Mutation> iterable) throws MutationsRejectedException {
        for (Mutation mutation : iterable) {
            this.addMutation(mutation);
        }
    }

    public void close() throws MutationsRejectedException {
        this.flush();
    }

    public void flush() throws MutationsRejectedException {
        System.out.printf("Mutation add rate : %,6.2f mutations/sec%n", (double)this.mutationsAdded / ((double)(System.currentTimeMillis() - this.startTime) / 1000.0));
        this.mutationsAdded = 0;
    }
}

