/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.test.categories.SunnyDayTests;
import org.apache.accumulo.test.functional.NativeMapIT;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.MemKey;
import org.apache.accumulo.tserver.NativeMap;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SunnyDayTests.class})
public class InMemoryMapIT {
    private static final Logger log = LoggerFactory.getLogger(InMemoryMapIT.class);
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder(new File(System.getProperty("user.dir") + "/target"));

    @BeforeClass
    public static void ensureNativeLibrary() throws FileNotFoundException {
        File nativeMapLocation = NativeMapIT.nativeMapLocation();
        log.debug("Native map location " + nativeMapLocation);
        NativeMap.loadNativeLib(Collections.singletonList(nativeMapLocation));
        if (!NativeMap.isLoaded()) {
            Assert.fail((String)("Missing the native library from " + nativeMapLocation.getAbsolutePath() + "\nYou need to build the libaccumulo binary first. \nTry running 'mvn clean verify -Dit.test=InMemoryMapIT -Dtest=foo -DfailIfNoTests=false -Dspotbugs.skip -Dcheckstyle.skip'"));
        }
        log.debug("Native map loaded");
    }

    @Test
    public void testOneMutationOneKey() {
        Mutation m = new Mutation((CharSequence)"a");
        m.put(new Text("1cf"), new Text("1cq"), new Value("vala".getBytes()));
        this.assertEquivalentMutate(m);
    }

    @Test
    public void testOneMutationManyKeys() throws IOException {
        Mutation m = new Mutation((CharSequence)"a");
        for (int i = 1; i < 6; ++i) {
            m.put(new Text("2cf" + i), new Text("2cq" + i), new Value(Integer.toString(i).getBytes()));
        }
        this.assertEquivalentMutate(m);
    }

    @Test
    public void testOneMutationManySameKeys() {
        Mutation m = new Mutation((CharSequence)"a");
        for (int i = 1; i <= 5; ++i) {
            m.put(new Text("3cf"), new Text("3cq"), new Value(Integer.toString(i).getBytes()));
        }
        this.assertEquivalentMutate(m);
    }

    @Test
    public void testMultipleMutationsOneKey() {
        Mutation m1 = new Mutation((CharSequence)"a");
        m1.put(new Text("4cf"), new Text("4cq"), new Value("vala".getBytes()));
        Mutation m2 = new Mutation((CharSequence)"b");
        m2.put(new Text("4cf"), new Text("4cq"), new Value("vala".getBytes()));
        this.assertEquivalentMutate(Arrays.asList(m1, m2));
    }

    @Test
    public void testMultipleMutationsSameOneKey() {
        Mutation m1 = new Mutation((CharSequence)"a");
        m1.put(new Text("5cf"), new Text("5cq"), new Value("vala".getBytes()));
        Mutation m2 = new Mutation((CharSequence)"a");
        m2.put(new Text("5cf"), new Text("5cq"), new Value("vala".getBytes()));
        this.assertEquivalentMutate(Arrays.asList(m1, m2));
    }

    @Test
    public void testMutlipleMutationsMultipleKeys() {
        Mutation m1 = new Mutation((CharSequence)"a");
        for (int i = 1; i < 6; ++i) {
            m1.put(new Text("6cf" + i), new Text("6cq" + i), new Value(Integer.toString(i).getBytes()));
        }
        Mutation m2 = new Mutation((CharSequence)"b");
        for (int i = 1; i < 3; ++i) {
            m2.put(new Text("6cf" + i), new Text("6cq" + i), new Value(Integer.toString(i).getBytes()));
        }
        this.assertEquivalentMutate(Arrays.asList(m1, m2));
    }

    @Test
    public void testMultipleMutationsMultipleSameKeys() {
        Mutation m1 = new Mutation((CharSequence)"a");
        for (int i = 1; i < 3; ++i) {
            m1.put(new Text("7cf"), new Text("7cq"), new Value(Integer.toString(i).getBytes()));
        }
        Mutation m2 = new Mutation((CharSequence)"a");
        for (int i = 1; i < 4; ++i) {
            m2.put(new Text("7cf"), new Text("7cq"), new Value(Integer.toString(i).getBytes()));
        }
        this.assertEquivalentMutate(Arrays.asList(m1, m2));
    }

    @Test
    public void testMultipleMutationsMultipleKeysSomeSame() {
        int i;
        int i2;
        Mutation m1 = new Mutation((CharSequence)"a");
        for (i2 = 1; i2 < 2; ++i2) {
            m1.put(new Text("8cf"), new Text("8cq"), new Value(Integer.toString(i2).getBytes()));
        }
        for (i2 = 1; i2 < 3; ++i2) {
            m1.put(new Text("8cf" + i2), new Text("8cq" + i2), new Value(Integer.toString(i2).getBytes()));
        }
        for (i2 = 1; i2 < 2; ++i2) {
            m1.put(new Text("8cf" + i2), new Text("8cq" + i2), new Value(Integer.toString(i2).getBytes()));
        }
        Mutation m2 = new Mutation((CharSequence)"a");
        for (i = 1; i < 3; ++i) {
            m2.put(new Text("8cf"), new Text("8cq"), new Value(Integer.toString(i).getBytes()));
        }
        for (i = 1; i < 4; ++i) {
            m2.put(new Text("8cf" + i), new Text("8cq" + i), new Value(Integer.toString(i).getBytes()));
        }
        Mutation m3 = new Mutation((CharSequence)"b");
        for (int i3 = 1; i3 < 3; ++i3) {
            m3.put(new Text("8cf" + i3), new Text("8cq" + i3), new Value(Integer.toString(i3).getBytes()));
        }
        this.assertEquivalentMutate(Arrays.asList(m1, m2, m3));
    }

    private void assertEquivalentMutate(Mutation m) {
        this.assertEquivalentMutate(Collections.singletonList(m));
    }

    private void assertEquivalentMutate(List<Mutation> mutations) {
        InMemoryMap defaultMap = null;
        InMemoryMap nativeMapWrapper = null;
        InMemoryMap localityGroupMap = null;
        InMemoryMap localityGroupMapWithNative = null;
        try {
            HashMap<String, String> defaultMapConfig = new HashMap<String, String>();
            defaultMapConfig.put(Property.TSERV_NATIVEMAP_ENABLED.getKey(), "false");
            defaultMapConfig.put(Property.TSERV_MEMDUMP_DIR.getKey(), this.tempFolder.newFolder().getAbsolutePath());
            defaultMapConfig.put(Property.TABLE_LOCALITY_GROUPS.getKey(), "");
            HashMap<String, String> nativeMapConfig = new HashMap<String, String>();
            nativeMapConfig.put(Property.TSERV_NATIVEMAP_ENABLED.getKey(), "true");
            nativeMapConfig.put(Property.TSERV_MEMDUMP_DIR.getKey(), this.tempFolder.newFolder().getAbsolutePath());
            nativeMapConfig.put(Property.TABLE_LOCALITY_GROUPS.getKey(), "");
            HashMap<String, String> localityGroupConfig = new HashMap<String, String>();
            localityGroupConfig.put(Property.TSERV_NATIVEMAP_ENABLED.getKey(), "false");
            localityGroupConfig.put(Property.TSERV_MEMDUMP_DIR.getKey(), this.tempFolder.newFolder().getAbsolutePath());
            HashMap<String, String> localityGroupNativeConfig = new HashMap<String, String>();
            localityGroupNativeConfig.put(Property.TSERV_NATIVEMAP_ENABLED.getKey(), "true");
            localityGroupNativeConfig.put(Property.TSERV_MEMDUMP_DIR.getKey(), this.tempFolder.newFolder().getAbsolutePath());
            defaultMap = new InMemoryMap((AccumuloConfiguration)new ConfigurationCopy(defaultMapConfig), "--TEST--");
            nativeMapWrapper = new InMemoryMap((AccumuloConfiguration)new ConfigurationCopy(nativeMapConfig), "--TEST--");
            localityGroupMap = new InMemoryMap((AccumuloConfiguration)this.updateConfigurationForLocalityGroups(new ConfigurationCopy(localityGroupConfig)), "--TEST--");
            localityGroupMapWithNative = new InMemoryMap((AccumuloConfiguration)this.updateConfigurationForLocalityGroups(new ConfigurationCopy(localityGroupNativeConfig)), "--TEST--");
        }
        catch (Exception e) {
            log.error("Error getting new InMemoryMap ", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((String)"Not a DefaultMap", (Object)"DefaultMap", (Object)defaultMap.getMapType());
        Assert.assertEquals((String)"Not a NativeMapWrapper", (Object)"NativeMapWrapper", (Object)nativeMapWrapper.getMapType());
        Assert.assertEquals((String)"Not a LocalityGroupMap", (Object)"LocalityGroupMap", (Object)localityGroupMap.getMapType());
        Assert.assertEquals((String)"Not a LocalityGroupMap with native", (Object)"LocalityGroupMap with native", (Object)localityGroupMapWithNative.getMapType());
        defaultMap.mutate(mutations);
        nativeMapWrapper.mutate(mutations);
        localityGroupMap.mutate(mutations);
        localityGroupMapWithNative.mutate(mutations);
        this.assertMutatesEquivalent(mutations, defaultMap, nativeMapWrapper);
        this.assertMutatesEquivalent(mutations, defaultMap, localityGroupMap);
        this.assertMutatesEquivalent(mutations, defaultMap, localityGroupMapWithNative);
    }

    private void assertMutatesEquivalent(List<Mutation> mutations, InMemoryMap imm1, InMemoryMap imm2) {
        int mutationKVPairs = this.countKVPairs(mutations);
        List<MemKey> memKeys1 = this.getArrayOfMemKeys(imm1);
        List<MemKey> memKeys2 = this.getArrayOfMemKeys(imm2);
        Assert.assertEquals((String)("Not all key value pairs included: " + this.dumpInMemoryMap(imm1, memKeys1)), (long)mutationKVPairs, (long)memKeys1.size());
        Assert.assertEquals((String)("InMemoryMaps differ in size: " + this.dumpInMemoryMap(imm1, memKeys1) + "\n" + this.dumpInMemoryMap(imm2, memKeys2)), (long)memKeys1.size(), (long)memKeys2.size());
        Assert.assertEquals((String)("InMemoryMap did not have distinct kvCounts " + this.dumpInMemoryMap(imm1, memKeys1)), (long)mutationKVPairs, (long)this.getUniqKVCount(memKeys1));
        Assert.assertEquals((String)("InMemoryMap did not have distinct kvCounts " + this.dumpInMemoryMap(imm2, memKeys2)), (long)mutationKVPairs, (long)this.getUniqKVCount(memKeys2));
    }

    private int countKVPairs(List<Mutation> mutations) {
        int count = 0;
        for (Mutation m : mutations) {
            count += m.size();
        }
        return count;
    }

    private List<MemKey> getArrayOfMemKeys(InMemoryMap imm) {
        SortedKeyValueIterator skvi = imm.compactionIterator();
        ArrayList<MemKey> memKeys = new ArrayList<MemKey>();
        try {
            skvi.seek(new Range(), new ArrayList(), false);
            while (skvi.hasTop()) {
                memKeys.add((MemKey)skvi.getTopKey());
                skvi.next();
            }
        }
        catch (IOException ex) {
            log.error("Error getting memkeys", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return memKeys;
    }

    private String dumpInMemoryMap(InMemoryMap map, List<MemKey> memkeys) {
        StringBuilder sb = new StringBuilder();
        sb.append("InMemoryMap type ");
        sb.append(map.getMapType());
        sb.append("\n");
        for (MemKey mk : memkeys) {
            sb.append("  ");
            sb.append(mk.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private int getUniqKVCount(List<MemKey> memKeys) {
        ArrayList<Integer> kvCounts = new ArrayList<Integer>();
        for (MemKey m : memKeys) {
            kvCounts.add(m.getKVCount());
        }
        return ImmutableSet.copyOf(kvCounts).size();
    }

    private ConfigurationCopy updateConfigurationForLocalityGroups(ConfigurationCopy configuration) {
        Map<String, Set<ByteSequence>> locGroups = this.getLocalityGroups();
        StringBuilder enabledLGs = new StringBuilder();
        for (Map.Entry<String, Set<ByteSequence>> entry : locGroups.entrySet()) {
            if (enabledLGs.length() > 0) {
                enabledLGs.append(",");
            }
            StringBuilder value = new StringBuilder();
            for (ByteSequence bytes : entry.getValue()) {
                if (value.length() > 0) {
                    value.append(",");
                }
                value.append(new String(bytes.toArray()));
            }
            configuration.set("table.group." + entry.getKey(), value.toString());
            enabledLGs.append(entry.getKey());
        }
        configuration.set(Property.TABLE_LOCALITY_GROUPS, enabledLGs.toString());
        return configuration;
    }

    private Map<String, Set<ByteSequence>> getLocalityGroups() {
        HashMap<String, Set<ByteSequence>> locgro = new HashMap<String, Set<ByteSequence>>();
        locgro.put("a", this.newCFSet("cf", "cf2"));
        locgro.put("b", this.newCFSet("cf3", "cf4"));
        return locgro;
    }

    private Set<ByteSequence> newCFSet(String ... cfs) {
        HashSet<ByteSequence> cfSet = new HashSet<ByteSequence>();
        for (String cf : cfs) {
            cfSet.add((ByteSequence)new ArrayByteSequence(cf));
        }
        return cfSet;
    }
}

