/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.master.thrift.BulkImportStatus;
import org.apache.accumulo.core.master.thrift.DeadServer;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.RecoveryStatus;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.util.TableInfoUtil;

public class GetMasterStats {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        MasterMonitorInfo stats;
        block18: {
            MasterClientService.Client client = null;
            stats = null;
            try {
                AccumuloServerContext context = new AccumuloServerContext(new ServerConfigurationFactory(HdfsZooInstance.getInstance()));
                client = MasterClient.getConnectionWithRetry((ClientContext)context);
                stats = client.getMasterStats(Tracer.traceInfo(), context.rpcCreds());
                if (client == null) break block18;
            }
            catch (Throwable throwable) {
                if (client != null) {
                    MasterClient.close(client);
                }
                throw throwable;
            }
            MasterClient.close((MasterClientService.Iface)client);
        }
        GetMasterStats.out(0, "State: " + stats.state.name(), new Object[0]);
        GetMasterStats.out(0, "Goal State: " + stats.goalState.name(), new Object[0]);
        if (stats.serversShuttingDown != null && stats.serversShuttingDown.size() > 0) {
            GetMasterStats.out(0, "Servers to shutdown", new Object[0]);
            for (String string : stats.serversShuttingDown) {
                GetMasterStats.out(1, "%s", string);
            }
        }
        GetMasterStats.out(0, "Unassigned tablets: %d", stats.unassignedTablets);
        if (stats.badTServers != null && stats.badTServers.size() > 0) {
            GetMasterStats.out(0, "Bad servers", new Object[0]);
            for (Map.Entry entry : stats.badTServers.entrySet()) {
                GetMasterStats.out(1, "%s: %d", entry.getKey(), (Byte)entry.getValue());
            }
        }
        GetMasterStats.out(0, "Dead tablet servers count: %s", stats.deadTabletServers.size());
        for (DeadServer deadServer : stats.deadTabletServers) {
            GetMasterStats.out(1, "Dead tablet server: %s", deadServer.server);
            GetMasterStats.out(2, "Last report: %s", new SimpleDateFormat().format(new Date(deadServer.lastStatus)));
            GetMasterStats.out(2, "Cause: %s", deadServer.status);
        }
        GetMasterStats.out(0, "Bulk imports: %s", stats.bulkImports.size());
        for (BulkImportStatus bulkImportStatus : stats.bulkImports) {
            GetMasterStats.out(1, "Import directory: %s", bulkImportStatus.filename);
            GetMasterStats.out(2, "Bulk state %s", bulkImportStatus.state);
            GetMasterStats.out(2, "Bulk start %s", bulkImportStatus.startTime);
        }
        if (stats.tableMap != null && stats.tableMap.size() > 0) {
            GetMasterStats.out(0, "Tables", new Object[0]);
            for (Map.Entry entry : stats.tableMap.entrySet()) {
                TableInfo v = (TableInfo)entry.getValue();
                GetMasterStats.out(1, "%s", entry.getKey());
                GetMasterStats.out(2, "Records: %d", v.recs);
                GetMasterStats.out(2, "Records in Memory: %d", v.recsInMemory);
                GetMasterStats.out(2, "Tablets: %d", v.tablets);
                GetMasterStats.out(2, "Online Tablets: %d", v.onlineTablets);
                GetMasterStats.out(2, "Ingest Rate: %.2f", v.ingestRate);
                GetMasterStats.out(2, "Query Rate: %.2f", v.queryRate);
            }
        }
        if (stats.tServerInfo != null && stats.tServerInfo.size() > 0) {
            GetMasterStats.out(0, "Tablet Servers", new Object[0]);
            long now = System.currentTimeMillis();
            for (TabletServerStatus server : stats.tServerInfo) {
                TableInfo summary = TableInfoUtil.summarizeTableStats((TabletServerStatus)server);
                GetMasterStats.out(1, "Name: %s", server.name);
                GetMasterStats.out(2, "Ingest: %.2f", summary.ingestRate);
                GetMasterStats.out(2, "Last Contact: %s", server.lastContact);
                GetMasterStats.out(2, "OS Load Average: %.2f", server.osLoad);
                GetMasterStats.out(2, "Queries: %.2f", summary.queryRate);
                GetMasterStats.out(2, "Time Difference: %.1f", (double)(now - server.lastContact) / 1000.0);
                GetMasterStats.out(2, "Total Records: %d", summary.recs);
                GetMasterStats.out(2, "Lookups: %d", server.lookups);
                if (server.holdTime > 0L) {
                    GetMasterStats.out(2, "Hold Time: %d", server.holdTime);
                }
                if (server.tableMap != null && server.tableMap.size() > 0) {
                    GetMasterStats.out(2, "Tables", new Object[0]);
                    for (Map.Entry status : server.tableMap.entrySet()) {
                        TableInfo info = (TableInfo)status.getValue();
                        GetMasterStats.out(3, "Table: %s", status.getKey());
                        GetMasterStats.out(4, "Tablets: %d", info.onlineTablets);
                        GetMasterStats.out(4, "Records: %d", info.recs);
                        GetMasterStats.out(4, "Records in Memory: %d", info.recsInMemory);
                        GetMasterStats.out(4, "Ingest: %.2f", info.ingestRate);
                        GetMasterStats.out(4, "Queries: %.2f", info.queryRate);
                        GetMasterStats.out(4, "Major Compacting: %d", info.majors == null ? 0 : info.majors.running);
                        GetMasterStats.out(4, "Queued for Major Compaction: %d", info.majors == null ? 0 : info.majors.queued);
                        GetMasterStats.out(4, "Minor Compacting: %d", info.minors == null ? 0 : info.minors.running);
                        GetMasterStats.out(4, "Queued for Minor Compaction: %d", info.minors == null ? 0 : info.minors.queued);
                    }
                }
                GetMasterStats.out(2, "Recoveries: %d", server.logSorts.size());
                for (RecoveryStatus sort : server.logSorts) {
                    GetMasterStats.out(3, "File: %s", sort.name);
                    GetMasterStats.out(3, "Progress: %.2f%%", sort.progress * 100.0);
                    GetMasterStats.out(3, "Time running: %s", (double)sort.runtime / 1000.0);
                }
                GetMasterStats.out(3, "Bulk imports: %s", stats.bulkImports.size());
                for (BulkImportStatus bulk : stats.bulkImports) {
                    GetMasterStats.out(4, "Import file: %s", bulk.filename);
                    GetMasterStats.out(5, "Bulk state %s", bulk.state);
                    GetMasterStats.out(5, "Bulk start %s", bulk.startTime);
                }
            }
        }
    }

    private static void out(int indent, String string, Object ... args) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(" ");
        }
        System.out.println(String.format(string, args));
    }
}

