/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.RemoteIterator;
import org.junit.Assert;
import org.junit.Test;

public class GarbageCollectWALIT
extends ConfigurableMacBase {
    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_HOST, "5s");
        cfg.setProperty(Property.GC_CYCLE_START, "1s");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1s");
        cfg.setNumTservers(1);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 180;
    }

    @Test
    public void test() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        this.cluster.getClusterControl().stop(ServerType.GARBAGE_COLLECTOR);
        Connector c = this.getConnector();
        c.tableOperations().create(tableName);
        Assert.assertEquals((long)2L, (long)this.countWALsInFS(this.cluster));
        this.cluster.getClusterControl().stop(ServerType.TABLET_SERVER);
        this.cluster.getClusterControl().start(ServerType.GARBAGE_COLLECTOR);
        this.cluster.getClusterControl().start(ServerType.TABLET_SERVER);
        Iterators.size((Iterator)c.createScanner("accumulo.metadata", Authorizations.EMPTY).iterator());
        UtilWaitThread.sleep((long)15000L);
        Assert.assertEquals((long)2L, (long)this.countWALsInFS(this.cluster));
    }

    private int countWALsInFS(MiniAccumuloClusterImpl cluster) throws Exception {
        FileSystem fs = cluster.getFileSystem();
        RemoteIterator iterator = fs.listFiles(new Path(cluster.getConfig().getAccumuloDir() + "/wal"), true);
        int result = 0;
        while (iterator.hasNext()) {
            LocatedFileStatus next = (LocatedFileStatus)iterator.next();
            if (next.isDirectory()) continue;
            ++result;
        }
        return result;
    }
}

