/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterables;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public class FileArchiveIT
extends ConfigurableMacBase {
    @Override
    public int defaultTimeoutSeconds() {
        return 120;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
        cfg.setProperty(Property.GC_FILE_ARCHIVE, "true");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1s");
        cfg.setProperty(Property.GC_CYCLE_START, "1s");
    }

    @Test
    public void testUnusuedFilesAreArchived() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        String tableId = (String)conn.tableOperations().tableIdMap().get(tableName);
        Assert.assertNotNull((String)"Could not get table ID", (Object)tableId);
        BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"row");
        m.put((CharSequence)"", (CharSequence)"", (CharSequence)"value");
        bw.addMutation(m);
        bw.close();
        conn.tableOperations().compact(tableName, null, null, true, true);
        Scanner s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(MetadataSchema.TabletsSection.getRange((String)tableId));
        s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
        String file = ((Key)entry.getKey()).getColumnQualifier().toString();
        Path p = new Path(file);
        conn.tableOperations().compact(tableName, null, null, true, true);
        log.info("File for table: " + file);
        FileSystem fs = this.getCluster().getFileSystem();
        int i = 0;
        while (fs.exists(p)) {
            Thread.sleep(1000L);
            if (0 != ++i % 10) continue;
            log.info("Waited " + i + " iterations, file still exists");
        }
        log.info("File was removed");
        String filePath = p.toUri().getPath().substring(this.getCluster().getConfig().getAccumuloDir().toString().length());
        log.info("File relative to accumulo dir: " + filePath);
        Path fileArchiveDir = new Path(this.getCluster().getConfig().getAccumuloDir().toString(), "fileArchive");
        Assert.assertTrue((String)"File archive directory didn't exist", (boolean)fs.exists(fileArchiveDir));
        Path archivedFile = new Path(fileArchiveDir, filePath.substring(1));
        Assert.assertTrue((String)("File doesn't exists in archive directory: " + archivedFile), (boolean)fs.exists(archivedFile));
    }

    @Test
    public void testDeletedTableIsArchived() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        String tableId = (String)conn.tableOperations().tableIdMap().get(tableName);
        Assert.assertNotNull((String)"Could not get table ID", (Object)tableId);
        BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"row");
        m.put((CharSequence)"", (CharSequence)"", (CharSequence)"value");
        bw.addMutation(m);
        bw.close();
        conn.tableOperations().compact(tableName, null, null, true, true);
        Scanner s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(MetadataSchema.TabletsSection.getRange((String)tableId));
        s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
        String file = ((Key)entry.getKey()).getColumnQualifier().toString();
        Path p = new Path(file);
        conn.tableOperations().delete(tableName);
        log.info("File for table: " + file);
        FileSystem fs = this.getCluster().getFileSystem();
        int i = 0;
        while (fs.exists(p)) {
            Thread.sleep(1000L);
            if (0 != ++i % 10) continue;
            log.info("Waited " + i + " iterations, file still exists");
        }
        log.info("File was removed");
        String filePath = p.toUri().getPath().substring(this.getCluster().getConfig().getAccumuloDir().toString().length());
        log.info("File relative to accumulo dir: " + filePath);
        Path fileArchiveDir = new Path(this.getCluster().getConfig().getAccumuloDir().toString(), "fileArchive");
        Assert.assertTrue((String)"File archive directory didn't exist", (boolean)fs.exists(fileArchiveDir));
        Path archivedFile = new Path(fileArchiveDir, filePath.substring(1));
        Assert.assertTrue((String)("File doesn't exists in archive directory: " + archivedFile), (boolean)fs.exists(archivedFile));
    }

    @Test
    public void testUnusuedFilesAndDeletedTable() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        String tableId = (String)conn.tableOperations().tableIdMap().get(tableName);
        Assert.assertNotNull((String)"Could not get table ID", (Object)tableId);
        BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"row");
        m.put((CharSequence)"", (CharSequence)"", (CharSequence)"value");
        bw.addMutation(m);
        bw.close();
        conn.tableOperations().compact(tableName, null, null, true, true);
        Scanner s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(MetadataSchema.TabletsSection.getRange((String)tableId));
        s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
        String file = ((Key)entry.getKey()).getColumnQualifier().toString();
        Path p = new Path(file);
        conn.tableOperations().compact(tableName, null, null, true, true);
        log.info("File for table: " + file);
        FileSystem fs = this.getCluster().getFileSystem();
        int i = 0;
        while (fs.exists(p)) {
            Thread.sleep(1000L);
            if (0 != ++i % 10) continue;
            log.info("Waited " + i + " iterations, file still exists");
        }
        log.info("File was removed");
        String filePath = p.toUri().getPath().substring(this.getCluster().getConfig().getAccumuloDir().toString().length());
        log.info("File relative to accumulo dir: " + filePath);
        Path fileArchiveDir = new Path(this.getCluster().getConfig().getAccumuloDir().toString(), "fileArchive");
        Assert.assertTrue((String)"File archive directory didn't exist", (boolean)fs.exists(fileArchiveDir));
        Path archivedFile = new Path(fileArchiveDir, filePath.substring(1));
        Assert.assertTrue((String)("File doesn't exists in archive directory: " + archivedFile), (boolean)fs.exists(archivedFile));
        conn.tableOperations().offline(tableName, true);
        s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(MetadataSchema.TabletsSection.getRange((String)tableId));
        s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
        String finalFile = ((Key)entry.getKey()).getColumnQualifier().toString();
        Path finalPath = new Path(finalFile);
        conn.tableOperations().delete(tableName);
        log.info("File for table: " + finalPath);
        i = 0;
        while (fs.exists(finalPath)) {
            Thread.sleep(1000L);
            if (0 != ++i % 10) continue;
            log.info("Waited " + i + " iterations, file still exists");
        }
        log.info("File was removed");
        String finalFilePath = finalPath.toUri().getPath().substring(this.getCluster().getConfig().getAccumuloDir().toString().length());
        log.info("File relative to accumulo dir: " + finalFilePath);
        Assert.assertTrue((String)"File archive directory didn't exist", (boolean)fs.exists(fileArchiveDir));
        Path finalArchivedFile = new Path(fileArchiveDir, finalFilePath.substring(1));
        Assert.assertTrue((String)("File doesn't exists in archive directory: " + finalArchivedFile), (boolean)fs.exists(finalArchivedFile));
    }
}

