/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Condition;
import org.apache.accumulo.core.data.ConditionalMutation;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.examples.simple.constraints.AlphaNumKeyConstraint;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.BadIterator;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.accumulo.tracer.TraceDump;
import org.apache.accumulo.tracer.TraceServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalWriterIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(ConditionalWriterIT.class);

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        super.configureMiniCluster(cfg, hadoopCoreSite);
        Map siteConf = cfg.getSiteConfig();
        siteConf.put(Property.TRACE_SPAN_RECEIVER_PREFIX.getKey() + "tracer.span.min.ms", "0");
        cfg.setSiteConfig(siteConf);
    }

    public static long abs(long l) {
        if ((l = Math.abs(l)) < 0L) {
            return 0L;
        }
        return l;
    }

    @Before
    public void deleteUsers() throws Exception {
        ClusterUser user;
        Connector conn = this.getConnector();
        Set users = conn.securityOperations().listLocalUsers();
        if (users.contains((user = this.getUser(0)).getPrincipal())) {
            conn.securityOperations().dropLocalUser(user.getPrincipal());
        }
    }

    @Test
    public void testBasic() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        try (ConditionalWriter cw = conn.createConditionalWriter(tableName, new ConditionalWriterConfig());){
            ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
            cm0.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"doe");
            cm0.put((CharSequence)"name", (CharSequence)"first", (CharSequence)"john");
            cm0.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm0).getStatus());
            Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm0).getStatus());
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
            cm1.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"Doe");
            cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm1).getStatus());
            ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
            cm2.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"DOE");
            cm2.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
            Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm2).getStatus());
            ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"txtypo", (CharSequence)"seq").setValue((CharSequence)"1")});
            cm3.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"deo");
            cm3.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
            Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm3).getStatus());
            ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"2"), new Condition((CharSequence)"name", (CharSequence)"last").setValue((CharSequence)"doe")});
            cm4.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"deo");
            cm4.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"3");
            Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm4).getStatus());
            ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1"), new Condition((CharSequence)"name", (CharSequence)"last").setValue((CharSequence)"Doe")});
            cm5.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"deo");
            cm5.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"3");
            Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm5).getStatus());
            Scanner scanner = conn.createScanner(tableName, Authorizations.EMPTY);
            scanner.fetchColumn(new Text("name"), new Text("last"));
            scanner.setRange(new Range((CharSequence)"99006"));
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
            Assert.assertEquals((Object)"Doe", (Object)((Value)entry.getValue()).toString());
            ConditionalMutation cm6 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"2"), new Condition((CharSequence)"name", (CharSequence)"last").setValue((CharSequence)"Doe")});
            cm6.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"DOE");
            cm6.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"3");
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm6).getStatus());
            entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
            Assert.assertEquals((Object)"DOE", (Object)((Value)entry.getValue()).toString());
            ConditionalMutation cm7 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"3")});
            cm7.putDelete((CharSequence)"name", (CharSequence)"last");
            cm7.putDelete((CharSequence)"name", (CharSequence)"first");
            cm7.putDelete((CharSequence)"tx", (CharSequence)"seq");
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm7).getStatus());
            Assert.assertFalse((String)"Did not expect to find any results", (boolean)scanner.iterator().hasNext());
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm0).getStatus());
            Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm0).getStatus());
            entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
            Assert.assertEquals((Object)"doe", (Object)((Value)entry.getValue()).toString());
        }
    }

    @Test
    public void testFields() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        String user = null;
        ClientConfiguration clientConf = cluster.getClientConfig();
        boolean saslEnabled = clientConf.hasSasl();
        ClusterUser user1 = this.getUser(0);
        user = user1.getPrincipal();
        if (saslEnabled) {
            conn.securityOperations().createLocalUser(user, null);
        } else {
            conn.securityOperations().createLocalUser(user, new PasswordToken((CharSequence)user1.getPassword()));
        }
        Authorizations auths = new Authorizations(new String[]{"A", "B"});
        conn.securityOperations().changeUserAuthorizations(user, auths);
        conn.securityOperations().grantSystemPermission(user, SystemPermission.CREATE_TABLE);
        conn = conn.getInstance().getConnector(user, user1.getToken());
        conn.tableOperations().create(tableName);
        try (ConditionalWriter cw = conn.createConditionalWriter(tableName, new ConditionalWriterConfig().setAuthorizations(auths));){
            ColumnVisibility cva = new ColumnVisibility("A");
            ColumnVisibility cvb = new ColumnVisibility("B");
            ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva)});
            cm0.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
            cm0.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
            cm0.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm0).getStatus());
            Scanner scanner = conn.createScanner(tableName, auths);
            scanner.setRange(new Range((CharSequence)"99006"));
            scanner.fetchColumn(new Text("tx"), new Text("seq"));
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
            Assert.assertEquals((Object)"1", (Object)((Value)entry.getValue()).toString());
            long ts = ((Key)entry.getKey()).getTimestamp();
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"txA", (CharSequence)"seq").setVisibility(cva).setValue((CharSequence)"1")});
            cm1.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
            cm1.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
            cm1.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
            Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm1).getStatus());
            ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seqA").setVisibility(cva).setValue((CharSequence)"1")});
            cm2.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
            cm2.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
            cm2.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
            Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm2).getStatus());
            ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb).setValue((CharSequence)"1")});
            cm3.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
            cm3.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
            cm3.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
            Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm3).getStatus());
            ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setTimestamp(ts + 1L).setValue((CharSequence)"1")});
            cm4.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
            cm4.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
            cm4.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
            Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm4).getStatus());
            ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setTimestamp(ts - 1L).setValue((CharSequence)"1")});
            cm5.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
            cm5.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
            cm5.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
            Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm5).getStatus());
            entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
            Assert.assertEquals((Object)"1", (Object)((Value)entry.getValue()).toString());
            ConditionalMutation cm6 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setTimestamp(ts).setValue((CharSequence)"1")});
            cm6.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
            cm6.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
            cm6.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm6).getStatus());
            entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
            Assert.assertEquals((Object)"2", (Object)((Value)entry.getValue()).toString());
        }
    }

    @Test
    public void testBadColVis() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        Authorizations auths = new Authorizations(new String[]{"A", "B"});
        conn.securityOperations().changeUserAuthorizations(ConditionalWriterIT.getAdminPrincipal(), auths);
        Authorizations filteredAuths = new Authorizations(new String[]{"A"});
        ColumnVisibility cva = new ColumnVisibility("A");
        ColumnVisibility cvb = new ColumnVisibility("B");
        ColumnVisibility cvc = new ColumnVisibility("C");
        try (ConditionalWriter cw = conn.createConditionalWriter(tableName, new ConditionalWriterConfig().setAuthorizations(filteredAuths));){
            ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb)});
            cm0.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
            cm0.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
            cm0.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm0).getStatus());
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb).setValue((CharSequence)"1")});
            cm1.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
            cm1.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
            cm1.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm1).getStatus());
            ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvc)});
            cm2.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
            cm2.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
            cm2.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm2).getStatus());
            ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvc).setValue((CharSequence)"1")});
            cm3.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
            cm3.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
            cm3.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm3).getStatus());
            ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb), new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva)});
            cm4.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
            cm4.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
            cm4.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm4).getStatus());
            ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb).setValue((CharSequence)"1"), new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setValue((CharSequence)"1")});
            cm5.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
            cm5.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
            cm5.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm5).getStatus());
            ConditionalMutation cm6 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb).setValue((CharSequence)"1"), new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva)});
            cm6.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
            cm6.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
            cm6.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm6).getStatus());
            ConditionalMutation cm7 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb), new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setValue((CharSequence)"1")});
            cm7.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
            cm7.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
            cm7.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm7).getStatus());
        }
        Authorizations exceedingAuths = new Authorizations(new String[]{"A", "B", "D"});
        try (ConditionalWriter cw2 = conn.createConditionalWriter(tableName, new ConditionalWriterConfig().setAuthorizations(exceedingAuths));){
            ConditionalMutation cm8 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb), new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setValue((CharSequence)"1")});
            cm8.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
            cm8.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
            cm8.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
            try {
                ConditionalWriter.Status status = cw2.write(cm8).getStatus();
                Assert.fail((String)("Writing mutation with Authorizations the user doesn't have should fail. Got status: " + status));
            }
            catch (AccumuloSecurityException accumuloSecurityException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testConstraints() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        conn.tableOperations().addConstraint(tableName, AlphaNumKeyConstraint.class.getName());
        conn.tableOperations().clone(tableName, tableName + "_clone", true, new HashMap(), new HashSet());
        Scanner scanner = conn.createScanner(tableName + "_clone", new Authorizations());
        try (ConditionalWriter cw = conn.createConditionalWriter(tableName + "_clone", new ConditionalWriterConfig());){
            ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006+", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
            cm0.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.VIOLATED, (Object)cw.write(cm0).getStatus());
            Assert.assertFalse((String)"Should find no results in the table is mutation result was violated", (boolean)scanner.iterator().hasNext());
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
            cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm1).getStatus());
            Assert.assertTrue((String)"Accepted result should be returned when reading table", (boolean)scanner.iterator().hasNext());
        }
    }

    @Test
    public void testIterators() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName, new NewTableConfiguration().withoutDefaultIterators());
        BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"ACCUMULO-1000");
        m.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"1");
        bw.addMutation(m);
        bw.addMutation(m);
        bw.addMutation(m);
        m = new Mutation((CharSequence)"ACCUMULO-1001");
        m.put((CharSequence)"count2", (CharSequence)"comments", (CharSequence)"1");
        bw.addMutation(m);
        bw.addMutation(m);
        m = new Mutation((CharSequence)"ACCUMULO-1002");
        m.put((CharSequence)"count2", (CharSequence)"comments", (CharSequence)"1");
        bw.addMutation(m);
        bw.addMutation(m);
        bw.close();
        IteratorSetting iterConfig = new IteratorSetting(10, SummingCombiner.class);
        SummingCombiner.setEncodingType((IteratorSetting)iterConfig, (LongCombiner.Type)LongCombiner.Type.STRING);
        SummingCombiner.setColumns((IteratorSetting)iterConfig, Collections.singletonList(new IteratorSetting.Column("count")));
        IteratorSetting iterConfig2 = new IteratorSetting(10, SummingCombiner.class);
        SummingCombiner.setEncodingType((IteratorSetting)iterConfig2, (LongCombiner.Type)LongCombiner.Type.STRING);
        SummingCombiner.setColumns((IteratorSetting)iterConfig2, Collections.singletonList(new IteratorSetting.Column("count2", "comments")));
        IteratorSetting iterConfig3 = new IteratorSetting(5, VersioningIterator.class);
        VersioningIterator.setMaxVersions((IteratorSetting)iterConfig3, (int)1);
        Scanner scanner = conn.createScanner(tableName, new Authorizations());
        scanner.addScanIterator(iterConfig);
        scanner.setRange(new Range((CharSequence)"ACCUMULO-1000"));
        scanner.fetchColumn(new Text("count"), new Text("comments"));
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
        Assert.assertEquals((Object)"3", (Object)((Value)entry.getValue()).toString());
        try (ConditionalWriter cw = conn.createConditionalWriter(tableName, new ConditionalWriterConfig());){
            ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setValue((CharSequence)"3")});
            cm0.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm0).getStatus());
            entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
            Assert.assertEquals((Object)"3", (Object)((Value)entry.getValue()).toString());
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{iterConfig}).setValue((CharSequence)"3")});
            cm1.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm1).getStatus());
            entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
            Assert.assertEquals((Object)"4", (Object)((Value)entry.getValue()).toString());
            ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setValue((CharSequence)"4")});
            cm2.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm1).getStatus());
            entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
            Assert.assertEquals((Object)"4", (Object)((Value)entry.getValue()).toString());
            ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{iterConfig}).setValue((CharSequence)"4")});
            cm3.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"1");
            ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"ACCUMULO-1001", new Condition[]{new Condition((CharSequence)"count2", (CharSequence)"comments").setIterators(new IteratorSetting[]{iterConfig2}).setValue((CharSequence)"2")});
            cm4.put((CharSequence)"count2", (CharSequence)"comments", (CharSequence)"1");
            ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"ACCUMULO-1002", new Condition[]{new Condition((CharSequence)"count2", (CharSequence)"comments").setIterators(new IteratorSetting[]{iterConfig2, iterConfig3}).setValue((CharSequence)"2")});
            cm5.put((CharSequence)"count2", (CharSequence)"comments", (CharSequence)"1");
            Iterator results = cw.write(Arrays.asList(cm3, cm4, cm5).iterator());
            HashMap<String, ConditionalWriter.Status> actual = new HashMap<String, ConditionalWriter.Status>();
            while (results.hasNext()) {
                ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                String k = new String(result.getMutation().getRow());
                Assert.assertFalse((String)("Did not expect to see multiple resultus for the row: " + k), (boolean)actual.containsKey(k));
                actual.put(k, result.getStatus());
            }
            HashMap<String, ConditionalWriter.Status> expected = new HashMap<String, ConditionalWriter.Status>();
            expected.put("ACCUMULO-1000", ConditionalWriter.Status.ACCEPTED);
            expected.put("ACCUMULO-1001", ConditionalWriter.Status.ACCEPTED);
            expected.put("ACCUMULO-1002", ConditionalWriter.Status.REJECTED);
            Assert.assertEquals(expected, actual);
        }
    }

    @Test
    public void testTableAndConditionIterators() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        IteratorSetting aiConfig1 = new IteratorSetting(30, "AI1", AddingIterator.class);
        aiConfig1.addOption("amount", "2");
        IteratorSetting aiConfig2 = new IteratorSetting(35, "MI1", MultiplyingIterator.class);
        aiConfig2.addOption("amount", "3");
        IteratorSetting aiConfig3 = new IteratorSetting(40, "AI2", AddingIterator.class);
        aiConfig3.addOption("amount", "5");
        conn.tableOperations().create(tableName);
        BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"ACCUMULO-1000");
        m.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"6");
        bw.addMutation(m);
        m = new Mutation((CharSequence)"ACCUMULO-1001");
        m.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"7");
        bw.addMutation(m);
        m = new Mutation((CharSequence)"ACCUMULO-1002");
        m.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"8");
        bw.addMutation(m);
        bw.close();
        conn.tableOperations().attachIterator(tableName, aiConfig1, EnumSet.of(IteratorUtil.IteratorScope.scan));
        conn.tableOperations().offline(tableName, true);
        conn.tableOperations().online(tableName, true);
        try (ConditionalWriter cw = conn.createConditionalWriter(tableName, new ConditionalWriterConfig());){
            ConditionalMutation cm6 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setValue((CharSequence)"8")});
            cm6.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"7");
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm6).getStatus());
            Scanner scanner = conn.createScanner(tableName, new Authorizations());
            scanner.setRange(new Range((CharSequence)"ACCUMULO-1000"));
            scanner.fetchColumn(new Text("count"), new Text("comments"));
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
            Assert.assertEquals((Object)"9", (Object)((Value)entry.getValue()).toString());
            ConditionalMutation cm7 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{aiConfig2}).setValue((CharSequence)"27")});
            cm7.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"8");
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm7).getStatus());
            entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
            Assert.assertEquals((Object)"10", (Object)((Value)entry.getValue()).toString());
            ConditionalMutation cm8 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{aiConfig2, aiConfig3}).setValue((CharSequence)"35")});
            cm8.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"9");
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm8).getStatus());
            entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
            Assert.assertEquals((Object)"11", (Object)((Value)entry.getValue()).toString());
            ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{aiConfig2}).setValue((CharSequence)"33")});
            cm3.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"3");
            ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"ACCUMULO-1001", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{aiConfig3}).setValue((CharSequence)"14")});
            cm4.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"3");
            ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"ACCUMULO-1002", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{aiConfig3}).setValue((CharSequence)"10")});
            cm5.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"3");
            Iterator results = cw.write(Arrays.asList(cm3, cm4, cm5).iterator());
            HashMap<String, ConditionalWriter.Status> actual = new HashMap<String, ConditionalWriter.Status>();
            while (results.hasNext()) {
                ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                String k = new String(result.getMutation().getRow());
                Assert.assertFalse((String)("Did not expect to see multiple resultus for the row: " + k), (boolean)actual.containsKey(k));
                actual.put(k, result.getStatus());
            }
            HashMap<String, ConditionalWriter.Status> expected = new HashMap<String, ConditionalWriter.Status>();
            expected.put("ACCUMULO-1000", ConditionalWriter.Status.ACCEPTED);
            expected.put("ACCUMULO-1001", ConditionalWriter.Status.ACCEPTED);
            expected.put("ACCUMULO-1002", ConditionalWriter.Status.REJECTED);
            Assert.assertEquals(expected, actual);
        }
    }

    @Test
    public void testBatch() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        conn.securityOperations().changeUserAuthorizations(ConditionalWriterIT.getAdminPrincipal(), new Authorizations(new String[]{"A", "B"}));
        ColumnVisibility cvab = new ColumnVisibility("A|B");
        ArrayList<ConditionalMutation> mutations = new ArrayList<ConditionalMutation>();
        ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab)});
        cm0.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"doe");
        cm0.put((CharSequence)"name", (CharSequence)"first", cvab, (CharSequence)"john");
        cm0.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"1");
        mutations.add(cm0);
        ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"59056", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab)});
        cm1.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"doe");
        cm1.put((CharSequence)"name", (CharSequence)"first", cvab, (CharSequence)"jane");
        cm1.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"1");
        mutations.add(cm1);
        ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"19059", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab)});
        cm2.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"doe");
        cm2.put((CharSequence)"name", (CharSequence)"first", cvab, (CharSequence)"jack");
        cm2.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"1");
        mutations.add(cm2);
        try (ConditionalWriter cw = conn.createConditionalWriter(tableName, new ConditionalWriterConfig().setAuthorizations(new Authorizations(new String[]{"A"})));){
            Iterator results = cw.write(mutations.iterator());
            int count = 0;
            while (results.hasNext()) {
                ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                ++count;
            }
            Assert.assertEquals((long)3L, (long)count);
            Scanner scanner = conn.createScanner(tableName, new Authorizations(new String[]{"A"}));
            scanner.fetchColumn(new Text("tx"), new Text("seq"));
            for (String row : new String[]{"99006", "59056", "19059"}) {
                scanner.setRange(new Range((CharSequence)row));
                Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                Assert.assertEquals((Object)"1", (Object)((Value)entry.getValue()).toString());
            }
            TreeSet<Text> splits = new TreeSet<Text>();
            splits.add(new Text("7"));
            splits.add(new Text("3"));
            conn.tableOperations().addSplits(tableName, splits);
            mutations.clear();
            ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab).setValue((CharSequence)"1")});
            cm3.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"Doe");
            cm3.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"2");
            mutations.add(cm3);
            ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"59056", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab)});
            cm4.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"Doe");
            cm4.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"1");
            mutations.add(cm4);
            ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"19059", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab).setValue((CharSequence)"2")});
            cm5.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"Doe");
            cm5.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"3");
            mutations.add(cm5);
            results = cw.write(mutations.iterator());
            int accepted = 0;
            int rejected = 0;
            while (results.hasNext()) {
                String[] result = (String[])results.next();
                if (new String(result.getMutation().getRow()).equals("99006")) {
                    Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                    ++accepted;
                    continue;
                }
                Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)result.getStatus());
                ++rejected;
            }
            Assert.assertEquals((String)"Expected only one accepted conditional mutation", (long)1L, (long)accepted);
            Assert.assertEquals((String)"Expected two rejected conditional mutations", (long)2L, (long)rejected);
            for (String row : new String[]{"59056", "19059"}) {
                scanner.setRange(new Range((CharSequence)row));
                Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                Assert.assertEquals((Object)"1", (Object)((Value)entry.getValue()).toString());
            }
            scanner.setRange(new Range((CharSequence)"99006"));
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
            Assert.assertEquals((Object)"2", (Object)((Value)entry.getValue()).toString());
            scanner.clearColumns();
            scanner.fetchColumn(new Text("name"), new Text("last"));
            entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
            Assert.assertEquals((Object)"Doe", (Object)((Value)entry.getValue()).toString());
        }
    }

    @Test
    public void testBigBatch() throws Exception {
        int i;
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        conn.tableOperations().addSplits(tableName, this.nss("2", "4", "6"));
        UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
        int num = 100;
        ArrayList<byte[]> rows = new ArrayList<byte[]>(num);
        ArrayList<ConditionalMutation> cml = new ArrayList<ConditionalMutation>(num);
        Random r = new Random();
        byte[] e = new byte[]{};
        for (i = 0; i < num; ++i) {
            rows.add(FastFormat.toZeroPaddedString((long)ConditionalWriterIT.abs(r.nextLong()), (int)16, (int)16, (byte[])e));
        }
        for (i = 0; i < num; ++i) {
            ConditionalMutation cm = new ConditionalMutation((byte[])rows.get(i), new Condition[]{new Condition((CharSequence)"meta", (CharSequence)"seq")});
            cm.put((CharSequence)"meta", (CharSequence)"seq", (CharSequence)"1");
            cm.put((CharSequence)"meta", (CharSequence)"tx", (CharSequence)UUID.randomUUID().toString());
            cml.add(cm);
        }
        try (ConditionalWriter cw = conn.createConditionalWriter(tableName, new ConditionalWriterConfig());){
            Iterator results = cw.write(cml.iterator());
            int count = 0;
            while (results.hasNext()) {
                ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                ++count;
            }
            Assert.assertEquals((String)"Did not receive the expected number of results", (long)num, (long)count);
            ArrayList<ConditionalMutation> cml2 = new ArrayList<ConditionalMutation>(num);
            for (int i2 = 0; i2 < num; ++i2) {
                ConditionalMutation cm = new ConditionalMutation((byte[])rows.get(i2), new Condition[]{new Condition((CharSequence)"meta", (CharSequence)"seq").setValue((CharSequence)"1")});
                cm.put((CharSequence)"meta", (CharSequence)"seq", (CharSequence)"2");
                cm.put((CharSequence)"meta", (CharSequence)"tx", (CharSequence)UUID.randomUUID().toString());
                cml2.add(cm);
            }
            count = 0;
            results = cw.write(cml2.iterator());
            while (results.hasNext()) {
                ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                ++count;
            }
            Assert.assertEquals((String)"Did not receive the expected number of results", (long)num, (long)count);
        }
    }

    @Test
    public void testBatchErrors() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        conn.tableOperations().addConstraint(tableName, AlphaNumKeyConstraint.class.getName());
        conn.tableOperations().clone(tableName, tableName + "_clone", true, new HashMap(), new HashSet());
        conn.securityOperations().changeUserAuthorizations(ConditionalWriterIT.getAdminPrincipal(), new Authorizations(new String[]{"A", "B"}));
        ColumnVisibility cvaob = new ColumnVisibility("A|B");
        ColumnVisibility cvaab = new ColumnVisibility("A&B");
        switch (new Random().nextInt(3)) {
            case 1: {
                conn.tableOperations().addSplits(tableName, this.nss("6"));
                break;
            }
            case 2: {
                conn.tableOperations().addSplits(tableName, this.nss("2", "95"));
            }
        }
        ArrayList<ConditionalMutation> mutations = new ArrayList<ConditionalMutation>();
        ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvaob)});
        cm0.put((CharSequence)"name+", (CharSequence)"last", cvaob, (CharSequence)"doe");
        cm0.put((CharSequence)"name", (CharSequence)"first", cvaob, (CharSequence)"john");
        cm0.put((CharSequence)"tx", (CharSequence)"seq", cvaob, (CharSequence)"1");
        mutations.add(cm0);
        ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"59056", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvaab)});
        cm1.put((CharSequence)"name", (CharSequence)"last", cvaab, (CharSequence)"doe");
        cm1.put((CharSequence)"name", (CharSequence)"first", cvaab, (CharSequence)"jane");
        cm1.put((CharSequence)"tx", (CharSequence)"seq", cvaab, (CharSequence)"1");
        mutations.add(cm1);
        ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"19059", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvaob)});
        cm2.put((CharSequence)"name", (CharSequence)"last", cvaob, (CharSequence)"doe");
        cm2.put((CharSequence)"name", (CharSequence)"first", cvaob, (CharSequence)"jack");
        cm2.put((CharSequence)"tx", (CharSequence)"seq", cvaob, (CharSequence)"1");
        mutations.add(cm2);
        ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"90909", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvaob).setValue((CharSequence)"1")});
        cm3.put((CharSequence)"name", (CharSequence)"last", cvaob, (CharSequence)"doe");
        cm3.put((CharSequence)"name", (CharSequence)"first", cvaob, (CharSequence)"john");
        cm3.put((CharSequence)"tx", (CharSequence)"seq", cvaob, (CharSequence)"2");
        mutations.add(cm3);
        try (ConditionalWriter cw = conn.createConditionalWriter(tableName, new ConditionalWriterConfig().setAuthorizations(new Authorizations(new String[]{"A"})));){
            Iterator results = cw.write(mutations.iterator());
            HashSet<String> rows = new HashSet<String>();
            while (results.hasNext()) {
                ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                String row = new String(result.getMutation().getRow());
                if (row.equals("19059")) {
                    Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                } else if (row.equals("59056")) {
                    Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)result.getStatus());
                } else if (row.equals("99006")) {
                    Assert.assertEquals((Object)ConditionalWriter.Status.VIOLATED, (Object)result.getStatus());
                } else if (row.equals("90909")) {
                    Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)result.getStatus());
                }
                rows.add(row);
            }
            Assert.assertEquals((long)4L, (long)rows.size());
            Scanner scanner = conn.createScanner(tableName, new Authorizations(new String[]{"A"}));
            scanner.fetchColumn(new Text("tx"), new Text("seq"));
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
            Assert.assertEquals((Object)"1", (Object)((Value)entry.getValue()).toString());
        }
    }

    @Test
    public void testSameRow() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        try (ConditionalWriter cw = conn.createConditionalWriter(tableName, new ConditionalWriterConfig());){
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
            cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
            cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm1).getStatus());
            ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
            cm2.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
            cm2.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"b");
            ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
            cm3.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
            cm3.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"c");
            ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
            cm4.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
            cm4.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"d");
            Iterator results = cw.write(Arrays.asList(cm2, cm3, cm4).iterator());
            int accepted = 0;
            int rejected = 0;
            int total = 0;
            while (results.hasNext()) {
                ConditionalWriter.Status status = ((ConditionalWriter.Result)results.next()).getStatus();
                if (status == ConditionalWriter.Status.ACCEPTED) {
                    ++accepted;
                }
                if (status == ConditionalWriter.Status.REJECTED) {
                    ++rejected;
                }
                ++total;
            }
            Assert.assertEquals((String)"Expected one accepted result", (long)1L, (long)accepted);
            Assert.assertEquals((String)"Expected two rejected results", (long)2L, (long)rejected);
            Assert.assertEquals((String)"Expected three total results", (long)3L, (long)total);
        }
    }

    @Test
    public void testThreads() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        Connector conn = this.getConnector();
        conn.tableOperations().create(tableName);
        Random rand = new Random();
        switch (rand.nextInt(3)) {
            case 1: {
                conn.tableOperations().addSplits(tableName, this.nss("4"));
                break;
            }
            case 2: {
                conn.tableOperations().addSplits(tableName, this.nss("3", "5"));
            }
        }
        try (ConditionalWriter cw = conn.createConditionalWriter(tableName, new ConditionalWriterConfig());){
            ArrayList<ByteSequence> rows = new ArrayList<ByteSequence>();
            for (int i = 0; i < 1000; ++i) {
                rows.add((ByteSequence)new ArrayByteSequence(FastFormat.toZeroPaddedString((long)ConditionalWriterIT.abs(rand.nextLong()), (int)16, (int)16, (byte[])new byte[0])));
            }
            ArrayList<ConditionalMutation> mutations = new ArrayList<ConditionalMutation>();
            for (ByteSequence row : rows) {
                mutations.add(new Stats(row).toMutation());
            }
            ArrayList<ArrayByteSequence> rows2 = new ArrayList<ArrayByteSequence>();
            Iterator results = cw.write(mutations.iterator());
            while (results.hasNext()) {
                ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                rows2.add(new ArrayByteSequence(result.getMutation().getRow()));
            }
            Collections.sort(rows);
            Collections.sort(rows2);
            Assert.assertEquals(rows, rows2);
            AtomicBoolean failed = new AtomicBoolean(false);
            ExecutorService tp = Executors.newFixedThreadPool(5);
            for (int i = 0; i < 5; ++i) {
                tp.submit(new MutatorTask(tableName, conn, rows, cw, failed));
            }
            tp.shutdown();
            while (!tp.isTerminated()) {
                tp.awaitTermination(1L, TimeUnit.MINUTES);
            }
            Assert.assertFalse((String)"A MutatorTask failed with an exception", (boolean)failed.get());
        }
        try (Scanner scanner = conn.createScanner(tableName, Authorizations.EMPTY);){
            RowIterator rowIter = new RowIterator((Iterable)scanner);
            while (rowIter.hasNext()) {
                Iterator row = rowIter.next();
                new Stats(row);
            }
        }
    }

    private SortedSet<Text> nss(String ... splits) {
        TreeSet<Text> ret = new TreeSet<Text>();
        for (String split : splits) {
            ret.add(new Text(split));
        }
        return ret;
    }

    @Test
    public void testSecurity() throws Exception {
        Connector conn = this.getConnector();
        String user = null;
        ClientConfiguration clientConf = cluster.getClientConfig();
        boolean saslEnabled = clientConf.hasSasl();
        ClusterUser user1 = this.getUser(0);
        user = user1.getPrincipal();
        if (saslEnabled) {
            conn.securityOperations().createLocalUser(user, null);
        } else {
            conn.securityOperations().createLocalUser(user, new PasswordToken((CharSequence)user1.getPassword()));
        }
        String[] tables = this.getUniqueNames(3);
        String table1 = tables[0];
        String table2 = tables[1];
        String table3 = tables[2];
        conn.tableOperations().create(table1);
        conn.tableOperations().create(table2);
        conn.tableOperations().create(table3);
        conn.securityOperations().grantTablePermission(user, table1, TablePermission.READ);
        conn.securityOperations().grantTablePermission(user, table2, TablePermission.WRITE);
        conn.securityOperations().grantTablePermission(user, table3, TablePermission.READ);
        conn.securityOperations().grantTablePermission(user, table3, TablePermission.WRITE);
        Connector conn2 = conn.getInstance().getConnector(user, user1.getToken());
        ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
        cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
        cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
        try (ConditionalWriter cw1 = conn2.createConditionalWriter(table1, new ConditionalWriterConfig());
             ConditionalWriter cw2 = conn2.createConditionalWriter(table2, new ConditionalWriterConfig());
             ConditionalWriter cw3 = conn2.createConditionalWriter(table3, new ConditionalWriterConfig());){
            ConditionalWriter.Status status2;
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw3.write(cm1).getStatus());
            try {
                status2 = cw1.write(cm1).getStatus();
                Assert.fail((String)("Expected exception writing conditional mutation to table the user doesn't have write access to, Got status: " + status2));
            }
            catch (AccumuloSecurityException status2) {
                // empty catch block
            }
            try {
                status2 = cw2.write(cm1).getStatus();
                Assert.fail((String)("Expected exception writing conditional mutation to table the user doesn't have read access to. Got status: " + status2));
            }
            catch (AccumuloSecurityException accumuloSecurityException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testTimeout() throws Exception {
        Connector conn = this.getConnector();
        String table = this.getUniqueNames(1)[0];
        conn.tableOperations().create(table);
        try (ConditionalWriter cw = conn.createConditionalWriter(table, new ConditionalWriterConfig().setTimeout(3L, TimeUnit.SECONDS));){
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
            cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
            cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
            Assert.assertEquals((Object)cw.write(cm1).getStatus(), (Object)ConditionalWriter.Status.ACCEPTED);
            IteratorSetting is = new IteratorSetting(5, SlowIterator.class);
            SlowIterator.setSeekSleepTime(is, 5000L);
            ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1").setIterators(new IteratorSetting[]{is})});
            cm2.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
            cm2.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"b");
            Assert.assertEquals((Object)cw.write(cm2).getStatus(), (Object)ConditionalWriter.Status.UNKNOWN);
            Scanner scanner = conn.createScanner(table, Authorizations.EMPTY);
            for (Map.Entry entry : scanner) {
                String cf = ((Key)entry.getKey()).getColumnFamilyData().toString();
                String cq = ((Key)entry.getKey()).getColumnQualifierData().toString();
                String val = ((Value)entry.getValue()).toString();
                if (cf.equals("tx") && cq.equals("seq")) {
                    Assert.assertEquals((String)"Unexpected value in tx:seq", (Object)"1", (Object)val);
                    continue;
                }
                if (cf.equals("data") && cq.equals("x")) {
                    Assert.assertEquals((String)"Unexpected value in data:x", (Object)"a", (Object)val);
                    continue;
                }
                Assert.fail((String)("Saw unexpected column family and qualifier: " + entry));
            }
            ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
            cm3.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
            cm3.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"b");
            Assert.assertEquals((Object)cw.write(cm3).getStatus(), (Object)ConditionalWriter.Status.ACCEPTED);
        }
    }

    @Test
    public void testDeleteTable() throws Exception {
        String table = this.getUniqueNames(1)[0];
        Connector conn = this.getConnector();
        try {
            conn.createConditionalWriter(table, new ConditionalWriterConfig());
            Assert.fail((String)"Creating conditional writer for table that doesn't exist should fail");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        conn.tableOperations().create(table);
        try (ConditionalWriter cw = conn.createConditionalWriter(table, new ConditionalWriterConfig());){
            conn.tableOperations().delete(table);
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
            cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
            cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
            ConditionalWriter.Result result = cw.write(cm1);
            try {
                ConditionalWriter.Status status = result.getStatus();
                Assert.fail((String)("Expected exception writing conditional mutation to deleted table. Got status: " + status));
            }
            catch (AccumuloException ae) {
                Assert.assertEquals(TableDeletedException.class, ae.getCause().getClass());
            }
        }
    }

    @Test
    public void testOffline() throws Exception {
        String table = this.getUniqueNames(1)[0];
        Connector conn = this.getConnector();
        conn.tableOperations().create(table);
        try (ConditionalWriter cw = conn.createConditionalWriter(table, new ConditionalWriterConfig());){
            conn.tableOperations().offline(table, true);
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
            cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
            cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
            ConditionalWriter.Result result = cw.write(cm1);
            try {
                ConditionalWriter.Status status = result.getStatus();
                Assert.fail((String)("Expected exception writing conditional mutation to offline table. Got status: " + status));
            }
            catch (AccumuloException ae) {
                Assert.assertEquals(TableOfflineException.class, ae.getCause().getClass());
            }
            try {
                conn.createConditionalWriter(table, new ConditionalWriterConfig());
                Assert.fail((String)"Expected exception creating conditional writer to offline table");
            }
            catch (TableOfflineException tableOfflineException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testError() throws Exception {
        String table = this.getUniqueNames(1)[0];
        Connector conn = this.getConnector();
        conn.tableOperations().create(table);
        try (ConditionalWriter cw = conn.createConditionalWriter(table, new ConditionalWriterConfig());){
            IteratorSetting iterSetting = new IteratorSetting(5, BadIterator.class);
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setIterators(new IteratorSetting[]{iterSetting})});
            cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
            cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
            ConditionalWriter.Result result = cw.write(cm1);
            try {
                ConditionalWriter.Status status = result.getStatus();
                Assert.fail((String)("Expected exception using iterator which throws an error, Got status: " + status));
            }
            catch (AccumuloException accumuloException) {
                // empty catch block
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoConditions() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException {
        String table = this.getUniqueNames(1)[0];
        Connector conn = this.getConnector();
        conn.tableOperations().create(table);
        try (ConditionalWriter cw = conn.createConditionalWriter(table, new ConditionalWriterConfig());){
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[0]);
            cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
            cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
            cw.write(cm1);
        }
    }

    @Test
    public void testTrace() throws Exception {
        Assume.assumeTrue((ConditionalWriterIT.getClusterType() == AccumuloClusterHarness.ClusterType.MINI ? 1 : 0) != 0);
        Process tracer = null;
        Connector conn = this.getConnector();
        AccumuloCluster cluster = ConditionalWriterIT.getCluster();
        MiniAccumuloClusterImpl mac = (MiniAccumuloClusterImpl)cluster;
        if (!conn.tableOperations().exists("trace")) {
            tracer = mac.exec(TraceServer.class, new String[0]);
            while (!conn.tableOperations().exists("trace")) {
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
        }
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        DistributedTrace.enable((String)"localhost", (String)"testTrace", (ClientConfiguration)mac.getClientConfig());
        UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        Span root = Trace.on((String)"traceTest");
        try (ConditionalWriter cw = conn.createConditionalWriter(tableName, new ConditionalWriterConfig());){
            ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
            cm0.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"doe");
            cm0.put((CharSequence)"name", (CharSequence)"first", (CharSequence)"john");
            cm0.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
            Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm0).getStatus());
            root.stop();
        }
        Scanner scanner = conn.createScanner("trace", Authorizations.EMPTY);
        scanner.setRange(new Range(new Text(Long.toHexString(root.traceId()))));
        block6: while (true) {
            final StringBuilder finalBuffer = new StringBuilder();
            int traceCount = TraceDump.printTrace((Scanner)scanner, (TraceDump.Printer)new TraceDump.Printer(){

                public void print(String line) {
                    try {
                        finalBuffer.append(line).append("\n");
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            String traceOutput = finalBuffer.toString();
            log.info("Trace output:" + traceOutput);
            if (traceCount > 0) {
                String[] parts;
                int lastPos = 0;
                for (String part : parts = "traceTest, startScan,startConditionalUpdate,conditionalUpdate,Check conditions,apply conditional mutations".split(",")) {
                    log.info("Looking in trace output for '" + part + "'");
                    int pos = traceOutput.indexOf(part);
                    if (-1 == pos) {
                        log.info("Trace output doesn't contain '" + part + "'");
                        Thread.sleep(1000L);
                        break block6;
                    }
                    Assert.assertTrue((String)("Did not find '" + part + "' in output"), (pos > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)("'" + part + "' occurred earlier than the previous element unexpectedly"), (pos > lastPos ? 1 : 0) != 0);
                    lastPos = pos;
                }
                break;
            }
            log.info("Ignoring trace output as traceCount not greater than zero: " + traceCount);
            Thread.sleep(1000L);
        }
        if (tracer != null) {
            tracer.destroy();
        }
    }

    private static class MutatorTask
    implements Runnable {
        String tableName;
        ArrayList<ByteSequence> rows;
        ConditionalWriter cw;
        Connector conn;
        AtomicBoolean failed;

        public MutatorTask(String tableName, Connector conn, ArrayList<ByteSequence> rows, ConditionalWriter cw, AtomicBoolean failed) {
            this.tableName = tableName;
            this.rows = rows;
            this.conn = conn;
            this.cw = cw;
            this.failed = failed;
        }

        @Override
        public void run() {
            try (IsolatedScanner scanner = new IsolatedScanner(this.conn.createScanner(this.tableName, Authorizations.EMPTY));){
                Random rand = new Random();
                for (int i = 0; i < 20; ++i) {
                    int numRows = rand.nextInt(10) + 1;
                    ArrayList<ByteSequence> changes = new ArrayList<ByteSequence>(numRows);
                    ArrayList<ConditionalMutation> mutations = new ArrayList<ConditionalMutation>();
                    for (int j = 0; j < numRows; ++j) {
                        changes.add(this.rows.get(rand.nextInt(this.rows.size())));
                    }
                    for (ByteSequence row : changes) {
                        scanner.setRange(new Range((CharSequence)row.toString()));
                        Stats stats = new Stats(scanner.iterator());
                        stats.set(rand.nextInt(10), rand.nextInt(Integer.MAX_VALUE));
                        mutations.add(stats.toMutation());
                    }
                    ArrayList<ArrayByteSequence> changed = new ArrayList<ArrayByteSequence>(numRows);
                    Iterator results = this.cw.write(mutations.iterator());
                    while (results.hasNext()) {
                        ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                        changed.add(new ArrayByteSequence(result.getMutation().getRow()));
                    }
                    Collections.sort(changes);
                    Collections.sort(changed);
                    Assert.assertEquals(changes, changed);
                }
            }
            catch (Exception e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                this.failed.set(true);
            }
        }
    }

    private static class Stats {
        ByteSequence row = null;
        int seq;
        long sum;
        int[] data = new int[10];

        public Stats(Iterator<Map.Entry<Key, Value>> iterator) {
            while (iterator.hasNext()) {
                Map.Entry<Key, Value> entry = iterator.next();
                if (this.row == null) {
                    this.row = entry.getKey().getRowData();
                }
                String cf = entry.getKey().getColumnFamilyData().toString();
                String cq = entry.getKey().getColumnQualifierData().toString();
                if (cf.equals("data")) {
                    this.data[Integer.parseInt((String)cq)] = Integer.parseInt(entry.getValue().toString());
                    continue;
                }
                if (!cf.equals("meta")) continue;
                if (cq.equals("sum")) {
                    this.sum = Long.parseLong(entry.getValue().toString());
                    continue;
                }
                if (!cq.equals("seq")) continue;
                this.seq = Integer.parseInt(entry.getValue().toString());
            }
            long sum2 = 0L;
            for (int datum : this.data) {
                sum2 += (long)datum;
            }
            Assert.assertEquals((long)sum2, (long)this.sum);
        }

        public Stats(ByteSequence row) {
            this.row = row;
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = 0;
            }
            this.seq = -1;
            this.sum = 0L;
        }

        void set(int index, int value) {
            this.sum -= (long)this.data[index];
            this.sum += (long)value;
            this.data[index] = value;
        }

        ConditionalMutation toMutation() {
            Condition cond = new Condition((CharSequence)"meta", (CharSequence)"seq");
            if (this.seq >= 0) {
                cond.setValue((CharSequence)(this.seq + ""));
            }
            ConditionalMutation cm = new ConditionalMutation(this.row, new Condition[]{cond});
            cm.put((CharSequence)"meta", (CharSequence)"seq", (CharSequence)(this.seq + 1 + ""));
            cm.put((CharSequence)"meta", (CharSequence)"sum", (CharSequence)(this.sum + ""));
            for (int i = 0; i < this.data.length; ++i) {
                cm.put((CharSequence)"data", (CharSequence)(i + ""), (CharSequence)(this.data[i] + ""));
            }
            return cm;
        }

        public String toString() {
            return this.row + " " + this.seq + " " + this.sum;
        }
    }

    public static class MultiplyingIterator
    extends WrappingIterator {
        long amount = 0L;

        public Value getTopValue() {
            Value val = super.getTopValue();
            long l = Long.parseLong(val.toString());
            String newVal = l * this.amount + "";
            return new Value(newVal.getBytes(StandardCharsets.UTF_8));
        }

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            this.setSource(source);
            this.amount = Long.parseLong(options.get("amount"));
        }
    }

    public static class AddingIterator
    extends WrappingIterator {
        long amount = 0L;

        public Value getTopValue() {
            Value val = super.getTopValue();
            long l = Long.parseLong(val.toString());
            String newVal = l + this.amount + "";
            return new Value(newVal.getBytes(StandardCharsets.UTF_8));
        }

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            this.setSource(source);
            this.amount = Long.parseLong(options.get("amount"));
        }
    }
}

