/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.constraints;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;

public class AlphaNumKeyConstraint
implements Constraint {
    static final short NON_ALPHA_NUM_ROW = 1;
    static final short NON_ALPHA_NUM_COLF = 2;
    static final short NON_ALPHA_NUM_COLQ = 3;
    static final String ROW_VIOLATION_MESSAGE = "Row was not alpha numeric";
    static final String COLF_VIOLATION_MESSAGE = "Column family was not alpha numeric";
    static final String COLQ_VIOLATION_MESSAGE = "Column qualifier was not alpha numeric";

    private boolean isAlphaNum(byte[] bytes) {
        for (byte b : bytes) {
            boolean ok;
            boolean bl = ok = b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57;
            if (ok) continue;
            return false;
        }
        return true;
    }

    private Set<Short> addViolation(Set<Short> violations, short violation) {
        if (violations == null) {
            violations = new LinkedHashSet<Short>();
            violations.add(violation);
        } else if (!violations.contains(violation)) {
            violations.add(violation);
        }
        return violations;
    }

    public List<Short> check(Constraint.Environment env, Mutation mutation) {
        Set<Short> violations = null;
        if (!this.isAlphaNum(mutation.getRow())) {
            violations = this.addViolation(violations, (short)1);
        }
        List updates = mutation.getUpdates();
        for (ColumnUpdate columnUpdate : updates) {
            if (!this.isAlphaNum(columnUpdate.getColumnFamily())) {
                violations = this.addViolation(violations, (short)2);
            }
            if (this.isAlphaNum(columnUpdate.getColumnQualifier())) continue;
            violations = this.addViolation(violations, (short)3);
        }
        return null == violations ? null : new ArrayList<Short>(violations);
    }

    public String getViolationDescription(short violationCode) {
        switch (violationCode) {
            case 1: {
                return ROW_VIOLATION_MESSAGE;
            }
            case 2: {
                return COLF_VIOLATION_MESSAGE;
            }
            case 3: {
                return COLQ_VIOLATION_MESSAGE;
            }
        }
        return null;
    }
}

