
# line 2 "sun_map_parse.y"
/*
 * Copyright (c) 1997-2006 Erez Zadok
 * Copyright (c) 2005 Daniel P. Ottavio
 * Copyright (c) 1990 Jan-Simon Pendry
 * Copyright (c) 1990 Imperial College of Science, Technology & Medicine
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Jan-Simon Pendry at Imperial College, London.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * File: am-utils/amd/sun_map_parse.y
 *
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#include <am_defs.h>
#include <amd.h>
#include <sun_map.h>


#define SUN_FSTYPE_STR  "fstype="


extern int sun_map_lex(void);
extern int sun_map_error(const char *);
extern void sun_map_tok_setbuff(const char *);
extern int sun_map_parse(void);

struct sun_entry *sun_map_parse_read(const char *);

static struct sun_list *sun_entry_list = NULL;
static struct sun_list *sun_opt_list = NULL;
static struct sun_list *sun_host_list = NULL;
static struct sun_list *sun_location_list = NULL;
static struct sun_list *mountpt_list = NULL;
static char *tmpFsType = NULL;


/*
 * Each get* function returns a pointer to the corresponding global
 * list structure.  If the structure is NULL than a new instance is
 * returned.
 */
static struct sun_list *get_sun_opt_list();
static struct sun_list *get_sun_host_list();
static struct sun_list *get_sun_location_list();
static struct sun_list *get_mountpt_list();
static struct sun_list *get_sun_entry_list();


# line 85 "sun_map_parse.y"
typedef union  {
  char strval[2048];
} YYSTYPE;
#ifdef __cplusplus
#  include <stdio.h>
#  include <yacc.h>
#endif	/* __cplusplus */ 
# define NEWLINE 257
# define COMMENT 258
# define WSPACE 259
# define WORD 260
#define sun_map_clearin sun_map_char = -1
#define sun_map_errok sun_map_errflag = 0
extern int sun_map_char;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif

/* __YYSCLASS defines the scoping/storage class for global objects
 * that are NOT renamed by the -p option.  By default these names
 * are going to be 'static' so that multi-definition errors
 * will not occur with multiple parsers.
 * If you want (unsupported) access to internal names you need
 * to define this to be null so it implies 'extern' scope.
 * This should not be used in conjunction with -p.
 */
#ifndef __YYSCLASS
# define __YYSCLASS static
#endif
YYSTYPE sun_map_lval;
__YYSCLASS YYSTYPE sun_map_val;
typedef int sun_map_tabelem;
# define YYERRCODE 256

# line 407 "sun_map_parse.y"


/*
 * Parse 'map_data' which is assumed to be a Sun-syle map.  If
 * successful a sun_entry is returned.
 *
 * The parser is designed to parse map entries with out the keys.  For
 * example the entry:
 *
 * usr -ro pluto:/usr/local
 *
 * should be passed to the parser as:
 *
 * -ro pluto:/usr/local
 *
 * The reason for this is that the Amd info services already strip off
 * the key when they read map info.
 */
struct sun_entry *
sun_map_parse_read(const char *map_data)
{
  struct sun_entry *retval = NULL;

  /* pass map_data to lex */
  sun_map_tok_setbuff(map_data);

  /* call yacc */
  sun_map_parse();

  if (sun_entry_list != NULL) {
    /* return the first Sun entry in the list */
    retval = (struct sun_entry*)sun_entry_list->first;
    sun_entry_list = NULL;
  }
  else {
    plog(XLOG_ERROR, "Sun map parser did not produce data structs.");
  }

  return retval;
}


static struct sun_list *
get_sun_entry_list(void)
{
  if (sun_entry_list == NULL) {
    sun_entry_list = CALLOC(struct sun_list);
  }
  return sun_entry_list;
}


static struct sun_list *
get_mountpt_list(void)
{
  if (mountpt_list == NULL) {
    mountpt_list = CALLOC(struct sun_list);
  }
  return mountpt_list;
}


static struct sun_list *
get_sun_location_list(void)
{
  if (sun_location_list == NULL) {
    sun_location_list = CALLOC(struct sun_list);
  }
  return sun_location_list;
}


static struct sun_list *
get_sun_host_list(void)
{
  if (sun_host_list == NULL) {
    sun_host_list = CALLOC(struct sun_list);
  }
  return sun_host_list;
}


static struct sun_list *
get_sun_opt_list(void)
{
  if (sun_opt_list == NULL) {
    sun_opt_list = CALLOC(struct sun_list);
  }
  return sun_opt_list;
}
__YYSCLASS sun_map_tabelem sun_map_exca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 29
# define YYLAST 230
__YYSCLASS sun_map_tabelem sun_map_act[]={

     8,    39,     8,    13,    13,    21,    34,    40,    37,    36,
    28,    25,    47,    13,    13,    13,    26,    31,    23,    22,
     5,    24,    10,    32,    29,    46,    19,    28,     9,     4,
     7,    12,     3,    16,    20,    27,    15,    11,    17,    18,
     6,     2,     1,     0,     0,     0,     0,     0,    30,    38,
     0,     0,    35,    33,     0,     0,     0,     0,     0,    44,
    43,    41,    42,     0,     0,     0,    45,     0,     0,     0,
    48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,    34,    14,     0,     0,     0,
     0,     0,     5,     0,     0,    14,    34,    14,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    26 };
__YYSCLASS sun_map_tabelem sun_map_pact[]={

   -45, -3000, -3000,   -43, -3000,  -237,  -237, -3000,  -255, -3000,
  -240,  -241,   -37,  -249,   -30,   -20, -3000, -3000,   -43,  -242,
   -21, -3000,   -55,  -251,  -252, -3000,   -44, -3000,  -253,  -254,
 -3000,   -54,  -255, -3000,   -13, -3000,  -243, -3000, -3000,  -255,
   -16, -3000, -3000, -3000, -3000,  -247, -3000,   -55, -3000 };
__YYSCLASS sun_map_tabelem sun_map_pgo[]={

     0,    42,    41,    32,    29,    40,    30,    26,    28,    37,
    22,    31,    36,    35,    34 };
__YYSCLASS sun_map_tabelem sun_map_r1[]={

     0,     1,     2,     2,     4,     4,     4,     3,     3,     5,
     5,     5,     5,     8,     8,     9,     9,     6,     6,    10,
    10,    11,    11,    12,    12,    13,     7,     7,    14 };
__YYSCLASS sun_map_tabelem sun_map_r2[]={

     0,     2,     4,     2,     2,     4,     6,     2,     4,     3,
     9,     3,     9,     2,     6,     7,    13,     2,     6,     7,
     5,     2,     6,     3,     5,     7,     2,     6,     3 };
__YYSCLASS sun_map_tabelem sun_map_chk[]={

 -3000,    -1,    -2,    -3,    -4,   257,    -5,    -6,    45,    -8,
   -10,    -9,   -11,    58,   260,   -12,    -4,    -3,    -3,    -7,
   -14,   260,   259,   259,    58,   260,   259,   -13,    40,    44,
    -4,   259,    44,    -6,   260,    -8,   260,   260,   -10,    45,
   260,   -11,    -6,    -8,    -7,    -7,    41,   259,   -10 };
__YYSCLASS sun_map_tabelem sun_map_def[]={

     0,    -2,     1,     0,     3,     7,     4,     9,     0,    11,
    17,    13,     0,     0,    23,    21,     2,     8,     5,     0,
    26,    28,     0,     0,     0,    20,     0,    24,     0,     0,
     6,     0,     0,    18,    23,    14,     0,    19,    15,     0,
     0,    22,    10,    12,    27,     0,    25,     0,    16 };
typedef struct { char *t_name; int t_val; } sun_map_toktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

__YYSCLASS sun_map_toktype sun_map_toks[] =
{
	"NEWLINE",	257,
	"COMMENT",	258,
	"WSPACE",	259,
	"WORD",	260,
	"-unknown-",	-1	/* ends search */
};

__YYSCLASS char * sun_map_reds[] =
{
	"-no such reduction-",
	"amap : file",
	"file : new_lines entries",
	"file : entries",
	"entries : entry",
	"entries : entry new_lines",
	"entries : entry new_lines entries",
	"new_lines : NEWLINE",
	"new_lines : NEWLINE new_lines",
	"entry : locations",
	"entry : '-' options WSPACE locations",
	"entry : mountpoints",
	"entry : '-' options WSPACE mountpoints",
	"mountpoints : mountpoint",
	"mountpoints : mountpoint WSPACE mountpoints",
	"mountpoint : WORD WSPACE location",
	"mountpoint : WORD WSPACE '-' options WSPACE location",
	"locations : location",
	"locations : location WSPACE locations",
	"location : hosts ':' WORD",
	"location : ':' WORD",
	"hosts : host",
	"hosts : host ',' hosts",
	"host : WORD",
	"host : WORD weight",
	"weight : '(' WORD ')'",
	"options : option",
	"options : option ',' options",
	"option : WORD",
};
#endif /* YYDEBUG */
#define YYFLAG  (-3000)
/* @(#) $Revision: 70.7 $ */    

/*
** Skeleton parser driver for yacc output
*/

#if defined(NLS) && !defined(NL_SETN)
#include <msgbuf.h>
#endif

#ifndef nl_msg
#define nl_msg(i,s) (s)
#endif

/*
** yacc user known macros and defines
*/
#define YYERROR		goto sun_map_errlab

#ifndef __RUNTIME_YYMAXDEPTH
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#else
#define YYACCEPT	{free_stacks(); return(0);}
#define YYABORT		{free_stacks(); return(1);}
#endif

#define YYBACKUP( newtoken, newvalue )\
{\
	if ( sun_map_char >= 0 || ( sun_map_r2[ sun_map_tmp ] >> 1 ) != 1 )\
	{\
		sun_map_error( (nl_msg(30001,"syntax error - cannot backup")) );\
		goto sun_map_errlab;\
	}\
	sun_map_char = newtoken;\
	sun_map_state = *sun_map_ps;\
	sun_map_lval = newvalue;\
	goto sun_map_newstate;\
}
#define YYRECOVERING()	(!!sun_map_errflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/

#ifdef YYREENTRANT
__thread int sun_map_debug;		/* set to 1 to get debugging */
#else
int sun_map_debug;			/* set to 1 to get debugging */
#endif

/*
** driver internal defines
*/
/* define for YYFLAG now generated by yacc program. */
/*#define YYFLAG		(FLAGVAL)*/

/*
** global variables used by the parser
*/
# ifndef __RUNTIME_YYMAXDEPTH

#   ifdef YYREENTRANT
__thread __YYSCLASS YYSTYPE sun_map_v[ YYMAXDEPTH ];  /* value stack */
__thread __YYSCLASS int sun_map_s[ YYMAXDEPTH ];      /* state stack */
#   else
__YYSCLASS YYSTYPE sun_map_v[ YYMAXDEPTH ];           /* value stack */
__YYSCLASS int sun_map_s[ YYMAXDEPTH ];               /* state stack */
#   endif

# else

#  ifdef YYREENTRANT
__thread __YYSCLASS YYSTYPE *sun_map_v;               /* pointer to malloc'ed stack st
value stack */
__thread __YYSCLASS int *sun_map_s;                   /* pointer to malloc'ed stack st
ack */
#  else
__YYSCLASS YYSTYPE *sun_map_v;                        /* pointer to malloc'ed value st
ack */
__YYSCLASS int *sun_map_s;                            /* pointer to malloc'ed stack stack */
#  endif

#if defined(__STDC__) || defined (__cplusplus)
#include <stdlib.h>
#else
	extern char *malloc();
	extern char *realloc();
	extern void free();
#endif /* __STDC__ or __cplusplus */


static int allocate_stacks(); 
static void free_stacks();
# ifndef YYINCREMENT
# define YYINCREMENT (YYMAXDEPTH/2) + 10
# endif
# endif	/* __RUNTIME_YYMAXDEPTH */
long  sun_map_maxdepth = YYMAXDEPTH;


#ifdef YYREENTRANT

__thread __YYSCLASS YYSTYPE *sun_map_pv;      /* top of value stack */
__thread __YYSCLASS int *sun_map_ps;          /* top of state stack */

__thread __YYSCLASS int sun_map_state;        /* current state */
__thread __YYSCLASS int sun_map_tmp;          /* extra var (lasts between blocks) */

__thread int sun_map_nerrs;                   /* number of errors */
__thread __YYSCLASS int sun_map_errflag;      /* error recovery flag */
__thread int sun_map_char;                    /* current input token number */

__thread extern int sun_map_init_key;           /* init TLS data once */
extern int TLS_INIT; 

#else

__YYSCLASS YYSTYPE *sun_map_pv;               /* top of value stack */
__YYSCLASS int *sun_map_ps;                   /* top of state stack */

__YYSCLASS int sun_map_state;                 /* current state */
__YYSCLASS int sun_map_tmp;                   /* extra var (lasts between blocks) */

int sun_map_nerrs;                            /* number of errors */
__YYSCLASS int sun_map_errflag;               /* error recovery flag */
int sun_map_char;
#endif


/*
** sun_map_parse - return 0 if worked, 1 if syntax error not recovered from
l*/
int
sun_map_parse()
{
	register YYSTYPE *sun_map_pvt;	/* top of value stack for $vars */


        /*
        ** Initialize externals - sun_map_parse may be called more than once
        */

#ifdef YYREENTRANT
        if (sun_map_init_key != TLS_INIT)
        {
            sun_map_init_key = TLS_INIT; 
            sun_map_init_tls();
        }
#endif

	/*
	** Initialize externals - sun_map_parse may be called more than once
	*/
# ifdef __RUNTIME_YYMAXDEPTH
	if (allocate_stacks()) YYABORT;
# endif
	sun_map_pv = &sun_map_v[-1];
	sun_map_ps = &sun_map_s[-1];
	sun_map_state = 0;
	sun_map_tmp = 0;
	sun_map_nerrs = 0;
	sun_map_errflag = 0;
	sun_map_char = -1;

	goto sun_map_stack;
	{
		register YYSTYPE *sun_map__pv;	/* top of value stack */
		register int *sun_map__ps;		/* top of state stack */
		register int sun_map__state;		/* current state */
		register int  sun_map__n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	sun_map_newstate:
		sun_map__pv = sun_map_pv;
		sun_map__ps = sun_map_ps;
		sun_map__state = sun_map_state;
		goto sun_map__newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	sun_map_stack:
		sun_map__pv = sun_map_pv;
		sun_map__ps = sun_map_ps;
		sun_map__state = sun_map_state;

		/*
		** top of for (;;) loop while no reductions done
		*/
	sun_map__stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( sun_map_debug )
		{
			register int sun_map__i;

			printf( "State %d, token ", sun_map__state );
			if ( sun_map_char == 0 )
				printf( "end-of-file\n" );
			else if ( sun_map_char < 0 )
				printf( "-none-\n" );
			else
			{
				for ( sun_map__i = 0; sun_map_toks[sun_map__i].t_val >= 0;
					sun_map__i++ )
				{
					if ( sun_map_toks[sun_map__i].t_val == sun_map_char )
						break;
				}
				printf( "%s\n", sun_map_toks[sun_map__i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++sun_map__ps >= &sun_map_s[ sun_map_maxdepth ] )	/* room on stack? */
		{
# ifndef __RUNTIME_YYMAXDEPTH
			sun_map_error( (nl_msg(30002,"yacc stack overflow")) );
			YYABORT;
# else
			/* save old stack bases to recalculate pointers */
			YYSTYPE * sun_map_v_old = sun_map_v;
			int * sun_map_s_old = sun_map_s;
			sun_map_maxdepth += YYINCREMENT;
			sun_map_s = (int *) realloc(sun_map_s, sun_map_maxdepth * sizeof(int));
			sun_map_v = (YYSTYPE *) realloc(sun_map_v, sun_map_maxdepth * sizeof(YYSTYPE));
			if (sun_map_s==0 || sun_map_v==0) {
			    sun_map_error( (nl_msg(30002,"yacc stack overflow")) );
			    YYABORT;
			    }
			/* Reset pointers into stack */
			sun_map__ps = (sun_map__ps - sun_map_s_old) + sun_map_s;
			sun_map_ps = (sun_map_ps - sun_map_s_old) + sun_map_s;
			sun_map__pv = (sun_map__pv - sun_map_v_old) + sun_map_v;
			sun_map_pv = (sun_map_pv - sun_map_v_old) + sun_map_v;
# endif

		}
		*sun_map__ps = sun_map__state;
		*++sun_map__pv = sun_map_val;

		/*
		** we have a new state - find out what to do
		*/
	sun_map__newstate:
		if ( ( sun_map__n = sun_map_pact[ sun_map__state ] ) <= YYFLAG )
			goto sun_map_default;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		sun_map_tmp = sun_map_char < 0;
#endif
		if ( ( sun_map_char < 0 ) && ( ( sun_map_char = sun_map_lex() ) < 0 ) )
			sun_map_char = 0;		/* reached EOF */
#if YYDEBUG
		if ( sun_map_debug && sun_map_tmp )
		{
			register int sun_map__i;

			printf( "Received token " );
			if ( sun_map_char == 0 )
				printf( "end-of-file\n" );
			else if ( sun_map_char < 0 )
				printf( "-none-\n" );
			else
			{
				for ( sun_map__i = 0; sun_map_toks[sun_map__i].t_val >= 0;
					sun_map__i++ )
				{
					if ( sun_map_toks[sun_map__i].t_val == sun_map_char )
						break;
				}
				printf( "%s\n", sun_map_toks[sun_map__i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( sun_map__n += sun_map_char ) < 0 ) || ( sun_map__n >= YYLAST ) )
			goto sun_map_default;
		if ( sun_map_chk[ sun_map__n = sun_map_act[ sun_map__n ] ] == sun_map_char )	/*valid shift*/
		{
			sun_map_char = -1;
			sun_map_val = sun_map_lval;
			sun_map__state = sun_map__n;
			if ( sun_map_errflag > 0 )
				sun_map_errflag--;
			goto sun_map__stack;
		}

	sun_map_default:
		if ( ( sun_map__n = sun_map_def[ sun_map__state ] ) == -2 )
		{
#if YYDEBUG
			sun_map_tmp = sun_map_char < 0;
#endif
			if ( ( sun_map_char < 0 ) && ( ( sun_map_char = sun_map_lex() ) < 0 ) )
				sun_map_char = 0;		/* reached EOF */
#if YYDEBUG
			if ( sun_map_debug && sun_map_tmp )
			{
				register int sun_map__i;

				printf( "Received token " );
				if ( sun_map_char == 0 )
					printf( "end-of-file\n" );
				else if ( sun_map_char < 0 )
					printf( "-none-\n" );
				else
				{
					for ( sun_map__i = 0;
						sun_map_toks[sun_map__i].t_val >= 0;
						sun_map__i++ )
					{
						if ( sun_map_toks[sun_map__i].t_val
							== sun_map_char )
						{
							break;
						}
					}
					printf( "%s\n", sun_map_toks[sun_map__i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *sun_map_xi = sun_map_exca;

				while ( ( *sun_map_xi != -1 ) ||
					( sun_map_xi[1] != sun_map__state ) )
				{
					sun_map_xi += 2;
				}
				while ( ( *(sun_map_xi += 2) >= 0 ) &&
					( *sun_map_xi != sun_map_char ) )
					;
				if ( ( sun_map__n = sun_map_xi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( sun_map__n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( sun_map_errflag )
			{
			case 0:		/* new error */
				sun_map_error( (nl_msg(30003,"syntax error")) );
				sun_map_nerrs++;
				goto skip_init;
			sun_map_errlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				sun_map__pv = sun_map_pv;
				sun_map__ps = sun_map_ps;
				sun_map__state = sun_map_state;
				sun_map_nerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				sun_map_errflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( sun_map__ps >= sun_map_s )
				{
					sun_map__n = sun_map_pact[ *sun_map__ps ] + YYERRCODE;
					if ( sun_map__n >= 0 && sun_map__n < YYLAST &&
						sun_map_chk[sun_map_act[sun_map__n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						sun_map__state = sun_map_act[ sun_map__n ];
						goto sun_map__stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( sun_map_debug )
						printf( _POP_, *sun_map__ps,
							sun_map__ps[-1] );
#	undef _POP_
#endif
					sun_map__ps--;
					sun_map__pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( sun_map_debug )
				{
					register int sun_map__i;

					printf( "Error recovery discards " );
					if ( sun_map_char == 0 )
						printf( "token end-of-file\n" );
					else if ( sun_map_char < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( sun_map__i = 0;
							sun_map_toks[sun_map__i].t_val >= 0;
							sun_map__i++ )
						{
							if ( sun_map_toks[sun_map__i].t_val
								== sun_map_char )
							{
								break;
							}
						}
						printf( "token %s\n",
							sun_map_toks[sun_map__i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( sun_map_char == 0 )	/* reached EOF. quit */
					YYABORT;
				sun_map_char = -1;
				goto sun_map__newstate;
			}
		}/* end if ( sun_map__n == 0 ) */
		/*
		** reduction by production sun_map__n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( sun_map_debug )
			printf( "Reduce by (%d) \"%s\"\n",
				sun_map__n, sun_map_reds[ sun_map__n ] );
#endif
		sun_map_tmp = sun_map__n;			/* value to switch over */
		sun_map_pvt = sun_map__pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using sun_map__state here as temporary
		** register variable, but why not, if it works...
		** If sun_map_r2[ sun_map__n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto sun_map__stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int sun_map__len = sun_map_r2[ sun_map__n ];

			if ( !( sun_map__len & 01 ) )
			{
				sun_map__len >>= 1;
				sun_map_val = ( sun_map__pv -= sun_map__len )[1];	/* $$ = $1 */
				sun_map__state = sun_map_pgo[ sun_map__n = sun_map_r1[ sun_map__n ] ] +
					*( sun_map__ps -= sun_map__len ) + 1;
				if ( sun_map__state >= YYLAST ||
					sun_map_chk[ sun_map__state =
					sun_map_act[ sun_map__state ] ] != -sun_map__n )
				{
					sun_map__state = sun_map_act[ sun_map_pgo[ sun_map__n ] ];
				}
				goto sun_map__stack;
			}
			sun_map__len >>= 1;
			sun_map_val = ( sun_map__pv -= sun_map__len )[1];	/* $$ = $1 */
			sun_map__state = sun_map_pgo[ sun_map__n = sun_map_r1[ sun_map__n ] ] +
				*( sun_map__ps -= sun_map__len ) + 1;
			if ( sun_map__state >= YYLAST ||
				sun_map_chk[ sun_map__state = sun_map_act[ sun_map__state ] ] != -sun_map__n )
			{
				sun_map__state = sun_map_act[ sun_map_pgo[ sun_map__n ] ];
			}
		}
					/* save until reenter driver code */
		sun_map_state = sun_map__state;
		sun_map_ps = sun_map__ps;
		sun_map_pv = sun_map__pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( sun_map_tmp )
	{
		
case 9:
# line 110 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  /* allocate an entry */
  entry = CALLOC(struct sun_entry);

  /*
   * Assign the global location list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  entry->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

   /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
} break;
case 10:
# line 131 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  entry = CALLOC(struct sun_entry);

  /* An fstype may have been defined in the 'options'. */
  if (tmpFsType != NULL) {
    entry->fstype = tmpFsType;
    tmpFsType = NULL;
  }

  /*
   * Assign the global location list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  entry->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_opt_list();
  entry->opt_list = (struct sun_opt *)list->first;
  sun_opt_list = NULL;

  /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
} break;
case 11:
# line 166 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  /* allocate an entry */
  entry = CALLOC(struct sun_entry);

  /*
   * Assign the global mountpt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_mountpt_list() is called.
   */
  list = get_mountpt_list();
  entry->mountpt_list = (struct sun_mountpt *)list->first;
  mountpt_list = NULL;

  /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
} break;
case 12:
# line 187 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  /* allocate an entry */
  entry = CALLOC(struct sun_entry);

  /* An fstype may have been defined in the 'options'. */
  if (tmpFsType != NULL) {
    entry->fstype = tmpFsType;
    tmpFsType = NULL;
  }

  /*
   * Assign the global mountpt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_mountpt_list() is called.
   */
  list = get_mountpt_list();
  entry->mountpt_list = (struct sun_mountpt *)list->first;
  mountpt_list = NULL;

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_opt_list();
  entry->opt_list = (struct sun_opt *)list->first;
  sun_opt_list = NULL;

  /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
} break;
case 15:
# line 228 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_mountpt *mountpt;

  /* allocate a mountpt */
  mountpt = CALLOC(struct sun_mountpt);

  /*
   * Assign the global loaction list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  mountpt->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

  mountpt->path = strdup(sun_map_pvt[-2].strval);

  /* Add this mountpt to the mountpt list. */
  sun_list_add(get_mountpt_list(), (qelem *)mountpt);
} break;
case 16:
# line 251 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_mountpt *mountpt;

  /* allocate a mountpt */
  mountpt = CALLOC(struct sun_mountpt);

  /* An fstype may have been defined in the 'options'. */
  if (tmpFsType != NULL) {
    mountpt->fstype = tmpFsType;
    tmpFsType = NULL;
  }

  /*
   * Assign the global location list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  mountpt->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_opt_list();
  mountpt->opt_list = (struct sun_opt *)list->first;
  sun_opt_list = NULL;

  mountpt->path = strdup(sun_map_pvt[-5].strval);

  /* Add this mountpt to the mountpt list. */
  sun_list_add(get_mountpt_list(), (qelem *)mountpt);
} break;
case 19:
# line 294 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_location *location;

  /* allocate a new location */
  location = CALLOC(struct sun_location);

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_host_list();
  location->host_list = (struct sun_host *)list->first;
  sun_host_list = NULL;

  location->path = strdup(sun_map_pvt[-0].strval);

  /* Add this location to the location list. */
  sun_list_add(get_sun_location_list(), (qelem *)location);
} break;
case 20:
# line 317 "sun_map_parse.y"
{

  struct sun_location *location;

  /* allocate a new location */
  location = CALLOC(struct sun_location);

  location->path = strdup(sun_map_pvt[-0].strval);

  /* Add this location to the location list. */
  sun_list_add(get_sun_location_list(), (qelem *)location);
} break;
case 23:
# line 335 "sun_map_parse.y"
{

  /* allocate a new host */
  struct sun_host *host = CALLOC(struct sun_host);

  host->name = strdup(sun_map_pvt[-0].strval);

  /* Add this host to the host list. */
  sun_list_add(get_sun_host_list(),(qelem *)host);
} break;
case 24:
# line 346 "sun_map_parse.y"
{

  /*
   * It is assumed that the host for this rule was allocated by the
   * 'weight' rule and assigned to be the last host item on the host
   * list.
   */
  struct sun_host *host = (struct sun_host *)sun_host_list->last;

  host->name = strdup(sun_map_pvt[-1].strval);
} break;
case 25:
# line 359 "sun_map_parse.y"
{

  int val;
  /* allocate a new host */
  struct sun_host *host = CALLOC(struct sun_host);

  val = atoi(sun_map_pvt[-1].strval);

  host->weight = val;

  /* Add this host to the host list. */
  sun_list_add(get_sun_host_list(), (qelem *)host);
} break;
case 28:
# line 378 "sun_map_parse.y"
{

  char *type;

  /* check if this is an fstype option */
  if ((type = strstr(sun_map_pvt[-0].strval,SUN_FSTYPE_STR)) != NULL) {
    /* parse out the fs type from the Sun fstype keyword  */
    if ((type = type + strlen(SUN_FSTYPE_STR)) != NULL) {
      /*
       * This global fstype str will be assigned to the current being
       * parsed later in the parsing.
       */
      tmpFsType = strdup(type);
    }
  }
  else {
    /*
     * If it is not an fstype option allocate an opt struct and assign
     * the value.
     */
    struct sun_opt *opt = CALLOC(struct sun_opt);
    opt->str = strdup(sun_map_pvt[-0].strval);
    /* Add this opt to the opt list. */
    sun_list_add(get_sun_opt_list(), (qelem *)opt);
  }
} break;
	}
	goto sun_map_stack;		/* reset registers in driver code */
}

# ifdef __RUNTIME_YYMAXDEPTH

static int allocate_stacks() {
	/* allocate the sun_map_s and sun_map_v stacks */
	sun_map_s = (int *) malloc(sun_map_maxdepth * sizeof(int));
	sun_map_v = (YYSTYPE *) malloc(sun_map_maxdepth * sizeof(YYSTYPE));

	if (sun_map_s==0 || sun_map_v==0) {
	   sun_map_error( (nl_msg(30004,"unable to allocate space for yacc stacks")) );
	   return(1);
	   }
	else return(0);

}


static void free_stacks() {
	if (sun_map_s!=0) free((char *) sun_map_s);
	if (sun_map_v!=0) free((char *) sun_map_v);
}

# endif  /* defined(__RUNTIME_YYMAXDEPTH) */

