
# line 45 "conf_parse.y"
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#include <am_defs.h>
#include <amd.h>

extern char *conf_text;
extern int aconf_lineno;
extern int conf_lex(void);

static int conf_error(const char *s);
static int retval;
static char *header_section = NULL; /* start with no header section */

#define YYDEBUG 1

#define PARSE_DEBUG 0

#if PARSE_DEBUG
# define dprintf(f,s) fprintf(stderr, (f), aconf_lineno, (s))
# define amu_return(v)
#else /* not PARSE_DEBUG */
# define dprintf(f,s)
# define amu_return(v) return((v))
#endif /* not PARSE_DEBUG */


# line 73 "conf_parse.y"
typedef union  {
char *strtype;
} YYSTYPE;
#ifdef __cplusplus
#  include <stdio.h>
#  include <yacc.h>
#endif	/* __cplusplus */ 
# define LEFT_BRACKET 257
# define RIGHT_BRACKET 258
# define EQUAL 259
# define NEWLINE 260
# define NONWS_STRING 261
# define NONWSEQ_STRING 262
# define QUOTED_NONWSEQ_STRING 263
#define conf_clearin conf_char = -1
#define conf_errok conf_errflag = 0
extern int conf_char;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif

/* __YYSCLASS defines the scoping/storage class for global objects
 * that are NOT renamed by the -p option.  By default these names
 * are going to be 'static' so that multi-definition errors
 * will not occur with multiple parsers.
 * If you want (unsupported) access to internal names you need
 * to define this to be null so it implies 'extern' scope.
 * This should not be used in conjunction with -p.
 */
#ifndef __YYSCLASS
# define __YYSCLASS static
#endif
YYSTYPE conf_lval;
__YYSCLASS YYSTYPE conf_val;
typedef int conf_tabelem;
# define YYERRCODE 256

# line 148 "conf_parse.y"


static int
conf_error(const char *s)
{
  fprintf(stderr, "AMDCONF: %s on line %d (section %s)\n",
	  s, aconf_lineno,
	  (header_section ? header_section : "null"));
  exit(1);
  return 1;	/* to full compilers that insist on a return statement */
}
__YYSCLASS conf_tabelem conf_exca[] ={
-1, 0,
	260, 1,
	-2, 3,
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 17
# define YYLAST 30
__YYSCLASS conf_tabelem conf_act[]={

    21,    22,    23,    16,    15,    17,    27,    26,    25,    24,
     5,    19,    20,     9,    13,     6,     4,    14,     8,     7,
    10,     3,    11,    12,     2,     1,     0,     0,     0,    18 };
__YYSCLASS conf_tabelem conf_pact[]={

 -3000, -3000,  -250,  -244,  -244,  -250, -3000,  -244,  -257,  -256,
 -3000, -3000, -3000, -3000,  -257,  -248, -3000,  -246, -3000,  -261,
  -251,  -252,  -253,  -254, -3000, -3000, -3000, -3000 };
__YYSCLASS conf_tabelem conf_pgo[]={

     0,    25,    24,    16,    15,    21,    19,    18,    14,    17 };
__YYSCLASS conf_tabelem conf_r1[]={

     0,     2,     1,     5,     1,     3,     3,     4,     4,     6,
     7,     8,     8,     9,     9,     9,     9 };
__YYSCLASS conf_tabelem conf_r2[]={

     0,     1,     6,     1,     4,     2,     4,     2,     4,     4,
     9,     2,     4,     9,     9,     9,     2 };
__YYSCLASS conf_tabelem conf_chk[]={

 -3000,    -1,    -2,    -5,    -3,   260,    -4,    -6,    -7,   257,
    -4,    -3,    -4,    -8,    -9,   261,   260,   261,    -8,   259,
   258,   261,   262,   263,   260,   260,   260,   260 };
__YYSCLASS conf_tabelem conf_def[]={

    -2,    -2,     0,     0,     0,     5,     4,     7,     0,     0,
     2,     6,     8,     9,    11,     0,    16,     0,    12,     0,
     0,     0,     0,     0,    10,    13,    14,    15 };
typedef struct { char *t_name; int t_val; } conf_toktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

__YYSCLASS conf_toktype conf_toks[] =
{
	"LEFT_BRACKET",	257,
	"RIGHT_BRACKET",	258,
	"EQUAL",	259,
	"NEWLINE",	260,
	"NONWS_STRING",	261,
	"NONWSEQ_STRING",	262,
	"QUOTED_NONWSEQ_STRING",	263,
	"-unknown-",	-1	/* ends search */
};

__YYSCLASS char * conf_reds[] =
{
	"-no such reduction-",
	"file : /* empty */",
	"file : newlines map_sections",
	"file : /* empty */",
	"file : map_sections",
	"newlines : NEWLINE",
	"newlines : NEWLINE newlines",
	"map_sections : map_section",
	"map_sections : map_section map_sections",
	"map_section : sec_header kv_pairs",
	"sec_header : LEFT_BRACKET NONWS_STRING RIGHT_BRACKET NEWLINE",
	"kv_pairs : kv_pair",
	"kv_pairs : kv_pair kv_pairs",
	"kv_pair : NONWS_STRING EQUAL NONWS_STRING NEWLINE",
	"kv_pair : NONWS_STRING EQUAL NONWSEQ_STRING NEWLINE",
	"kv_pair : NONWS_STRING EQUAL QUOTED_NONWSEQ_STRING NEWLINE",
	"kv_pair : NEWLINE",
};
#endif /* YYDEBUG */
#define YYFLAG  (-3000)
/* @(#) $Revision: 70.7 $ */    

/*
** Skeleton parser driver for yacc output
*/

#if defined(NLS) && !defined(NL_SETN)
#include <msgbuf.h>
#endif

#ifndef nl_msg
#define nl_msg(i,s) (s)
#endif

/*
** yacc user known macros and defines
*/
#define YYERROR		goto conf_errlab

#ifndef __RUNTIME_YYMAXDEPTH
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#else
#define YYACCEPT	{free_stacks(); return(0);}
#define YYABORT		{free_stacks(); return(1);}
#endif

#define YYBACKUP( newtoken, newvalue )\
{\
	if ( conf_char >= 0 || ( conf_r2[ conf_tmp ] >> 1 ) != 1 )\
	{\
		conf_error( (nl_msg(30001,"syntax error - cannot backup")) );\
		goto conf_errlab;\
	}\
	conf_char = newtoken;\
	conf_state = *conf_ps;\
	conf_lval = newvalue;\
	goto conf_newstate;\
}
#define YYRECOVERING()	(!!conf_errflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/

#ifdef YYREENTRANT
__thread int conf_debug;		/* set to 1 to get debugging */
#else
int conf_debug;			/* set to 1 to get debugging */
#endif

/*
** driver internal defines
*/
/* define for YYFLAG now generated by yacc program. */
/*#define YYFLAG		(FLAGVAL)*/

/*
** global variables used by the parser
*/
# ifndef __RUNTIME_YYMAXDEPTH

#   ifdef YYREENTRANT
__thread __YYSCLASS YYSTYPE conf_v[ YYMAXDEPTH ];  /* value stack */
__thread __YYSCLASS int conf_s[ YYMAXDEPTH ];      /* state stack */
#   else
__YYSCLASS YYSTYPE conf_v[ YYMAXDEPTH ];           /* value stack */
__YYSCLASS int conf_s[ YYMAXDEPTH ];               /* state stack */
#   endif

# else

#  ifdef YYREENTRANT
__thread __YYSCLASS YYSTYPE *conf_v;               /* pointer to malloc'ed stack st
value stack */
__thread __YYSCLASS int *conf_s;                   /* pointer to malloc'ed stack st
ack */
#  else
__YYSCLASS YYSTYPE *conf_v;                        /* pointer to malloc'ed value st
ack */
__YYSCLASS int *conf_s;                            /* pointer to malloc'ed stack stack */
#  endif

#if defined(__STDC__) || defined (__cplusplus)
#include <stdlib.h>
#else
	extern char *malloc();
	extern char *realloc();
	extern void free();
#endif /* __STDC__ or __cplusplus */


static int allocate_stacks(); 
static void free_stacks();
# ifndef YYINCREMENT
# define YYINCREMENT (YYMAXDEPTH/2) + 10
# endif
# endif	/* __RUNTIME_YYMAXDEPTH */
long  conf_maxdepth = YYMAXDEPTH;


#ifdef YYREENTRANT

__thread __YYSCLASS YYSTYPE *conf_pv;      /* top of value stack */
__thread __YYSCLASS int *conf_ps;          /* top of state stack */

__thread __YYSCLASS int conf_state;        /* current state */
__thread __YYSCLASS int conf_tmp;          /* extra var (lasts between blocks) */

__thread int conf_nerrs;                   /* number of errors */
__thread __YYSCLASS int conf_errflag;      /* error recovery flag */
__thread int conf_char;                    /* current input token number */

__thread extern int conf_init_key;           /* init TLS data once */
extern int TLS_INIT; 

#else

__YYSCLASS YYSTYPE *conf_pv;               /* top of value stack */
__YYSCLASS int *conf_ps;                   /* top of state stack */

__YYSCLASS int conf_state;                 /* current state */
__YYSCLASS int conf_tmp;                   /* extra var (lasts between blocks) */

int conf_nerrs;                            /* number of errors */
__YYSCLASS int conf_errflag;               /* error recovery flag */
int conf_char;
#endif


/*
** conf_parse - return 0 if worked, 1 if syntax error not recovered from
l*/
int
conf_parse()
{
	register YYSTYPE *conf_pvt;	/* top of value stack for $vars */


        /*
        ** Initialize externals - conf_parse may be called more than once
        */

#ifdef YYREENTRANT
        if (conf_init_key != TLS_INIT)
        {
            conf_init_key = TLS_INIT; 
            conf_init_tls();
        }
#endif

	/*
	** Initialize externals - conf_parse may be called more than once
	*/
# ifdef __RUNTIME_YYMAXDEPTH
	if (allocate_stacks()) YYABORT;
# endif
	conf_pv = &conf_v[-1];
	conf_ps = &conf_s[-1];
	conf_state = 0;
	conf_tmp = 0;
	conf_nerrs = 0;
	conf_errflag = 0;
	conf_char = -1;

	goto conf_stack;
	{
		register YYSTYPE *conf__pv;	/* top of value stack */
		register int *conf__ps;		/* top of state stack */
		register int conf__state;		/* current state */
		register int  conf__n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	conf_newstate:
		conf__pv = conf_pv;
		conf__ps = conf_ps;
		conf__state = conf_state;
		goto conf__newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	conf_stack:
		conf__pv = conf_pv;
		conf__ps = conf_ps;
		conf__state = conf_state;

		/*
		** top of for (;;) loop while no reductions done
		*/
	conf__stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( conf_debug )
		{
			register int conf__i;

			printf( "State %d, token ", conf__state );
			if ( conf_char == 0 )
				printf( "end-of-file\n" );
			else if ( conf_char < 0 )
				printf( "-none-\n" );
			else
			{
				for ( conf__i = 0; conf_toks[conf__i].t_val >= 0;
					conf__i++ )
				{
					if ( conf_toks[conf__i].t_val == conf_char )
						break;
				}
				printf( "%s\n", conf_toks[conf__i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++conf__ps >= &conf_s[ conf_maxdepth ] )	/* room on stack? */
		{
# ifndef __RUNTIME_YYMAXDEPTH
			conf_error( (nl_msg(30002,"yacc stack overflow")) );
			YYABORT;
# else
			/* save old stack bases to recalculate pointers */
			YYSTYPE * conf_v_old = conf_v;
			int * conf_s_old = conf_s;
			conf_maxdepth += YYINCREMENT;
			conf_s = (int *) realloc(conf_s, conf_maxdepth * sizeof(int));
			conf_v = (YYSTYPE *) realloc(conf_v, conf_maxdepth * sizeof(YYSTYPE));
			if (conf_s==0 || conf_v==0) {
			    conf_error( (nl_msg(30002,"yacc stack overflow")) );
			    YYABORT;
			    }
			/* Reset pointers into stack */
			conf__ps = (conf__ps - conf_s_old) + conf_s;
			conf_ps = (conf_ps - conf_s_old) + conf_s;
			conf__pv = (conf__pv - conf_v_old) + conf_v;
			conf_pv = (conf_pv - conf_v_old) + conf_v;
# endif

		}
		*conf__ps = conf__state;
		*++conf__pv = conf_val;

		/*
		** we have a new state - find out what to do
		*/
	conf__newstate:
		if ( ( conf__n = conf_pact[ conf__state ] ) <= YYFLAG )
			goto conf_default;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		conf_tmp = conf_char < 0;
#endif
		if ( ( conf_char < 0 ) && ( ( conf_char = conf_lex() ) < 0 ) )
			conf_char = 0;		/* reached EOF */
#if YYDEBUG
		if ( conf_debug && conf_tmp )
		{
			register int conf__i;

			printf( "Received token " );
			if ( conf_char == 0 )
				printf( "end-of-file\n" );
			else if ( conf_char < 0 )
				printf( "-none-\n" );
			else
			{
				for ( conf__i = 0; conf_toks[conf__i].t_val >= 0;
					conf__i++ )
				{
					if ( conf_toks[conf__i].t_val == conf_char )
						break;
				}
				printf( "%s\n", conf_toks[conf__i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( conf__n += conf_char ) < 0 ) || ( conf__n >= YYLAST ) )
			goto conf_default;
		if ( conf_chk[ conf__n = conf_act[ conf__n ] ] == conf_char )	/*valid shift*/
		{
			conf_char = -1;
			conf_val = conf_lval;
			conf__state = conf__n;
			if ( conf_errflag > 0 )
				conf_errflag--;
			goto conf__stack;
		}

	conf_default:
		if ( ( conf__n = conf_def[ conf__state ] ) == -2 )
		{
#if YYDEBUG
			conf_tmp = conf_char < 0;
#endif
			if ( ( conf_char < 0 ) && ( ( conf_char = conf_lex() ) < 0 ) )
				conf_char = 0;		/* reached EOF */
#if YYDEBUG
			if ( conf_debug && conf_tmp )
			{
				register int conf__i;

				printf( "Received token " );
				if ( conf_char == 0 )
					printf( "end-of-file\n" );
				else if ( conf_char < 0 )
					printf( "-none-\n" );
				else
				{
					for ( conf__i = 0;
						conf_toks[conf__i].t_val >= 0;
						conf__i++ )
					{
						if ( conf_toks[conf__i].t_val
							== conf_char )
						{
							break;
						}
					}
					printf( "%s\n", conf_toks[conf__i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *conf_xi = conf_exca;

				while ( ( *conf_xi != -1 ) ||
					( conf_xi[1] != conf__state ) )
				{
					conf_xi += 2;
				}
				while ( ( *(conf_xi += 2) >= 0 ) &&
					( *conf_xi != conf_char ) )
					;
				if ( ( conf__n = conf_xi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( conf__n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( conf_errflag )
			{
			case 0:		/* new error */
				conf_error( (nl_msg(30003,"syntax error")) );
				conf_nerrs++;
				goto skip_init;
			conf_errlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				conf__pv = conf_pv;
				conf__ps = conf_ps;
				conf__state = conf_state;
				conf_nerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				conf_errflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( conf__ps >= conf_s )
				{
					conf__n = conf_pact[ *conf__ps ] + YYERRCODE;
					if ( conf__n >= 0 && conf__n < YYLAST &&
						conf_chk[conf_act[conf__n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						conf__state = conf_act[ conf__n ];
						goto conf__stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( conf_debug )
						printf( _POP_, *conf__ps,
							conf__ps[-1] );
#	undef _POP_
#endif
					conf__ps--;
					conf__pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( conf_debug )
				{
					register int conf__i;

					printf( "Error recovery discards " );
					if ( conf_char == 0 )
						printf( "token end-of-file\n" );
					else if ( conf_char < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( conf__i = 0;
							conf_toks[conf__i].t_val >= 0;
							conf__i++ )
						{
							if ( conf_toks[conf__i].t_val
								== conf_char )
							{
								break;
							}
						}
						printf( "token %s\n",
							conf_toks[conf__i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( conf_char == 0 )	/* reached EOF. quit */
					YYABORT;
				conf_char = -1;
				goto conf__newstate;
			}
		}/* end if ( conf__n == 0 ) */
		/*
		** reduction by production conf__n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( conf_debug )
			printf( "Reduce by (%d) \"%s\"\n",
				conf__n, conf_reds[ conf__n ] );
#endif
		conf_tmp = conf__n;			/* value to switch over */
		conf_pvt = conf__pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using conf__state here as temporary
		** register variable, but why not, if it works...
		** If conf_r2[ conf__n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto conf__stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int conf__len = conf_r2[ conf__n ];

			if ( !( conf__len & 01 ) )
			{
				conf__len >>= 1;
				conf_val = ( conf__pv -= conf__len )[1];	/* $$ = $1 */
				conf__state = conf_pgo[ conf__n = conf_r1[ conf__n ] ] +
					*( conf__ps -= conf__len ) + 1;
				if ( conf__state >= YYLAST ||
					conf_chk[ conf__state =
					conf_act[ conf__state ] ] != -conf__n )
				{
					conf__state = conf_act[ conf_pgo[ conf__n ] ];
				}
				goto conf__stack;
			}
			conf__len >>= 1;
			conf_val = ( conf__pv -= conf__len )[1];	/* $$ = $1 */
			conf__state = conf_pgo[ conf__n = conf_r1[ conf__n ] ] +
				*( conf__ps -= conf__len ) + 1;
			if ( conf__state >= YYLAST ||
				conf_chk[ conf__state = conf_act[ conf__state ] ] != -conf__n )
			{
				conf__state = conf_act[ conf_pgo[ conf__n ] ];
			}
		}
					/* save until reenter driver code */
		conf_state = conf__state;
		conf_ps = conf__ps;
		conf_pv = conf__pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( conf_tmp )
	{
		
case 1:
# line 87 "conf_parse.y"
{ conf_debug = PARSE_DEBUG; } break;
case 3:
# line 88 "conf_parse.y"
{ conf_debug = PARSE_DEBUG; } break;
case 10:
# line 103 "conf_parse.y"
{
		  if (conf_debug)
		    fprintf(stderr, "sec_header1 = \"%s\"\n", conf_pvt[-2].strtype);
		  header_section = conf_pvt[-2].strtype;
		} break;
case 13:
# line 115 "conf_parse.y"
{
		  if (conf_debug)
		    fprintf(stderr,"parse1: key=\"%s\", val=\"%s\"\n", conf_pvt[-3].strtype, conf_pvt[-1].strtype);
		  retval = set_conf_kv(header_section, conf_pvt[-3].strtype, conf_pvt[-1].strtype);
		  if (retval != 0) {
		    conf_error("syntax error");
		    YYABORT;
		  }
		} break;
case 14:
# line 125 "conf_parse.y"
{
		  if (conf_debug)
		    fprintf(stderr,"parse2: key=\"%s\", val=\"%s\"\n", conf_pvt[-3].strtype, conf_pvt[-1].strtype);
		  retval = set_conf_kv(header_section, conf_pvt[-3].strtype, conf_pvt[-1].strtype);
		  if (retval != 0) {
		    conf_error("syntax error");
		    YYABORT;
		  }
		} break;
case 15:
# line 135 "conf_parse.y"
{
		  if (conf_debug)
		    fprintf(stderr,"parse3: key=\"%s\", val=\"%s\"\n", conf_pvt[-3].strtype, conf_pvt[-1].strtype);
		  retval = set_conf_kv(header_section, conf_pvt[-3].strtype, conf_pvt[-1].strtype);
		  if (retval != 0) {
		    conf_error("syntax error");
		    YYABORT;
		  }
		} break;
	}
	goto conf_stack;		/* reset registers in driver code */
}

# ifdef __RUNTIME_YYMAXDEPTH

static int allocate_stacks() {
	/* allocate the conf_s and conf_v stacks */
	conf_s = (int *) malloc(conf_maxdepth * sizeof(int));
	conf_v = (YYSTYPE *) malloc(conf_maxdepth * sizeof(YYSTYPE));

	if (conf_s==0 || conf_v==0) {
	   conf_error( (nl_msg(30004,"unable to allocate space for yacc stacks")) );
	   return(1);
	   }
	else return(0);

}


static void free_stacks() {
	if (conf_s!=0) free((char *) conf_s);
	if (conf_v!=0) free((char *) conf_v);
}

# endif  /* defined(__RUNTIME_YYMAXDEPTH) */

