#include <stdlib.h>
#ifndef lint
#if 0
static char sun_map_sccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93";
#else
#if defined(__NetBSD__) && defined(__IDSTRING)
__IDSTRING(sun_map_rcsid, "$NetBSD: skeleton.c,v 1.25 2003/08/07 11:17:54 agc Exp $");
#endif /* __NetBSD__ && __IDSTRING */
#endif /* 0 */
#endif /* lint */
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX sun_map_lex()
#define YYEMPTY -1
#define sun_map_clearin (sun_map_char=(YYEMPTY))
#define sun_map_errok (sun_map_errflag=0)
#define YYRECOVERING (sun_map_errflag!=0)
#define YYPREFIX "sun_map_"
#line 2 "sun_map_parse.y"
/*
 * Copyright (c) 1997-2006 Erez Zadok
 * Copyright (c) 2005 Daniel P. Ottavio
 * Copyright (c) 1990 Jan-Simon Pendry
 * Copyright (c) 1990 Imperial College of Science, Technology & Medicine
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Jan-Simon Pendry at Imperial College, London.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * File: am-utils/amd/sun_map_parse.y
 *
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#include <am_defs.h>
#include <amd.h>
#include <sun_map.h>


#define SUN_FSTYPE_STR  "fstype="


extern int sun_map_lex(void);
extern int sun_map_error(const char *);
extern void sun_map_tok_setbuff(const char *);
extern int sun_map_parse(void);

struct sun_entry *sun_map_parse_read(const char *);

static struct sun_list *sun_entry_list = NULL;
static struct sun_list *sun_opt_list = NULL;
static struct sun_list *sun_host_list = NULL;
static struct sun_list *sun_location_list = NULL;
static struct sun_list *mountpt_list = NULL;
static char *tmpFsType = NULL;


/*
 * Each get* function returns a pointer to the corresponding global
 * list structure.  If the structure is NULL than a new instance is
 * returned.
 */
static struct sun_list *get_sun_opt_list();
static struct sun_list *get_sun_host_list();
static struct sun_list *get_sun_location_list();
static struct sun_list *get_mountpt_list();
static struct sun_list *get_sun_entry_list();

#line 85 "sun_map_parse.y"
typedef union {
  char strval[2048];
} YYSTYPE;
#line 107 "sun_map_parse.c"
#define NEWLINE 257
#define COMMENT 258
#define WSPACE 259
#define WORD 260
#define YYERRCODE 256
const short sun_map_lhs[] = {                                        -1,
    0,    1,    1,    3,    3,    3,    2,    2,    4,    4,
    4,    4,    7,    7,    8,    8,    5,    5,    9,    9,
   10,   10,   11,   11,   12,    6,    6,   13,
};
const short sun_map_len[] = {                                         2,
    1,    2,    1,    1,    2,    3,    1,    2,    1,    4,
    1,    4,    1,    3,    3,    6,    1,    3,    3,    2,
    1,    3,    1,    2,    3,    1,    3,    1,
};
const short sun_map_defred[] = {                                      0,
    0,    0,    0,    0,    0,    1,    0,    3,    0,    9,
   11,    0,    0,    0,    0,    8,    0,    0,   24,   28,
    0,    0,   20,    2,    0,    0,    0,    0,    0,    0,
    0,   15,    0,    0,    0,    6,    0,   14,   18,   19,
   22,    0,   25,   10,   12,   27,    0,   16,
};
const short sun_map_dgoto[] = {                                       5,
    6,    7,    8,    9,   10,   21,   11,   12,   13,   14,
   15,   19,   22,
};
const short sun_map_sindex[] = {                                    -39,
 -244,  -40, -243, -234,    0,    0,  -38,    0, -244,    0,
    0, -232, -231,  -28,  -13,    0,  -37, -228,    0,    0,
 -226,  -10,    0,    0,  -38, -225,  -54, -224, -223,   -2,
 -243,    0,   -1,  -53, -243,    0, -218,    0,    0,    0,
    0, -217,    0,    0,    0,    0,  -54,    0,
};
const short sun_map_rindex[] = {                                      0,
    1,  -34,    0,    0,    0,    0,    0,    0,   43,    0,
    0,    2,    3,    0,  -14,    0,    0,    0,    0,    0,
    0, -232,    0,    0,   45,    0,    0,    0,    0,  -34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
};
const short sun_map_gindex[] = {                                      0,
    0,   13,    4,    0,   -9,  -19,  -11,    0,   -8,   18,
    0,    0,    0,
};
#define YYTABLESIZE 261
const short sun_map_table[] = {                                      18,
    7,   13,   17,    4,    4,    3,    3,   31,   32,   23,
   24,   42,    1,   16,   38,   46,   20,   39,    4,    4,
    4,   25,   45,   23,   44,   23,   26,   27,   36,   28,
   29,   33,   34,   35,   37,   40,   30,   18,   48,   43,
   17,   47,    4,   21,    5,    7,   41,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    7,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   30,    2,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    1,   17,    0,
    2,    2,   30,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   13,   17,
    7,
};
const short sun_map_check[] = {                                      40,
    0,    0,    0,   58,   58,   45,   45,   45,   17,   44,
    7,   31,  257,    1,   26,   35,  260,   27,   58,   58,
   58,    9,   34,   58,   34,  260,  259,  259,   25,   58,
   44,  260,  259,   44,  260,  260,  260,   40,   47,   41,
  259,  259,    0,   58,    0,   45,   29,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  260,  260,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  259,   -1,
  260,  260,  260,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  257,
  260,
};
#define YYFINAL 5
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 260
#if YYDEBUG
const char * const sun_map_name[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'('","')'",0,0,"','","'-'",0,0,0,0,0,0,0,0,0,0,0,0,"':'",0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"NEWLINE",
"COMMENT","WSPACE","WORD",
};
const char * const sun_map_rule[] = {
"$accept : amap",
"amap : file",
"file : new_lines entries",
"file : entries",
"entries : entry",
"entries : entry new_lines",
"entries : entry new_lines entries",
"new_lines : NEWLINE",
"new_lines : NEWLINE new_lines",
"entry : locations",
"entry : '-' options WSPACE locations",
"entry : mountpoints",
"entry : '-' options WSPACE mountpoints",
"mountpoints : mountpoint",
"mountpoints : mountpoint WSPACE mountpoints",
"mountpoint : WORD WSPACE location",
"mountpoint : WORD WSPACE '-' options WSPACE location",
"locations : location",
"locations : location WSPACE locations",
"location : hosts ':' WORD",
"location : ':' WORD",
"hosts : host",
"hosts : host ',' hosts",
"host : WORD",
"host : WORD weight",
"weight : '(' WORD ')'",
"options : option",
"options : option ',' options",
"option : WORD",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
int sun_map_debug;
int sun_map_nerrs;
int sun_map_errflag;
int sun_map_char;
short *sun_map_ssp;
YYSTYPE *sun_map_vsp;
YYSTYPE sun_map_val;
YYSTYPE sun_map_lval;
short *sun_map_ss;
short *sun_map_sslim;
YYSTYPE *sun_map_vs;
int sun_map_stacksize;
int sun_map_parse(void);
#line 408 "sun_map_parse.y"

/*
 * Parse 'map_data' which is assumed to be a Sun-syle map.  If
 * successful a sun_entry is returned.
 *
 * The parser is designed to parse map entries with out the keys.  For
 * example the entry:
 *
 * usr -ro pluto:/usr/local
 *
 * should be passed to the parser as:
 *
 * -ro pluto:/usr/local
 *
 * The reason for this is that the Amd info services already strip off
 * the key when they read map info.
 */
struct sun_entry *
sun_map_parse_read(const char *map_data)
{
  struct sun_entry *retval = NULL;

  /* pass map_data to lex */
  sun_map_tok_setbuff(map_data);

  /* call yacc */
  sun_map_parse();

  if (sun_entry_list != NULL) {
    /* return the first Sun entry in the list */
    retval = (struct sun_entry*)sun_entry_list->first;
    sun_entry_list = NULL;
  }
  else {
    plog(XLOG_ERROR, "Sun map parser did not produce data structs.");
  }

  return retval;
}


static struct sun_list *
get_sun_entry_list(void)
{
  if (sun_entry_list == NULL) {
    sun_entry_list = CALLOC(struct sun_list);
  }
  return sun_entry_list;
}


static struct sun_list *
get_mountpt_list(void)
{
  if (mountpt_list == NULL) {
    mountpt_list = CALLOC(struct sun_list);
  }
  return mountpt_list;
}


static struct sun_list *
get_sun_location_list(void)
{
  if (sun_location_list == NULL) {
    sun_location_list = CALLOC(struct sun_list);
  }
  return sun_location_list;
}


static struct sun_list *
get_sun_host_list(void)
{
  if (sun_host_list == NULL) {
    sun_host_list = CALLOC(struct sun_list);
  }
  return sun_host_list;
}


static struct sun_list *
get_sun_opt_list(void)
{
  if (sun_opt_list == NULL) {
    sun_opt_list = CALLOC(struct sun_list);
  }
  return sun_opt_list;
}
#line 374 "sun_map_parse.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int sun_map_growstack(void);
static int sun_map_growstack(void)
{
    int newsize, i;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = sun_map_stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    i = sun_map_ssp - sun_map_ss;
    if ((newss = (short *)realloc(sun_map_ss, newsize * sizeof *newss)) == NULL)
        return -1;
    sun_map_ss = newss;
    sun_map_ssp = newss + i;
    if ((newvs = (YYSTYPE *)realloc(sun_map_vs, newsize * sizeof *newvs)) == NULL)
        return -1;
    sun_map_vs = newvs;
    sun_map_vsp = newvs + i;
    sun_map_stacksize = newsize;
    sun_map_sslim = sun_map_ss + newsize - 1;
    return 0;
}

#define YYABORT goto sun_map_abort
#define YYREJECT goto sun_map_abort
#define YYACCEPT goto sun_map_accept
#define YYERROR goto sun_map_errlab
int
sun_map_parse(void)
{
    int sun_map_m, sun_map_n, sun_map_state;
#if YYDEBUG
    const char *sun_map_s;

    if ((sun_map_s = getenv("YYDEBUG")) != NULL)
    {
        sun_map_n = *sun_map_s;
        if (sun_map_n >= '0' && sun_map_n <= '9')
            sun_map_debug = sun_map_n - '0';
    }
#endif

    sun_map_nerrs = 0;
    sun_map_errflag = 0;
    sun_map_char = (-1);

    if (sun_map_ss == NULL && sun_map_growstack()) goto sun_map_overflow;
    sun_map_ssp = sun_map_ss;
    sun_map_vsp = sun_map_vs;
    *sun_map_ssp = sun_map_state = 0;

sun_map_loop:
    if ((sun_map_n = sun_map_defred[sun_map_state]) != 0) goto sun_map_reduce;
    if (sun_map_char < 0)
    {
        if ((sun_map_char = sun_map_lex()) < 0) sun_map_char = 0;
#if YYDEBUG
        if (sun_map_debug)
        {
            sun_map_s = 0;
            if (sun_map_char <= YYMAXTOKEN) sun_map_s = sun_map_name[sun_map_char];
            if (!sun_map_s) sun_map_s = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, sun_map_state, sun_map_char, sun_map_s);
        }
#endif
    }
    if ((sun_map_n = sun_map_sindex[sun_map_state]) && (sun_map_n += sun_map_char) >= 0 &&
            sun_map_n <= YYTABLESIZE && sun_map_check[sun_map_n] == sun_map_char)
    {
#if YYDEBUG
        if (sun_map_debug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, sun_map_state, sun_map_table[sun_map_n]);
#endif
        if (sun_map_ssp >= sun_map_sslim && sun_map_growstack())
        {
            goto sun_map_overflow;
        }
        *++sun_map_ssp = sun_map_state = sun_map_table[sun_map_n];
        *++sun_map_vsp = sun_map_lval;
        sun_map_char = (-1);
        if (sun_map_errflag > 0)  --sun_map_errflag;
        goto sun_map_loop;
    }
    if ((sun_map_n = sun_map_rindex[sun_map_state]) && (sun_map_n += sun_map_char) >= 0 &&
            sun_map_n <= YYTABLESIZE && sun_map_check[sun_map_n] == sun_map_char)
    {
        sun_map_n = sun_map_table[sun_map_n];
        goto sun_map_reduce;
    }
    if (sun_map_errflag) goto sun_map_inrecovery;
    goto sun_map_newerror;
sun_map_newerror:
    sun_map_error("syntax error");
    goto sun_map_errlab;
sun_map_errlab:
    ++sun_map_nerrs;
sun_map_inrecovery:
    if (sun_map_errflag < 3)
    {
        sun_map_errflag = 3;
        for (;;)
        {
            if ((sun_map_n = sun_map_sindex[*sun_map_ssp]) && (sun_map_n += YYERRCODE) >= 0 &&
                    sun_map_n <= YYTABLESIZE && sun_map_check[sun_map_n] == YYERRCODE)
            {
#if YYDEBUG
                if (sun_map_debug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *sun_map_ssp, sun_map_table[sun_map_n]);
#endif
                if (sun_map_ssp >= sun_map_sslim && sun_map_growstack())
                {
                    goto sun_map_overflow;
                }
                *++sun_map_ssp = sun_map_state = sun_map_table[sun_map_n];
                *++sun_map_vsp = sun_map_lval;
                goto sun_map_loop;
            }
            else
            {
#if YYDEBUG
                if (sun_map_debug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *sun_map_ssp);
#endif
                if (sun_map_ssp <= sun_map_ss) goto sun_map_abort;
                --sun_map_ssp;
                --sun_map_vsp;
            }
        }
    }
    else
    {
        if (sun_map_char == 0) goto sun_map_abort;
#if YYDEBUG
        if (sun_map_debug)
        {
            sun_map_s = 0;
            if (sun_map_char <= YYMAXTOKEN) sun_map_s = sun_map_name[sun_map_char];
            if (!sun_map_s) sun_map_s = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, sun_map_state, sun_map_char, sun_map_s);
        }
#endif
        sun_map_char = (-1);
        goto sun_map_loop;
    }
sun_map_reduce:
#if YYDEBUG
    if (sun_map_debug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, sun_map_state, sun_map_n, sun_map_rule[sun_map_n]);
#endif
    sun_map_m = sun_map_len[sun_map_n];
    sun_map_val = sun_map_vsp[1-sun_map_m];
    switch (sun_map_n)
    {
case 9:
#line 110 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  /* allocate an entry */
  entry = CALLOC(struct sun_entry);

  /*
   * Assign the global location list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  entry->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

   /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
}
break;
case 10:
#line 131 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  entry = CALLOC(struct sun_entry);

  /* An fstype may have been defined in the 'options'. */
  if (tmpFsType != NULL) {
    entry->fstype = tmpFsType;
    tmpFsType = NULL;
  }

  /*
   * Assign the global location list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  entry->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_opt_list();
  entry->opt_list = (struct sun_opt *)list->first;
  sun_opt_list = NULL;

  /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
}
break;
case 11:
#line 166 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  /* allocate an entry */
  entry = CALLOC(struct sun_entry);

  /*
   * Assign the global mountpt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_mountpt_list() is called.
   */
  list = get_mountpt_list();
  entry->mountpt_list = (struct sun_mountpt *)list->first;
  mountpt_list = NULL;

  /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
}
break;
case 12:
#line 187 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  /* allocate an entry */
  entry = CALLOC(struct sun_entry);

  /* An fstype may have been defined in the 'options'. */
  if (tmpFsType != NULL) {
    entry->fstype = tmpFsType;
    tmpFsType = NULL;
  }

  /*
   * Assign the global mountpt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_mountpt_list() is called.
   */
  list = get_mountpt_list();
  entry->mountpt_list = (struct sun_mountpt *)list->first;
  mountpt_list = NULL;

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_opt_list();
  entry->opt_list = (struct sun_opt *)list->first;
  sun_opt_list = NULL;

  /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
}
break;
case 15:
#line 228 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_mountpt *mountpt;

  /* allocate a mountpt */
  mountpt = CALLOC(struct sun_mountpt);

  /*
   * Assign the global loaction list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  mountpt->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

  mountpt->path = strdup(sun_map_vsp[-2].strval);

  /* Add this mountpt to the mountpt list. */
  sun_list_add(get_mountpt_list(), (qelem *)mountpt);
}
break;
case 16:
#line 251 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_mountpt *mountpt;

  /* allocate a mountpt */
  mountpt = CALLOC(struct sun_mountpt);

  /* An fstype may have been defined in the 'options'. */
  if (tmpFsType != NULL) {
    mountpt->fstype = tmpFsType;
    tmpFsType = NULL;
  }

  /*
   * Assign the global location list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  mountpt->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_opt_list();
  mountpt->opt_list = (struct sun_opt *)list->first;
  sun_opt_list = NULL;

  mountpt->path = strdup(sun_map_vsp[-5].strval);

  /* Add this mountpt to the mountpt list. */
  sun_list_add(get_mountpt_list(), (qelem *)mountpt);
}
break;
case 19:
#line 294 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_location *location;

  /* allocate a new location */
  location = CALLOC(struct sun_location);

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_host_list();
  location->host_list = (struct sun_host *)list->first;
  sun_host_list = NULL;

  location->path = strdup(sun_map_vsp[0].strval);

  /* Add this location to the location list. */
  sun_list_add(get_sun_location_list(), (qelem *)location);
}
break;
case 20:
#line 317 "sun_map_parse.y"
{

  struct sun_location *location;

  /* allocate a new location */
  location = CALLOC(struct sun_location);

  location->path = strdup(sun_map_vsp[0].strval);

  /* Add this location to the location list. */
  sun_list_add(get_sun_location_list(), (qelem *)location);
}
break;
case 23:
#line 335 "sun_map_parse.y"
{

  /* allocate a new host */
  struct sun_host *host = CALLOC(struct sun_host);

  host->name = strdup(sun_map_vsp[0].strval);

  /* Add this host to the host list. */
  sun_list_add(get_sun_host_list(),(qelem *)host);
}
break;
case 24:
#line 346 "sun_map_parse.y"
{

  /*
   * It is assumed that the host for this rule was allocated by the
   * 'weight' rule and assigned to be the last host item on the host
   * list.
   */
  struct sun_host *host = (struct sun_host *)sun_host_list->last;

  host->name = strdup(sun_map_vsp[-1].strval);
}
break;
case 25:
#line 359 "sun_map_parse.y"
{

  int val;
  /* allocate a new host */
  struct sun_host *host = CALLOC(struct sun_host);

  val = atoi(sun_map_vsp[-1].strval);

  host->weight = val;

  /* Add this host to the host list. */
  sun_list_add(get_sun_host_list(), (qelem *)host);
}
break;
case 28:
#line 378 "sun_map_parse.y"
{

  char *type;

  /* check if this is an fstype option */
  if ((type = strstr(sun_map_vsp[0].strval,SUN_FSTYPE_STR)) != NULL) {
    /* parse out the fs type from the Sun fstype keyword  */
    if ((type = type + strlen(SUN_FSTYPE_STR)) != NULL) {
      /*
       * This global fstype str will be assigned to the current being
       * parsed later in the parsing.
       */
      tmpFsType = strdup(type);
    }
  }
  else {
    /*
     * If it is not an fstype option allocate an opt struct and assign
     * the value.
     */
    struct sun_opt *opt = CALLOC(struct sun_opt);
    opt->str = strdup(sun_map_vsp[0].strval);
    /* Add this opt to the opt list. */
    sun_list_add(get_sun_opt_list(), (qelem *)opt);
  }
}
break;
#line 837 "sun_map_parse.c"
    }
    sun_map_ssp -= sun_map_m;
    sun_map_state = *sun_map_ssp;
    sun_map_vsp -= sun_map_m;
    sun_map_m = sun_map_lhs[sun_map_n];
    if (sun_map_state == 0 && sun_map_m == 0)
    {
#if YYDEBUG
        if (sun_map_debug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        sun_map_state = YYFINAL;
        *++sun_map_ssp = YYFINAL;
        *++sun_map_vsp = sun_map_val;
        if (sun_map_char < 0)
        {
            if ((sun_map_char = sun_map_lex()) < 0) sun_map_char = 0;
#if YYDEBUG
            if (sun_map_debug)
            {
                sun_map_s = 0;
                if (sun_map_char <= YYMAXTOKEN) sun_map_s = sun_map_name[sun_map_char];
                if (!sun_map_s) sun_map_s = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, sun_map_char, sun_map_s);
            }
#endif
        }
        if (sun_map_char == 0) goto sun_map_accept;
        goto sun_map_loop;
    }
    if ((sun_map_n = sun_map_gindex[sun_map_m]) && (sun_map_n += sun_map_state) >= 0 &&
            sun_map_n <= YYTABLESIZE && sun_map_check[sun_map_n] == sun_map_state)
        sun_map_state = sun_map_table[sun_map_n];
    else
        sun_map_state = sun_map_dgoto[sun_map_m];
#if YYDEBUG
    if (sun_map_debug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *sun_map_ssp, sun_map_state);
#endif
    if (sun_map_ssp >= sun_map_sslim && sun_map_growstack())
    {
        goto sun_map_overflow;
    }
    *++sun_map_ssp = sun_map_state;
    *++sun_map_vsp = sun_map_val;
    goto sun_map_loop;
sun_map_overflow:
    sun_map_error("yacc stack overflow");
sun_map_abort:
    return (1);
sun_map_accept:
    return (0);
}
