dnl ######################################################################
dnl check the correct way to dereference the address part of the nfs fhandle
AC_DEFUN(AC_CHECK_NFS_FH_DREF,
[
AC_CACHE_CHECK(nfs file-handle address dereferencing style,
ac_cv_nfs_fh_dref_style,
[
# select the correct nfs address dereferencing style
case "${host_os}" in
	svr4* | sysv4* |solaris2* | sunos5* )
		ac_cv_nfs_fh_dref_style=svr4 ;;
	sunos4* )
		ac_cv_nfs_fh_dref_style=sunos4 ;;
changequote(<<, >>)dnl
	freebsd2.[2-9]* | freebsd3* | bsdi3* | netbsd* )
changequote([, ])dnl
		# bsdi3, freebsd-2.2 (and later), netbsd, etc.
		# changed the type of the
		# filehandle in nfs_args from nfsv2fh_t to u_char.
		ac_cv_nfs_fh_dref_style=freebsd22 ;;
	bsd44* | bsdi2* | freebsd* | netbsd* | openbsd* )
		ac_cv_nfs_fh_dref_style=bsd44 ;;
	hpux* )
		ac_cv_nfs_fh_dref_style=hpux ;;
	irix* )
		ac_cv_nfs_fh_dref_style=irix ;;
	linux* )
		ac_cv_nfs_fh_dref_style=linux ;;
	aix* )
		ac_cv_nfs_fh_dref_style=aix3 ;;
	isc3 )
		ac_cv_nfs_fh_dref_style=isc3 ;;
	osf* )
		ac_cv_nfs_fh_dref_style=osf ;;
	* )
		ac_cv_nfs_fh_dref_style=default ;;
esac
])
am_utils_nfs_fh_dref=$srcdir"/conf/fh_dref/fh_dref_"$ac_cv_nfs_fh_dref_style".h"
AC_SUBST_FILE(am_utils_nfs_fh_dref)
])
dnl ======================================================================
