dnl ######################################################################
dnl check if system has NFS protocol headers
AC_DEFUN(AC_CHECK_NFS_PROT_HEADERS,
[
AC_CACHE_CHECK(location of NFS protocol header files,
ac_cv_nfs_prot_headers,
[
# select the correct style for mounting filesystems
case "${host_os_name}" in
	irix5* )
			ac_cv_nfs_prot_headers=irix5 ;;
	irix6* )
			ac_cv_nfs_prot_headers=irix6 ;;
	sunos4* )
			ac_cv_nfs_prot_headers=sunos4 ;;
	sunos5* | solaris* )
			ac_cv_nfs_prot_headers=sunos5 ;;
	bsdi2* )
			ac_cv_nfs_prot_headers=bsdi2 ;;
	bsdi3* )
			ac_cv_nfs_prot_headers=bsdi3 ;;
	freebsd2* )
			ac_cv_nfs_prot_headers=freebsd2 ;;
	hpux* )
			ac_cv_nfs_prot_headers=hpux ;;
	aix4* )
			ac_cv_nfs_prot_headers=aix4 ;;
	aix* )
			ac_cv_nfs_prot_headers=aix3 ;;
	osf* )
			ac_cv_nfs_prot_headers=osf ;;
	svr4* | sysv4* )
			ac_cv_nfs_prot_headers=svr4 ;;
	* )
			ac_cv_nfs_prot_headers=default ;;
esac
])

# make sure correct header is linked in top build directory
am_utils_nfs_prot_file="amu_nfs_prot.h"
am_utils_link_files_src=${am_utils_link_files_src}conf/nfs_prot/nfs_prot_${ac_cv_nfs_prot_headers}.h" "
am_utils_link_files_dst=${am_utils_link_files_dst}${am_utils_nfs_prot_file}" "

# define the name of the header to be included for other M4 macros
AC_DEFINE_UNQUOTED(AMU_NFS_PROTOCOL_HEADER, "${srcdir}/conf/nfs_prot/nfs_prot_${ac_cv_nfs_prot_headers}.h")

# set headers in a macro for Makefile.am files to use (for dependencies)
AMU_NFS_PROT_HEADERS="../"$am_utils_nfs_prot_file
AC_SUBST(AMU_NFS_PROT_HEADERS)
])
dnl ======================================================================
