dnl ######################################################################
dnl check the correct printf-style type for the mount type in the mount()
dnl system call.
dnl If you change this one, you must also fix the check_mtype_type.m4.
AC_DEFUN(AC_CHECK_MTYPE_PRINTF_TYPE,
[
AC_CACHE_CHECK(printf string to print type field of mount() call,
ac_cv_mtype_printf_type,
[
# select the correct printf type
case "${host_os_name}" in
	linux* | mach* | bsdi1* | bsdi3* | 386bsd* | irix5* | irix6* | \
	hpux* | news4 |	riscos | solaris2* | sunos5* | svr4* | sysv4* | \
	sunos4* | xinu43 )
		ac_cv_mtype_printf_type="%s" ;;
	irix3 | isc3 )
		ac_cv_mtype_printf_type="0x%x" ;;
	* )
		ac_cv_mtype_printf_type="%d" ;;
esac
])
AC_DEFINE_UNQUOTED(MTYPE_PRINTF_TYPE, "$ac_cv_mtype_printf_type")
])
dnl ======================================================================
