/*
 * Copyright (c) 1997 Erez Zadok
 * Copyright (c) 1990 Jan-Simon Pendry
 * Copyright (c) 1990 Imperial College of Science, Technology & Medicine
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Jan-Simon Pendry at Imperial College, London.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      %W% (Berkeley) %G%
 *
 * $Id: nfs_prot_bsdi2.h,v 1.1 1996/01/13 23:23:39 ezk Exp ezk $
 *
 */

#ifndef _AMU_NFS_PROT_H
#define _AMU_NFS_PROT_H

/*
 * MACROS
 */

#define NFS_PORT 2049
#ifndef NFS_MAXDATA
# define NFS_MAXDATA 8192
#endif /* NFS_MAXDATA */
#define NFS_MAXPATHLEN 1024
#define NFS_MAXNAMLEN 255
#define NFS_FHSIZE 32
#define NFS_COOKIESIZE 4
#define	MNTPATHLEN 1024
#define	MNTNAMLEN 255

#define NFSMODE_FMT 0170000
#define NFSMODE_DIR 0040000
#define NFSMODE_CHR 0020000
#define NFSMODE_BLK 0060000
#define NFSMODE_REG 0100000
#define NFSMODE_LNK 0120000
#define NFSMODE_SOCK 0140000
#define NFSMODE_FIFO 0010000

#ifndef NFS_PROGRAM
# define NFS_PROGRAM ((u_long)100003)
#endif /* not NFS_PROGRAM */
#ifndef NFS_VERSION
# define NFS_VERSION ((u_long)2)
#endif /* not NFS_VERSION */

/*
 * BSD/OS 2.1 deparcated NFSPROC_ROOT and NFSPROC_WRITECACHE and set them
 * to NFSPROC_NOOP.
 * Since amd is its own NFS server, reinstate them.
 */
#if (NFSPROC_ROOT == NFSPROC_NOOP)
# undef NFSPROC_ROOT
# define NFSPROC_ROOT 3
#endif /* (NFSPROC_ROOT == NFSPROC_NOOP) */
#if (NFSPROC_WRITECACHE == NFSPROC_NOOP)
# undef NFSPROC_WRITECACHE
# define NFSPROC_WRITECACHE 7
#endif /* (NFSPROC_WRITECACHE == NFSPROC_NOOP) */

/* map field names */
#define ml_hostname ml_name
#define ml_directory ml_path
#define ml_next ml_nxt
#define gr_next g_next
#define gr_name g_name
#define ex_dir ex_name


/*
 * TYPEDEFS:
 */
typedef char *dirpath;
typedef char *filename;
typedef char *name;
typedef char *nfspath;
typedef char nfscookie[NFS_COOKIESIZE];
typedef nfstype ftype;
typedef enum nfsstat nfsstat;
typedef struct attrstat attrstat;
typedef struct createargs createargs;
typedef struct dirlist dirlist;
typedef struct diropargs diropargs;
typedef struct diropokres diropokres;
typedef struct diropres diropres;
typedef struct entry entry;
typedef struct exports *exports;
typedef struct exports exportnode;
typedef struct fattr fattr;
typedef struct fhstatus fhstatus;
typedef struct groups *groups;
typedef struct groups groupnode;
typedef struct linkargs linkargs;
typedef struct mountlist *mountlist;
typedef struct mountlist mountbody;
typedef struct nfs_fh nfs_fh;
typedef struct nfstime nfstime;
typedef struct readargs readargs;
typedef struct readdirargs readdirargs;
typedef struct readdirres readdirres;
typedef struct readlinkres readlinkres;
typedef struct readokres readokres;
typedef struct readres readres;
typedef struct renameargs renameargs;
typedef struct sattr sattr;
typedef struct sattrargs sattrargs;
typedef struct statfsokres statfsokres;
typedef struct statfsres statfsres;
typedef struct symlinkargs symlinkargs;
typedef struct writeargs writeargs;


/*
 * EXTERNALS:
 */

extern void * nfsproc_null_2(void *, CLIENT *);
extern attrstat * nfsproc_getattr_2(nfs_fh *, CLIENT *);
extern attrstat * nfsproc_setattr_2(sattrargs *, CLIENT *);
extern void * nfsproc_root_2(void *, CLIENT *);
extern diropres * nfsproc_lookup_2(diropargs *, CLIENT *);
extern readlinkres * nfsproc_readlink_2(nfs_fh *, CLIENT *);
extern readres * nfsproc_read_2(readargs *, CLIENT *);
extern void * nfsproc_writecache_2(void *, CLIENT *);
extern attrstat * nfsproc_write_2(writeargs *, CLIENT *);
extern diropres * nfsproc_create_2(createargs *, CLIENT *);
extern nfsstat * nfsproc_remove_2(diropargs *, CLIENT *);
extern nfsstat * nfsproc_rename_2(renameargs *, CLIENT *);
extern nfsstat * nfsproc_link_2(linkargs *, CLIENT *);
extern nfsstat * nfsproc_symlink_2(symlinkargs *, CLIENT *);
extern diropres * nfsproc_mkdir_2(createargs *, CLIENT *);
extern nfsstat * nfsproc_rmdir_2(diropargs *, CLIENT *);
extern readdirres * nfsproc_readdir_2(readdirargs *, CLIENT *);
extern statfsres * nfsproc_statfs_2(nfs_fh *, CLIENT *);

extern bool_t xdr_nfsstat(XDR *, nfsstat*);
extern bool_t xdr_ftype(XDR *, ftype*);
extern bool_t xdr_nfs_fh(XDR *, nfs_fh*);
extern bool_t xdr_nfstime(XDR *, nfstime*);
extern bool_t xdr_fattr(XDR *, fattr*);
extern bool_t xdr_sattr(XDR *, sattr*);
extern bool_t xdr_filename(XDR *, filename*);
extern bool_t xdr_nfspath(XDR *, nfspath*);
extern bool_t xdr_attrstat(XDR *, attrstat*);
extern bool_t xdr_sattrargs(XDR *, sattrargs*);
extern bool_t xdr_diropargs(XDR *, diropargs*);
extern bool_t xdr_diropokres(XDR *, diropokres*);
extern bool_t xdr_diropres(XDR *, diropres*);
extern bool_t xdr_readlinkres(XDR *, readlinkres*);
extern bool_t xdr_readargs(XDR *, readargs*);
extern bool_t xdr_readokres(XDR *, readokres*);
extern bool_t xdr_readres(XDR *, readres*);
extern bool_t xdr_writeargs(XDR *, writeargs*);
extern bool_t xdr_createargs(XDR *, createargs*);
extern bool_t xdr_renameargs(XDR *, renameargs*);
extern bool_t xdr_linkargs(XDR *, linkargs*);
extern bool_t xdr_symlinkargs(XDR *, symlinkargs*);
extern bool_t xdr_nfscookie(XDR *, nfscookie);
extern bool_t xdr_readdirargs(XDR *, readdirargs*);
extern bool_t xdr_entry(XDR *, entry*);
extern bool_t xdr_dirlist(XDR *, dirlist*);
extern bool_t xdr_readdirres(XDR *, readdirres*);
extern bool_t xdr_statfsokres(XDR *, statfsokres*);
extern bool_t xdr_statfsres(XDR *, statfsres*);


/*
 * ENUMS:
 */

/*
 * Use AMU_ prefixes so as to not conflict with #define's in <nfs/nfsv2.h>.
 * It is vital! that the AMU_* match one-to-one with the NFS_OK and NFSERR_*
 * codes listed in <nfs/nfsv2.h>.
 */
enum nfsstat {
	AMU_NFS_OK = 1,
	AMU_NFSERR_PERM = 1,
	AMU_NFSERR_NOENT = 2,
	AMU_NFSERR_IO = 5,
	AMU_NFSERR_NXIO = 6,
	AMU_NFSERR_ACCES = 13,
	AMU_NFSERR_EXIST = 17,
	AMU_NFSERR_NODEV = 19,
	AMU_NFSERR_NOTDIR = 20,
	AMU_NFSERR_ISDIR = 21,
	AMU_NFSERR_FBIG = 27,
	AMU_NFSERR_NOSPC = 28,
	AMU_NFSERR_ROFS = 30,
	AMU_NFSERR_NAMETOOLONG = 63,
	AMU_NFSERR_NOTEMPTY = 66,
	AMU_NFSERR_DQUOT = 69,
	AMU_NFSERR_STALE = 70,
	AMU_NFSERR_WFLUSH = 99
};


/*
 * STRUCTURES:
 */

struct nfs_fh {
  char data[NFS_FHSIZE];
};

struct nfstime {
  u_int seconds;
  u_int useconds;
};

struct fattr {
  ftype type;
  u_int mode;
  u_int nlink;
  u_int uid;
  u_int gid;
  u_int size;
  u_int blocksize;
  u_int rdev;
  u_int blocks;
  u_int fsid;
  u_int fileid;
  nfstime atime;
  nfstime mtime;
  nfstime ctime;
};

struct sattr {
  u_int mode;
  u_int uid;
  u_int gid;
  u_int size;
  nfstime atime;
  nfstime mtime;
};

struct attrstat {
  nfsstat status;
  union {
    fattr attributes;
  } attrstat_u;
};

struct sattrargs {
  nfs_fh file;
  sattr attributes;
};

struct diropargs {
  nfs_fh dir;
  filename name;
};

struct diropokres {
  nfs_fh file;
  fattr attributes;
};

struct diropres {
  nfsstat status;
  union {
    diropokres diropres;
  } diropres_u;
};

struct readlinkres {
  nfsstat status;
  union {
    nfspath data;
  } readlinkres_u;
};

struct readargs {
  nfs_fh file;
  u_int offset;
  u_int count;
  u_int totalcount;
};

struct readokres {
  fattr attributes;
  struct {
    u_int data_len;
    char *data_val;
  } data;
};

struct readres {
  nfsstat status;
  union {
    readokres reply;
  } readres_u;
};

struct writeargs {
  nfs_fh file;
  u_int beginoffset;
  u_int offset;
  u_int totalcount;
  struct {
    u_int data_len;
    char *data_val;
  } data;
};

struct createargs {
  diropargs where;
  sattr attributes;
};

struct renameargs {
  diropargs from;
  diropargs to;
};

struct linkargs {
  nfs_fh from;
  diropargs to;
};

struct symlinkargs {
  diropargs from;
  nfspath to;
  sattr attributes;
};

struct readdirargs {
  nfs_fh dir;
  nfscookie cookie;
  u_int count;
};

struct entry {
  u_int fileid;
  filename name;
  nfscookie cookie;
  struct entry *nextentry;
};

struct dirlist {
  entry *entries;
  bool_t eof;
};

struct readdirres {
  nfsstat status;
  union {
    dirlist reply;
  } readdirres_u;
};

struct statfsokres {
  u_int tsize;
  u_int bsize;
  u_int blocks;
  u_int bfree;
  u_int bavail;
};

struct statfsres {
  nfsstat status;
  union {
    statfsokres reply;
  } statfsres_u;
};

/****************************************************************************/
/*** XDR ADDITIONS                                                        ***/
/****************************************************************************/

struct exports {
	dirpath ex_dir;
	groups ex_groups;
	exports ex_next;
};

typedef char fhandle[NFS_FHSIZE];

struct fhstatus {
	u_int fhs_status;
	union {
		fhandle fhs_fhandle;
	} fhstatus_u;
};

struct groups {
	name gr_name;
	groups gr_next;
};

struct mountlist {
	name ml_hostname;
	dirpath ml_directory;
	mountlist ml_next;
};


/****************************************************************************/
/*** NFS ADDITIONS                                                        ***/
/****************************************************************************/

#ifndef MOUNTPROG
# define MOUNTPROG RPCPROG_MNT
#endif /* not MOUNTPROG */

#ifndef MOUNTVERS
# define MOUNTVERS RPCMNT_VER1
#endif /* not MOUNTVERS */

#ifndef MOUNTPROC_MNT
# define MOUNTPROC_MNT RPCMNT_MOUNT
#endif /* not MOUNTPROC_MNT */

#ifndef MOUNTPROC_UMNT
# define MOUNTPROC_UMNT RPCMNT_UMOUNT
#endif /* not MOUNTPROC_UMNT */

#ifndef MOUNTPROC_UMNTALL
# define MOUNTPROC_UMNTALL RPCMNT_UMNTALL
#endif /* not MOUNTPROC_UMNTALL */

#ifndef MOUNTPROC_EXPORT
# define MOUNTPROC_EXPORT RPCMNT_EXPORT
#endif /* not MOUNTPROC_EXPORT */


#endif /* not _AMU_NFS_PROT_H */
